/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.jmrix.AbstractProgrammerFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResettingOffsetHighCvProgrammerFacade
extends AbstractProgrammerFacade
implements ProgListener {
    int top;
    String addrCV;
    int cvFactor;
    int modulo;
    int indicator;
    int _val;
    int _cv;
    int _startVal;
    private ProgListener _usingProgrammer = null;
    ProgState state = ProgState.NOTPROGRAMMING;
    private static final Logger log = LoggerFactory.getLogger(ResettingOffsetHighCvProgrammerFacade.class);

    public ResettingOffsetHighCvProgrammerFacade(Programmer prog, String top, String addrCV, String cvFactor, String modulo, String indicator) {
        super(prog);
        this.top = Integer.parseInt(top);
        this.addrCV = addrCV;
        this.cvFactor = Integer.parseInt(cvFactor);
        this.modulo = Integer.parseInt(modulo);
        this.indicator = Integer.parseInt(indicator);
    }

    @Override
    public void writeCV(String CV, int val, ProgListener p) throws ProgrammerException {
        log.debug("start writeCV");
        this._cv = Integer.parseInt(CV);
        this._val = val;
        this.useProgrammer(p);
        if (this.prog.getCanWrite(CV) || this._cv <= this.top) {
            this.state = ProgState.PROGRAMMING;
            this.prog.writeCV(CV, val, this);
        } else {
            this.state = ProgState.FINISHWRITE;
            this.prog.writeCV(this.addrCV, this._cv / this.modulo * this.cvFactor + this.indicator, this);
        }
    }

    @Override
    public void readCV(String CV, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p, 0);
    }

    @Override
    public void readCV(String CV, ProgListener p, int startVal) throws ProgrammerException {
        log.debug("start readCV");
        this._cv = Integer.parseInt(CV);
        this._startVal = startVal;
        this.useProgrammer(p);
        if (this.prog.getCanRead(CV) || this._cv <= this.top) {
            this.state = ProgState.PROGRAMMING;
            this.prog.readCV(CV, this, startVal);
        } else {
            this.state = ProgState.FINISHREAD;
            this.prog.writeCV(this.addrCV, this._cv / this.modulo * this.cvFactor + this.indicator, this);
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public void programmingOpReply(int value, int status) {
        if (log.isDebugEnabled()) {
            log.debug("notifyProgListenerEnd value {} status {}", (Object)value, (Object)status);
        }
        if (status != 0) {
            log.debug("Reset and pass abort up");
            ProgListener temp = this._usingProgrammer;
            this._usingProgrammer = null;
            this.state = ProgState.NOTPROGRAMMING;
            temp.programmingOpReply(value, status);
            return;
        }
        if (this._usingProgrammer == null) {
            log.error("No listener to notify, reset and ignore");
            this.state = ProgState.NOTPROGRAMMING;
            return;
        }
        switch (this.state) {
            case FINISHREAD: {
                try {
                    this.state = ProgState.RESET;
                    this.prog.readCV("" + this._cv % this.modulo, this, this._startVal);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing final read", (Throwable)e);
                }
                break;
            }
            case FINISHWRITE: {
                try {
                    this.state = ProgState.RESET;
                    this.prog.writeCV("" + this._cv % this.modulo, this._val, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing final write", (Throwable)e);
                }
                break;
            }
            case RESET: {
                try {
                    this.state = ProgState.PROGRAMMING;
                    this.prog.writeCV(this.addrCV, 0, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing reset write", (Throwable)e);
                }
                break;
            }
            case PROGRAMMING: {
                ProgListener temp = this._usingProgrammer;
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
                temp.programmingOpReply(value, status);
                break;
            }
            default: {
                log.error("Unexpected state on reply: {}", (Object)this.state);
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
            }
        }
    }

    @Override
    public boolean getCanRead() {
        return true;
    }

    @Override
    public boolean getCanRead(String addr) {
        return Integer.parseInt(addr) <= 1024;
    }

    @Override
    public boolean getCanWrite() {
        return true;
    }

    @Override
    public boolean getCanWrite(String addr) {
        return Integer.parseInt(addr) <= 1024;
    }

    static enum ProgState {
        PROGRAMMING,
        FINISHREAD,
        FINISHWRITE,
        RESET,
        NOTPROGRAMMING;

    }
}

