/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Turnout;
import jmri.implementation.DefaultSignalHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SE8cSignalHead
extends DefaultSignalHead {
    NamedBeanHandle<Turnout> lowTurnout;
    NamedBeanHandle<Turnout> highTurnout;
    private static final Logger log = LoggerFactory.getLogger(SE8cSignalHead.class);

    public SE8cSignalHead(NamedBeanHandle<Turnout> lowTO, NamedBeanHandle<Turnout> highTO, String userName) {
        super(SE8cSignalHead.makeSystemName(lowTO, highTO), userName);
        this.lowTurnout = lowTO;
        this.highTurnout = highTO;
        this.init();
    }

    public SE8cSignalHead(NamedBeanHandle<Turnout> lowTO, NamedBeanHandle<Turnout> highTO) {
        super(SE8cSignalHead.makeSystemName(lowTO, highTO));
        this.lowTurnout = lowTO;
        this.highTurnout = highTO;
        this.init();
    }

    public SE8cSignalHead(String sname, NamedBeanHandle<Turnout> lowTO, NamedBeanHandle<Turnout> highTO, String userName) {
        super(sname, userName);
        this.lowTurnout = lowTO;
        this.highTurnout = highTO;
        this.init();
    }

    public SE8cSignalHead(String sname, NamedBeanHandle<Turnout> lowTO, NamedBeanHandle<Turnout> highTO) {
        super(sname);
        this.lowTurnout = lowTO;
        this.highTurnout = highTO;
        this.init();
    }

    public SE8cSignalHead(int pNumber, String userName) {
        super("LH" + pNumber, userName);
        this.lowTurnout = SE8cSignalHead.makeHandle(pNumber);
        this.highTurnout = SE8cSignalHead.makeHandle(pNumber + 1);
        this.init();
    }

    static String makeSystemName(NamedBeanHandle<Turnout> lowTO, NamedBeanHandle<Turnout> highTO) {
        return "IH:SE8c:\"" + lowTO.getName() + "\";\"" + highTO.getName() + "\"";
    }

    static NamedBeanHandle<Turnout> makeHandle(int i) throws IllegalArgumentException {
        String number = "" + i;
        return InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(number, InstanceManager.turnoutManagerInstance().provideTurnout(number));
    }

    public SE8cSignalHead(int pNumber) {
        super("LH" + pNumber);
        this.lowTurnout = SE8cSignalHead.makeHandle(pNumber);
        this.highTurnout = SE8cSignalHead.makeHandle(pNumber + 1);
        this.init();
    }

    void init() {
        this.lowTurnout.getBean().setBinaryOutput(true);
        this.highTurnout.getBean().setBinaryOutput(true);
        this.mAppearance = 0;
        this.updateOutput();
    }

    @Override
    protected void updateOutput() {
        if (!this.mLit) {
            this.highTurnout.getBean().setCommandedState(2);
        } else if (!(this.mFlashOn || this.mAppearance != 32 && this.mAppearance != 8 && this.mAppearance != 2)) {
            this.highTurnout.getBean().setCommandedState(2);
        } else {
            switch (this.mAppearance) {
                case 1: 
                case 2: {
                    this.lowTurnout.getBean().setCommandedState(4);
                    break;
                }
                case 4: 
                case 8: {
                    this.highTurnout.getBean().setCommandedState(4);
                    break;
                }
                case 16: 
                case 32: {
                    this.lowTurnout.getBean().setCommandedState(2);
                    break;
                }
                case 0: {
                    this.highTurnout.getBean().setCommandedState(2);
                    break;
                }
                default: {
                    log.error("Invalid state request: {}", (Object)this.mAppearance);
                }
            }
        }
    }

    public NamedBeanHandle<Turnout> getLow() {
        return this.lowTurnout;
    }

    public NamedBeanHandle<Turnout> getHigh() {
        return this.highTurnout;
    }

    @Override
    public boolean isTurnoutUsed(Turnout t) {
        return this.getLow() != null && t.equals(this.getLow().getBean()) || this.getHigh() != null && t.equals(this.getHigh().getBean());
    }
}

