/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.TurnoutOperator;
import jmri.implementation.AbstractTurnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorTurnoutOperator
extends TurnoutOperator {
    long interval;
    int maxTries;
    int tries = 0;
    PropertyChangeListener listener;
    private static final Logger log = LoggerFactory.getLogger(SensorTurnoutOperator.class);

    public SensorTurnoutOperator(AbstractTurnout t, long i, int mt) {
        super(t);
        this.interval = i;
        this.maxTries = mt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.listener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"}, justification="notify not naked, outside sensor and turnout is shared state")
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("KnownState")) {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        this.notify();
                    }
                }
            }
        };
        this.myTurnout.addPropertyChangeListener(this.listener);
        try {
            this.operatorCheck();
            this.myTurnout.forwardCommandChangeToLayout();
            while (++this.tries < this.maxTries) {
                long remaining;
                long nextTry = System.currentTimeMillis() + this.interval;
                while ((remaining = nextTry - System.currentTimeMillis()) > 0L) {
                    try {
                        SensorTurnoutOperator sensorTurnoutOperator = this;
                        synchronized (sensorTurnoutOperator) {
                            this.wait(remaining);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.myTurnout.isConsistentState()) break;
                this.operatorCheck();
                this.myTurnout.forwardCommandChangeToLayout();
                log.warn("retrying {}, try #{}", (Object)this.myTurnout.getSystemName(), (Object)(this.tries + 1));
            }
            if (!this.myTurnout.isConsistentState()) {
                log.warn("failed to throw {}", (Object)this.myTurnout.getSystemName());
            }
        }
        catch (TurnoutOperator.TurnoutOperatorException turnoutOperatorException) {
            // empty catch block
        }
        this.myTurnout.removePropertyChangeListener(this.listener);
    }
}

