/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import jmri.NamedBeanHandle;
import jmri.Turnout;
import jmri.implementation.Bundle;
import jmri.implementation.DefaultSignalHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleTurnoutSignalHead
extends DefaultSignalHead
implements PropertyChangeListener {
    private int mOnAppearance = 0;
    private int mOffAppearance = 64;
    private int mTurnoutCommandedState = 2;
    private NamedBeanHandle<Turnout> mOutput;
    private static final Logger log = LoggerFactory.getLogger(SingleTurnoutSignalHead.class);

    public SingleTurnoutSignalHead(String sys, String user, NamedBeanHandle<Turnout> lit, int on, int off) {
        super(sys, user);
        this.initialize(lit, on, off);
    }

    public SingleTurnoutSignalHead(String sys, NamedBeanHandle<Turnout> lit, int on, int off) {
        super(sys);
        this.initialize(lit, on, off);
    }

    private void initialize(NamedBeanHandle<Turnout> lit, int on, int off) {
        this.setOutput(lit);
        this.mOnAppearance = on;
        this.mOffAppearance = off;
        switch (lit.getBean().getKnownState()) {
            case 2: {
                this.setAppearance(off);
                break;
            }
            case 4: {
                this.setAppearance(on);
                break;
            }
            default: {
                this.mAppearance = off;
            }
        }
    }

    private void setTurnoutState(int s) {
        this.mTurnoutCommandedState = s;
        this.mOutput.getBean().setCommandedState(s);
    }

    @Override
    protected void updateOutput() {
        if (!this.mLit) {
            this.setTurnoutState(2);
        } else if (!this.mFlashOn && this.mAppearance == this.mOnAppearance * 2) {
            this.setTurnoutState(2);
        } else if (!this.mFlashOn && this.mAppearance == this.mOffAppearance * 2) {
            this.setTurnoutState(4);
        } else if (this.mAppearance == this.mOffAppearance || this.mAppearance == this.mOffAppearance * 2) {
            this.setTurnoutState(2);
        } else if (this.mAppearance == this.mOnAppearance || this.mAppearance == this.mOnAppearance * 2) {
            this.setTurnoutState(4);
        } else {
            log.warn("Unexpected: Single Output Red / Green SignalHeads cannot display new appearance: {}", (Object)this.describeState(this.mAppearance));
        }
    }

    @Override
    public void dispose() {
        this.setOutput(null);
        super.dispose();
    }

    public int getOnAppearance() {
        return this.mOnAppearance;
    }

    public int getOffAppearance() {
        return this.mOffAppearance;
    }

    public void setOnAppearance(int on) {
        int old = this.mOnAppearance;
        this.mOnAppearance = on;
        this.firePropertyChange("ValidStatesChanged", old, on);
    }

    public void setOffAppearance(int off) {
        int old = this.mOffAppearance;
        this.mOffAppearance = off;
        this.firePropertyChange("ValidStatesChanged", old, off);
    }

    public NamedBeanHandle<Turnout> getOutput() {
        return this.mOutput;
    }

    public void setOutput(NamedBeanHandle<Turnout> t) {
        if (this.mOutput != null) {
            this.mOutput.getBean().removePropertyChangeListener(this);
        }
        this.mOutput = t;
        if (this.mOutput != null) {
            this.mOutput.getBean().addPropertyChangeListener(this);
        }
    }

    @Override
    public int[] getValidStates() {
        if (this.mOnAppearance == this.mOffAppearance) {
            int[] validStates = new int[]{this.mOnAppearance, this.mOffAppearance};
            return validStates;
        }
        int[] validStates = this.mOnAppearance == 0 || this.mOffAppearance == 0 ? new int[3] : new int[2];
        int x = 0;
        validStates[x] = this.mOnAppearance;
        ++x;
        if (this.mOffAppearance == 0) {
            validStates[x] = this.mOnAppearance * 2;
            ++x;
        }
        validStates[x] = this.mOffAppearance;
        ++x;
        if (this.mOnAppearance == 0) {
            validStates[x] = this.mOffAppearance * 2;
        }
        return validStates;
    }

    @Override
    public String[] getValidStateKeys() {
        String[] validStateKeys = new String[this.getValidStates().length];
        int i = 0;
        for (int state : this.getValidStates()) {
            validStateKeys[i++] = this.getSignalColorKey(state);
        }
        return validStateKeys;
    }

    @Override
    public String[] getValidStateNames() {
        String[] validStateNames = new String[this.getValidStates().length];
        int i = 0;
        for (int state : this.getValidStates()) {
            validStateNames[i++] = this.getSignalColorName(state);
        }
        return validStateNames;
    }

    @SuppressFBWarnings(value={"SF_SWITCH_FALLTHROUGH"})
    private String getSignalColorKey(int mAppearance) {
        switch (mAppearance) {
            case 1: {
                return "SignalHeadStateRed";
            }
            case 2: {
                return "SignalHeadStateFlashingRed";
            }
            case 4: {
                return "SignalHeadStateYellow";
            }
            case 8: {
                return "SignalHeadStateFlashingYellow";
            }
            case 16: {
                return "SignalHeadStateGreen";
            }
            case 32: {
                return "SignalHeadStateFlashingGreen";
            }
            case 64: {
                return "SignalHeadStateLunar";
            }
            case 128: {
                return "SignalHeadStateFlashingLunar";
            }
            default: {
                log.warn("Unexpected appearance: {}", (Object)mAppearance);
            }
            case 0: 
        }
        return "SignalHeadStateDark";
    }

    private String getSignalColorName(int mAppearance) {
        return Bundle.getMessage(this.getSignalColorKey(mAppearance));
    }

    @Override
    public boolean isTurnoutUsed(Turnout t) {
        return this.getOutput() != null && t.equals(this.getOutput().getBean());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int newTurnoutValue;
        if (evt.getSource().equals(this.mOutput.getBean()) && evt.getPropertyName().equals("KnownState") && this.mTurnoutCommandedState != (newTurnoutValue = ((Integer)evt.getNewValue()).intValue())) {
            int oldAppearance = this.mAppearance;
            int newAppearance = this.mAppearance;
            if (newTurnoutValue == 2) {
                newAppearance = this.mOffAppearance;
            }
            if (newTurnoutValue == 4) {
                newAppearance = this.mOnAppearance;
            }
            if (newAppearance != oldAppearance) {
                this.mAppearance = newAppearance;
                this.mTurnoutCommandedState = newTurnoutValue;
                this.firePropertyChange("Appearance", oldAppearance, newAppearance);
            }
        }
    }
}

