/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Turnout;
import jmri.implementation.AbstractSignalMast;
import jmri.implementation.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutSignalMast
extends AbstractSignalMast {
    private static final String THE_MAST_TYPE = "IF$tsm";
    private TurnoutAspect unLit = null;
    private final HashMap<String, TurnoutAspect> turnouts = new HashMap();
    private boolean resetPreviousStates = false;
    protected static volatile int lastRef = 0;
    private static final Logger log = LoggerFactory.getLogger(TurnoutSignalMast.class);

    public TurnoutSignalMast(String systemName, String userName) {
        super(systemName, userName);
        this.configureFromName(systemName);
    }

    public TurnoutSignalMast(String systemName) {
        super(systemName);
        this.configureFromName(systemName);
    }

    private void configureFromName(String systemName) {
        String[] parts = systemName.split(":");
        if (parts.length < 3) {
            log.error("SignalMast system name needs at least three parts: {}", (Object)systemName);
            throw new IllegalArgumentException("System name needs at least three parts: " + systemName);
        }
        if (!parts[0].equals(THE_MAST_TYPE)) {
            log.warn("SignalMast system name should start with {} but is {}", (Object)THE_MAST_TYPE, (Object)systemName);
        }
        String system = parts[1];
        String mast = parts[2];
        mast = mast.substring(0, mast.indexOf("("));
        this.setMastType(mast);
        String tmp = parts[2].substring(parts[2].indexOf("($") + 2, parts[2].indexOf(")"));
        try {
            int autoNumber = Integer.parseInt(tmp);
            if (autoNumber > TurnoutSignalMast.getLastRef()) {
                TurnoutSignalMast.setLastRef(autoNumber);
            }
        }
        catch (NumberFormatException e) {
            log.warn("Auto generated SystemName {} is not in the correct format", (Object)systemName);
        }
        this.configureSignalSystemDefinition(system);
        this.configureAspectTable(system, mast);
    }

    @Override
    public void setAspect(@Nonnull String aspect) {
        if (!this.map.checkAspect(aspect)) {
            log.warn("attempting to set invalid aspect: {} on mast: {}", (Object)aspect, (Object)this.getDisplayName());
            throw new IllegalArgumentException("attempting to set invalid aspect: " + aspect + " on mast: " + this.getDisplayName());
        }
        if (this.disabledAspects.contains(aspect)) {
            log.warn("attempting to set an aspect that has been disabled: {} on mast: {}", (Object)aspect, (Object)this.getDisplayName());
            throw new IllegalArgumentException("attempting to set an aspect that has been disabled: " + aspect + " on mast: " + this.getDisplayName());
        }
        if (this.getLit()) {
            if (this.resetPreviousStates) {
                for (Map.Entry<String, TurnoutAspect> entry : this.turnouts.entrySet()) {
                    String appearance = entry.getKey();
                    TurnoutAspect aspt = entry.getValue();
                    if (this.isAspectDisabled(appearance)) continue;
                    int setState = 2;
                    if (aspt.getTurnoutState() == 2) {
                        setState = 4;
                    }
                    if (aspt.getTurnout() != null) {
                        if (aspt.getTurnout().getKnownState() == setState) continue;
                        aspt.getTurnout().setCommandedState(setState);
                        continue;
                    }
                    log.error("Trying to reset \"{}\" on signal mast \"{}\" which has not been configured", (Object)appearance, (Object)this.getDisplayName());
                }
            }
            if (this.turnouts.get(aspect) != null && this.turnouts.get(aspect).getTurnout() != null) {
                Turnout turnToSet = this.turnouts.get(aspect).getTurnout();
                int stateToSet = this.turnouts.get(aspect).getTurnoutState();
                turnToSet.setCommandedState(stateToSet);
            } else {
                log.error("Trying to set \"{}\" on signal mast \"{}\" which has not been configured", (Object)aspect, (Object)this.getDisplayName());
            }
        } else {
            log.debug("Mast set to unlit, will not send aspect change to hardware");
        }
        super.setAspect(aspect);
    }

    public void setUnLitTurnout(String turnoutName, int turnoutState) {
        this.unLit = new TurnoutAspect(turnoutName, turnoutState);
    }

    public String getUnLitTurnoutName() {
        if (this.unLit != null) {
            return this.unLit.getTurnoutName();
        }
        return null;
    }

    public Turnout getUnLitTurnout() {
        if (this.unLit != null) {
            return this.unLit.getTurnout();
        }
        return null;
    }

    public int getUnLitTurnoutState() {
        if (this.unLit != null) {
            return this.unLit.getTurnoutState();
        }
        return -1;
    }

    @Override
    public void setLit(boolean newLit) {
        if (!this.allowUnLit() || newLit == this.getLit()) {
            return;
        }
        super.setLit(newLit);
        if (newLit) {
            String litAspect = this.getAspect();
            if (litAspect != null) {
                this.setAspect(litAspect);
            }
        } else if (this.unLit != null) {
            Turnout t = this.unLit.getTurnout();
            if (t != null && t.getKnownState() != this.getUnLitTurnoutState()) {
                t.setCommandedState(this.getUnLitTurnoutState());
            }
        } else {
            for (TurnoutAspect tAspect : this.turnouts.values()) {
                int setState = 2;
                if (tAspect.getTurnoutState() == 2) {
                    setState = 4;
                }
                if (tAspect.getTurnout().getKnownState() == setState) continue;
                tAspect.getTurnout().setCommandedState(setState);
            }
        }
    }

    public String getTurnoutName(String appearance) {
        TurnoutAspect tAspect = this.turnouts.get(appearance);
        if (tAspect != null) {
            return tAspect.getTurnoutName();
        }
        return "";
    }

    public int getTurnoutState(String appearance) {
        TurnoutAspect tAspect = this.turnouts.get(appearance);
        if (tAspect != null) {
            return tAspect.getTurnoutState();
        }
        return -1;
    }

    public void setTurnout(String appearance, String turn, int state) {
        if (this.turnouts.containsKey(appearance)) {
            log.debug("Appearance {} is already defined so will override", (Object)appearance);
            this.turnouts.remove(appearance);
        }
        this.turnouts.put(appearance, new TurnoutAspect(turn, state));
    }

    public void resetPreviousStates(boolean boo) {
        this.resetPreviousStates = boo;
    }

    public boolean resetPreviousStates() {
        return this.resetPreviousStates;
    }

    public boolean isTurnoutUsed(Turnout t) {
        for (TurnoutAspect ta : this.turnouts.values()) {
            if (!t.equals(ta.getTurnout())) continue;
            return true;
        }
        return t.equals(this.getUnLitTurnout());
    }

    public List<NamedBeanHandle<Turnout>> getHeadsUsed() {
        return new ArrayList<NamedBeanHandle<Turnout>>();
    }

    protected static void setLastRef(int newVal) {
        lastRef = newVal;
    }

    public static int getLastRef() {
        return lastRef;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName()) && evt.getOldValue() instanceof Turnout && this.isTurnoutUsed((Turnout)evt.getOldValue())) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
            throw new PropertyVetoException(Bundle.getMessage("InUseTurnoutSignalMastVeto", this.getDisplayName()), e);
        }
    }

    private static class TurnoutAspect {
        NamedBeanHandle<Turnout> namedTurnout;
        int state;

        TurnoutAspect(String turnoutName, int turnoutState) {
            if (turnoutName != null && !turnoutName.isEmpty()) {
                this.state = turnoutState;
                Turnout turn = InstanceManager.turnoutManagerInstance().getTurnout(turnoutName);
                if (turn == null) {
                    log.error("TurnoutAspect couldn't locate turnout {}", (Object)turnoutName);
                    return;
                }
                this.namedTurnout = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(turnoutName, turn);
            }
        }

        Turnout getTurnout() {
            if (this.namedTurnout == null) {
                return null;
            }
            return this.namedTurnout.getBean();
        }

        String getTurnoutName() {
            if (this.namedTurnout == null) {
                return null;
            }
            return this.namedTurnout.getName();
        }

        int getTurnoutState() {
            return this.state;
        }
    }
}

