/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import javax.annotation.Nonnull;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.jmrix.AbstractProgrammerFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyWriteProgrammerFacade
extends AbstractProgrammerFacade
implements ProgListener {
    int _val;
    String _cv;
    private ProgListener _usingProgrammer = null;
    ProgState state = ProgState.NOTPROGRAMMING;
    private static final Logger log = LoggerFactory.getLogger(VerifyWriteProgrammerFacade.class);

    public VerifyWriteProgrammerFacade(Programmer prog) {
        super(prog);
    }

    @Override
    public synchronized void writeCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this._val = val;
        this._cv = CV;
        this.useProgrammer(p);
        this.state = ProgState.FINISHWRITE;
        this.prog.writeCV(CV, val, this);
    }

    @Override
    public synchronized void readCV(String CV, ProgListener p) throws ProgrammerException {
        this._cv = CV;
        this.useProgrammer(p);
        this.state = ProgState.READING;
        this.prog.readCV(CV, this);
    }

    @Override
    @Nonnull
    public Programmer.WriteConfirmMode getWriteConfirmMode(String addr) {
        if (this.prog.getCanRead(addr)) {
            return Programmer.WriteConfirmMode.ReadAfterWrite;
        }
        return this.prog.getWriteConfirmMode(addr);
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public void programmingOpReply(int value, int status) {
        log.debug("notifyProgListenerEnd value {} status {} ", (Object)value, (Object)status);
        if (status != 0) {
            ProgListener temp = this._usingProgrammer;
            this._usingProgrammer = null;
            this.state = ProgState.NOTPROGRAMMING;
            temp.programmingOpReply(value, status);
            return;
        }
        if (this._usingProgrammer == null) {
            log.error("No listener to notify, reset and ignore");
            this.state = ProgState.NOTPROGRAMMING;
            return;
        }
        ProgListener temp = this._usingProgrammer;
        switch (this.state) {
            case FINISHWRITE: {
                if (this.prog.getCanRead(this._cv) && !this.prog.getWriteConfirmMode(this._cv).equals((Object)Programmer.WriteConfirmMode.ReadAfterWrite)) {
                    this.state = ProgState.FINISHREAD;
                    try {
                        this.prog.readCV(this._cv, this);
                        break;
                    }
                    catch (ProgrammerException e) {
                        this._usingProgrammer = null;
                        this.state = ProgState.NOTPROGRAMMING;
                        temp.programmingOpReply(value, 64);
                        return;
                    }
                }
            }
            case READING: {
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
                temp.programmingOpReply(value, status);
                break;
            }
            case FINISHREAD: {
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
                if (value == this._val) {
                    temp.programmingOpReply(value, status);
                    break;
                }
                temp.programmingOpReply(value, 64);
                break;
            }
            default: {
                log.error("Unexpected state on reply: {}", (Object)this.state);
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
            }
        }
    }

    static enum ProgState {
        READING,
        FINISHWRITE,
        FINISHREAD,
        NOTPROGRAMMING;

    }
}

