/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import javax.annotation.Nonnull;
import jmri.implementation.AbstractSignalMast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualSignalMast
extends AbstractSignalMast {
    private static final String THE_MAST_TYPE = "IF$vsm";
    private static volatile int lastRef = 0;
    private static final Logger log = LoggerFactory.getLogger(VirtualSignalMast.class);

    public VirtualSignalMast(String systemName, String userName) {
        super(systemName, userName);
        this.configureFromName(systemName);
    }

    public VirtualSignalMast(String systemName) {
        super(systemName);
        this.configureFromName(systemName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureFromName(String systemName) {
        String[] parts = systemName.split(":");
        if (parts.length < 3) {
            log.error("SignalMast system name needs at least three parts: {}", (Object)systemName);
            throw new IllegalArgumentException("System name needs at least three parts: " + systemName);
        }
        if (!parts[0].equals(THE_MAST_TYPE)) {
            log.warn("SignalMast system name should start with {} but is {}", (Object)THE_MAST_TYPE, (Object)systemName);
        }
        String system = parts[1];
        String mast = parts[2];
        mast = mast.substring(0, mast.indexOf("("));
        this.setMastType(mast);
        String tmp = parts[2].substring(parts[2].indexOf("($") + 2, parts[2].indexOf(")"));
        try {
            int autoNumber = Integer.parseInt(tmp);
            Class<VirtualSignalMast> clazz = VirtualSignalMast.class;
            synchronized (VirtualSignalMast.class) {
                if (autoNumber > VirtualSignalMast.getLastRef()) {
                    VirtualSignalMast.setLastRef(autoNumber);
                }
                // ** MonitorExit[var7_8] (shouldn't be in output)
            }
        }
        catch (NumberFormatException e) {
            log.warn("Auto generated SystemName {} is not in the correct format", (Object)systemName);
        }
        {
            this.configureSignalSystemDefinition(system);
            this.configureAspectTable(system, mast);
            return;
        }
    }

    @Override
    public void setAspect(@Nonnull String aspect) {
        if (!this.map.checkAspect(aspect)) {
            log.warn("attempting to set invalid aspect: {} on mast: {}", (Object)aspect, (Object)this.getDisplayName());
            throw new IllegalArgumentException("attempting to set invalid aspect: " + aspect + " on mast: " + this.getDisplayName());
        }
        if (this.disabledAspects.contains(aspect)) {
            log.warn("attempting to set an aspect that has been disabled: {} on mast: {}", (Object)aspect, (Object)this.getDisplayName());
            throw new IllegalArgumentException("attempting to set an aspect that has been disabled: " + aspect + " on mast: " + this.getDisplayName());
        }
        super.setAspect(aspect);
    }

    protected static void setLastRef(int newVal) {
        lastRef = newVal;
    }

    public static int getLastRef() {
        return lastRef;
    }
}

