/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.configurexml;

import java.util.Enumeration;
import java.util.List;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalAppearanceMap;
import jmri.SignalMastManager;
import jmri.implementation.DccSignalMast;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DccSignalMastXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(DccSignalMastXml.class);

    @Override
    public Element store(Object o) {
        List<String> disabledAspects;
        DccSignalMast p = (DccSignalMast)o;
        Element e = new Element("dccsignalmast");
        e.setAttribute("class", this.getClass().getName());
        e.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, e);
        Element unlit = new Element("unlit");
        if (p.allowUnLit()) {
            unlit.setAttribute("allowed", "yes");
            unlit.addContent((Content)new Element("aspect").addContent(Integer.toString(p.getUnlitId())));
        } else {
            unlit.setAttribute("allowed", "no");
        }
        e.addContent((Content)unlit);
        if (p.useAddressOffSet()) {
            e.addContent((Content)new Element("useAddressOffSet").addContent("yes"));
        }
        e.addContent((Content)new Element("packetsendcount").addContent(Integer.toString(p.getDccSignalMastPacketSendCount())));
        SignalAppearanceMap appMap = p.getAppearanceMap();
        if (appMap != null) {
            Enumeration<String> aspects = appMap.getAspects();
            while (aspects.hasMoreElements()) {
                String key = aspects.nextElement();
                Element el = new Element("aspect");
                el.setAttribute("defines", key);
                el.addContent((Content)new Element("number").addContent(Integer.toString(p.getOutputForAppearance(key))));
                e.addContent((Content)el);
            }
        }
        if ((disabledAspects = p.getDisabledAspects()) != null) {
            Element el = new Element("disabledAspects");
            for (String aspect : disabledAspects) {
                Element ele = new Element("disabledAspect");
                ele.addContent(aspect);
                el.addContent((Content)ele);
            }
            if (disabledAspects.size() != 0) {
                e.addContent((Content)el);
            }
        }
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        DccSignalMast m;
        String sys = this.getSystemName(shared);
        try {
            m = (DccSignalMast)InstanceManager.getDefault(SignalMastManager.class).provideCustomSignalMast(sys, DccSignalMast.class);
        }
        catch (JmriException e) {
            log.error("Failed to load DccSignalMast {}", (Object)sys, (Object)e);
            return false;
        }
        if (this.getUserName(shared) != null) {
            m.setUserName(this.getUserName(shared));
        }
        if (shared.getChild("useAddressOffSet") != null && shared.getChild("useAddressOffSet").getText().equals("yes")) {
            m.useAddressOffSet(true);
        }
        if (shared.getChild("packetsendcount") != null) {
            m.setDccSignalMastPacketSendCount(Integer.parseInt(shared.getChild("packetsendcount").getValue()));
        }
        return this.loadCommonDCCMast(m, shared);
    }

    protected boolean loadCommonDCCMast(DccSignalMast m, Element element) {
        Element unlit;
        this.loadCommon(m, element);
        if (element.getChild("unlit") != null && (unlit = element.getChild("unlit")).getAttribute("allowed") != null) {
            if (unlit.getAttribute("allowed").getValue().equals("no")) {
                m.setAllowUnLit(false);
            } else {
                m.setAllowUnLit(true);
                m.setUnlitId(Integer.parseInt(unlit.getChild("aspect").getValue()));
            }
        }
        List list = element.getChildren("aspect");
        for (int i = 0; i < list.size(); ++i) {
            Element e = (Element)list.get(i);
            String aspect = e.getAttribute("defines").getValue();
            int number = -1;
            try {
                String value = e.getChild("number").getValue();
                number = Integer.parseInt(value);
            }
            catch (Exception ex) {
                log.error("failed to convert DCC number");
            }
            m.setOutputForAppearance(aspect, number);
        }
        Element e = element.getChild("disabledAspects");
        if (e != null) {
            list = e.getChildren("disabledAspect");
            for (String aspect : list) {
                m.setAspectDisabled(aspect.getText());
            }
        }
        return true;
    }
}

