/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.implementation.LsDecSignalHead;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsDecSignalHeadXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(LsDecSignalHeadXml.class);

    @Override
    public Element store(Object o) {
        LsDecSignalHead p = (LsDecSignalHead)o;
        Element element = new Element("signalhead");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        element.addContent((Content)this.addTurnoutElement(p.getGreen().getName(), p.getGreenState()));
        element.addContent((Content)this.addTurnoutElement(p.getYellow().getName(), p.getYellowState()));
        element.addContent((Content)this.addTurnoutElement(p.getRed().getName(), p.getRedState()));
        element.addContent((Content)this.addTurnoutElement(p.getFlashGreen().getName(), p.getFlashGreenState()));
        element.addContent((Content)this.addTurnoutElement(p.getFlashYellow().getName(), p.getFlashYellowState()));
        element.addContent((Content)this.addTurnoutElement(p.getFlashRed().getName(), p.getFlashRedState()));
        element.addContent((Content)this.addTurnoutElement(p.getDark().getName(), p.getDarkState()));
        return element;
    }

    Element addTurnoutElement(String name, int s) {
        int state = s;
        Element el = new Element("turnout");
        el.setAttribute("systemName", name);
        if (state == 4) {
            el.setAttribute("state", "THROWN");
        } else {
            el.setAttribute("state", "CLOSED");
        }
        return el;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        List l = shared.getChildren("turnout");
        NamedBeanHandle<Turnout> green = this.loadTurnout(l.get(0));
        NamedBeanHandle<Turnout> yellow = this.loadTurnout(l.get(1));
        NamedBeanHandle<Turnout> red = this.loadTurnout(l.get(2));
        NamedBeanHandle<Turnout> flashgreen = this.loadTurnout(l.get(3));
        NamedBeanHandle<Turnout> flashyellow = this.loadTurnout(l.get(4));
        NamedBeanHandle<Turnout> flashred = this.loadTurnout(l.get(5));
        NamedBeanHandle<Turnout> dark = this.loadTurnout(l.get(6));
        int greenstatus = this.loadTurnoutStatus(l.get(0));
        int yellowstatus = this.loadTurnoutStatus(l.get(1));
        int redstatus = this.loadTurnoutStatus(l.get(2));
        int flashgreenstatus = this.loadTurnoutStatus(l.get(3));
        int flashyellowstatus = this.loadTurnoutStatus(l.get(4));
        int flashredstatus = this.loadTurnoutStatus(l.get(5));
        int darkstatus = this.loadTurnoutStatus(l.get(6));
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        LsDecSignalHead h = uname == null ? new LsDecSignalHead(sys, green, greenstatus, yellow, yellowstatus, red, redstatus, flashgreen, flashgreenstatus, flashyellow, flashyellowstatus, flashred, flashredstatus, dark, darkstatus) : new LsDecSignalHead(sys, uname, green, greenstatus, yellow, yellowstatus, red, redstatus, flashgreen, flashgreenstatus, flashyellow, flashyellowstatus, flashred, flashredstatus, dark, darkstatus);
        this.loadCommon(h, shared);
        SignalHead existingBean = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(sys);
        if (existingBean != null && existingBean != h) {
            log.error("systemName is already registered: {}", (Object)sys);
        } else {
            InstanceManager.getDefault(SignalHeadManager.class).register(h);
        }
        return true;
    }

    NamedBeanHandle<Turnout> loadTurnout(Object o) {
        Element e = (Element)o;
        String name = e.getAttribute("systemName").getValue();
        Turnout t = InstanceManager.turnoutManagerInstance().getTurnout(name);
        if (t != null) {
            return InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, t);
        }
        log.warn("Failed to find turnout {}. Check connection and configuration", (Object)name);
        return null;
    }

    int loadTurnoutStatus(Object o) {
        Element e = (Element)o;
        String rState = e.getAttribute("state").getValue();
        int tSetState = 2;
        if (rState.equals("THROWN")) {
            tSetState = 4;
        }
        return tSetState;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }
}

