/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.implementation.MergSD2SignalHead;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergSD2SignalHeadXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(MergSD2SignalHeadXml.class);

    @Override
    public Element store(Object o) {
        MergSD2SignalHead p = (MergSD2SignalHead)o;
        Element element = new Element("signalhead");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        element.setAttribute("aspects", "" + p.getAspects());
        if (p.getFeather()) {
            element.setAttribute("feather", "yes");
        }
        this.storeCommon(p, element);
        int aspects = p.getAspects();
        switch (aspects) {
            case 2: {
                element.addContent((Content)this.addTurnoutElement(p.getInput1(), "input1", p));
                if (p.getHome()) break;
                element.setAttribute("home", "no");
                break;
            }
            case 3: {
                element.addContent((Content)this.addTurnoutElement(p.getInput1(), "input1", p));
                element.addContent((Content)this.addTurnoutElement(p.getInput2(), "input2", p));
                break;
            }
            case 4: {
                element.addContent((Content)this.addTurnoutElement(p.getInput1(), "input1", p));
                element.addContent((Content)this.addTurnoutElement(p.getInput2(), "input2", p));
                element.addContent((Content)this.addTurnoutElement(p.getInput3(), "input3", p));
                break;
            }
            default: {
                log.error("incorrect number of aspects {} for Signal {}", (Object)aspects, (Object)p.getDisplayName());
            }
        }
        return element;
    }

    Element addTurnoutElement(NamedBeanHandle<Turnout> to, String which, SignalHead p) {
        Element el = new Element("turnoutname");
        el.setAttribute("defines", which);
        if (to == null) {
            log.error("No Turnout found for MergSD2 Head {}", (Object)p.getDisplayName());
        } else {
            el.addContent(to.getName());
        }
        return el;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        Attribute aspectsAttr;
        int aspects = 2;
        List l = shared.getChildren("turnoutname");
        if (l.isEmpty()) {
            l = shared.getChildren("turnout");
            aspects = l.size() + 1;
        }
        NamedBeanHandle<Turnout> input1 = null;
        NamedBeanHandle<Turnout> input2 = null;
        NamedBeanHandle<Turnout> input3 = null;
        String yesno = "";
        boolean feather = false;
        boolean home = true;
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        if (shared.getAttribute("feather") != null) {
            yesno = shared.getAttribute("feather").getValue();
        }
        if (yesno != null && !yesno.equals("")) {
            if (yesno.equals("yes")) {
                feather = true;
            } else if (yesno.equals("no")) {
                feather = false;
            }
        }
        if (shared.getAttribute("home") != null) {
            yesno = shared.getAttribute("home").getValue();
        }
        if (yesno != null && !yesno.equals("")) {
            if (yesno.equals("yes")) {
                home = true;
            } else if (yesno.equals("no")) {
                home = false;
            }
        }
        if ((aspectsAttr = shared.getAttribute("aspects")) != null) {
            try {
                aspects = aspectsAttr.getIntValue();
            }
            catch (DataConversionException e) {
                log.warn("Could not parse aspects attribute! {}", (Object)e.getMessage());
            }
        }
        switch (aspects) {
            case 2: {
                input1 = this.loadTurnout(l.get(0));
                break;
            }
            case 3: {
                input1 = this.loadTurnout(l.get(0));
                input2 = this.loadTurnout(l.get(1));
                break;
            }
            case 4: {
                input1 = this.loadTurnout(l.get(0));
                input2 = this.loadTurnout(l.get(1));
                input3 = this.loadTurnout(l.get(2));
                break;
            }
            default: {
                log.error("incorrect number of aspects {} when loading Signal {}", (Object)aspects, (Object)sys);
            }
        }
        MergSD2SignalHead h = uname == null ? new MergSD2SignalHead(sys, aspects, input1, input2, input3, feather, home) : new MergSD2SignalHead(sys, uname, aspects, input1, input2, input3, feather, home);
        this.loadCommon(h, shared);
        SignalHead existingBean = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(sys);
        if (existingBean != null && existingBean != h) {
            log.error("systemName is already registered: {}", (Object)sys);
        } else {
            InstanceManager.getDefault(SignalHeadManager.class).register(h);
        }
        return true;
    }

    NamedBeanHandle<Turnout> loadTurnout(Object o) {
        Element e = (Element)o;
        if (e.getName().equals("turnout")) {
            Turnout t;
            String name = e.getAttribute("systemName").getValue();
            if (e.getAttribute("userName") != null && !e.getAttribute("userName").getValue().equals("")) {
                name = e.getAttribute("userName").getValue();
                t = InstanceManager.turnoutManagerInstance().getTurnout(name);
            } else {
                t = InstanceManager.turnoutManagerInstance().getBySystemName(name);
            }
            if (t != null) {
                return InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, t);
            }
            log.warn("Failed to find turnout {}. Check connection and configuration", (Object)name);
            return null;
        }
        String name = e.getText();
        try {
            Turnout t = InstanceManager.turnoutManagerInstance().provideTurnout(name);
            return InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, t);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Failed to provide Turnout \"{}\" in loadTurnout", (Object)name);
            return null;
        }
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }
}

