/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.implementation.SE8cSignalHead;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SE8cSignalHeadXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(SE8cSignalHeadXml.class);

    @Override
    public Element store(Object o) {
        SE8cSignalHead p = (SE8cSignalHead)o;
        Element element = new Element("signalhead");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        element.addContent((Content)this.addTurnoutElement(p.getLow(), "low"));
        element.addContent((Content)this.addTurnoutElement(p.getHigh(), "high"));
        return element;
    }

    Element addTurnoutElement(NamedBeanHandle<Turnout> to, String which) {
        Element el = new Element("turnoutname");
        el.setAttribute("defines", which);
        el.addContent(to.getName());
        return el;
    }

    Element addTurnoutElement(Turnout to) {
        String user = to.getUserName();
        String sys = to.getSystemName();
        Element el = new Element("turnout");
        el.setAttribute("systemName", sys);
        if (user != null) {
            el.setAttribute("userName", user);
        }
        return el;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        List l = shared.getChildren("turnoutname");
        if (l.size() == 0) {
            l = shared.getChildren("turnout");
        }
        NamedBeanHandle<Turnout> low = this.loadTurnout(l.get(0));
        NamedBeanHandle<Turnout> high = this.loadTurnout(l.get(1));
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        SE8cSignalHead h = uname == null ? new SE8cSignalHead(sys, low, high) : new SE8cSignalHead(sys, low, high, uname);
        this.loadCommon(h, shared);
        SignalHead existingBean = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(sys);
        if (existingBean != null && existingBean != h) {
            log.error("systemName is already registered: {}", (Object)sys);
        } else {
            InstanceManager.getDefault(SignalHeadManager.class).register(h);
        }
        return true;
    }

    NamedBeanHandle<Turnout> loadTurnout(Object o) {
        Element e = (Element)o;
        if (e.getName().equals("turnout")) {
            Turnout t;
            String name = e.getAttribute("systemName").getValue();
            if (e.getAttribute("userName") != null && !e.getAttribute("userName").getValue().equals("")) {
                name = e.getAttribute("userName").getValue();
                t = InstanceManager.turnoutManagerInstance().getTurnout(name);
            } else {
                t = InstanceManager.turnoutManagerInstance().getBySystemName(name);
            }
            if (t != null) {
                return InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, t);
            }
            log.warn("Failed to find turnout {}. Check connection and configuration", (Object)name);
            return null;
        }
        String name = e.getText();
        try {
            Turnout t = InstanceManager.turnoutManagerInstance().provideTurnout(name);
            return InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(name, t);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Failed to provide Turnout \"{}\" in loadTurnout", (Object)name);
            return null;
        }
    }
}

