/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.configurexml;

import java.util.Enumeration;
import java.util.List;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalAppearanceMap;
import jmri.SignalMastManager;
import jmri.implementation.TurnoutSignalMast;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutSignalMastXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(TurnoutSignalMastXml.class);

    @Override
    public Element store(Object o) {
        List<String> disabledAspects;
        TurnoutSignalMast p = (TurnoutSignalMast)o;
        Element e = new Element("turnoutsignalmast");
        e.setAttribute("class", this.getClass().getName());
        e.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, e);
        Element unlit = new Element("unlit");
        if (p.allowUnLit()) {
            unlit.setAttribute("allowed", "yes");
            unlit.addContent((Content)new Element("turnout").addContent(p.getUnLitTurnoutName()));
            if (p.getUnLitTurnoutState() == 2) {
                unlit.addContent((Content)new Element("turnoutstate").addContent("closed"));
            } else {
                unlit.addContent((Content)new Element("turnoutstate").addContent("thrown"));
            }
        } else {
            unlit.setAttribute("allowed", "no");
        }
        e.addContent((Content)unlit);
        SignalAppearanceMap appMap = p.getAppearanceMap();
        if (appMap != null) {
            Enumeration<String> aspects = appMap.getAspects();
            while (aspects.hasMoreElements()) {
                String key = aspects.nextElement();
                Element el = new Element("aspect");
                el.setAttribute("defines", key);
                el.addContent((Content)new Element("turnout").addContent(p.getTurnoutName(key)));
                if (p.getTurnoutState(key) == 2) {
                    el.addContent((Content)new Element("turnoutstate").addContent("closed"));
                } else {
                    el.addContent((Content)new Element("turnoutstate").addContent("thrown"));
                }
                e.addContent((Content)el);
            }
        }
        if ((disabledAspects = p.getDisabledAspects()) != null) {
            Element el = new Element("disabledAspects");
            for (String aspect : disabledAspects) {
                Element ele = new Element("disabledAspect");
                ele.addContent(aspect);
                el.addContent((Content)ele);
            }
            if (disabledAspects.size() != 0) {
                e.addContent((Content)el);
            }
        }
        if (p.resetPreviousStates()) {
            e.addContent((Content)new Element("resetPreviousStates").addContent("yes"));
        }
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        Element unlit;
        TurnoutSignalMast m;
        String sys = this.getSystemName(shared);
        try {
            m = (TurnoutSignalMast)InstanceManager.getDefault(SignalMastManager.class).provideCustomSignalMast(sys, TurnoutSignalMast.class);
        }
        catch (JmriException e) {
            log.error("Failed to load TurnoutSignalMast {}", (Object)sys, (Object)e);
            return false;
        }
        if (this.getUserName(shared) != null) {
            m.setUserName(this.getUserName(shared));
        }
        this.loadCommon(m, shared);
        if (shared.getChild("unlit") != null && (unlit = shared.getChild("unlit")).getAttribute("allowed") != null) {
            if (unlit.getAttribute("allowed").getValue().equals("no")) {
                m.setAllowUnLit(false);
            } else {
                m.setAllowUnLit(true);
                String turnout = unlit.getChild("turnout").getText();
                String turnoutState = unlit.getChild("turnoutstate").getText();
                int turnState = 4;
                if (turnoutState.equals("closed")) {
                    turnState = 2;
                }
                m.setUnLitTurnout(turnout, turnState);
            }
        }
        List list = shared.getChildren("aspect");
        for (int i = 0; i < list.size(); ++i) {
            Element e = (Element)list.get(i);
            String aspect = e.getAttribute("defines").getValue();
            String turnout = e.getChild("turnout").getText();
            String turnoutState = e.getChild("turnoutstate").getText();
            int turnState = 4;
            if (turnoutState.equals("closed")) {
                turnState = 2;
            }
            m.setTurnout(aspect, turnout, turnState);
        }
        Element e = shared.getChild("disabledAspects");
        if (e != null) {
            list = e.getChildren("disabledAspect");
            for (Element aspect : list) {
                m.setAspectDisabled(aspect.getText());
            }
        }
        if (shared.getChild("resetPreviousStates") != null && shared.getChild("resetPreviousStates").getText().equals("yes")) {
            m.resetPreviousStates(true);
        }
        return true;
    }
}

