/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.configurexml;

import jmri.InstanceManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.implementation.VirtualSignalHead;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualSignalHeadXml
extends AbstractNamedBeanManagerConfigXML {
    private static final Logger log = LoggerFactory.getLogger(VirtualSignalHeadXml.class);

    @Override
    public Element store(Object o) {
        VirtualSignalHead p = (VirtualSignalHead)o;
        Element element = new Element("signalhead");
        element.setAttribute("class", this.getClass().getName());
        element.addContent((Content)new Element("systemName").addContent(p.getSystemName()));
        this.storeCommon(p, element);
        return element;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        String sys = this.getSystemName(shared);
        String uname = this.getUserName(shared);
        VirtualSignalHead h = uname == null ? new VirtualSignalHead(sys) : new VirtualSignalHead(sys, uname);
        this.loadCommon(h, shared);
        SignalHead existingBean = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(sys);
        if (existingBean != null && existingBean != h) {
            log.error("systemName is already registered: {}", (Object)sys);
        } else {
            InstanceManager.getDefault(SignalHeadManager.class).register(h);
        }
        return true;
    }
}

