/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation.decorators;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.NamedBean;
import jmri.beans.BeanUtil;

public abstract class AbstractNamedBeanDecorator
implements NamedBean {
    private NamedBean decorated;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected final HashMap<PropertyChangeListener, String> register = new HashMap();
    protected final HashMap<PropertyChangeListener, String> listenerRefs = new HashMap();

    protected AbstractNamedBeanDecorator(NamedBean decorated) {
        this.decorated = decorated;
    }

    @Override
    public final String getComment() {
        return this.decorated.getComment();
    }

    @Override
    public final void setComment(String comment) {
        this.decorated.setComment(comment);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public final String getDisplayName() {
        return this.decorated.getDisplayName();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public final String getDisplayName(NamedBean.DisplayOptions displayOptions) {
        return this.decorated.getDisplayName(displayOptions);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(@Nonnull PropertyChangeListener l, String beanRef, String listenerRef) {
        this.pcs.addPropertyChangeListener(l);
        if (beanRef != null) {
            this.register.put(l, beanRef);
        }
        if (listenerRef != null) {
            this.listenerRefs.put(l, listenerRef);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(@Nonnull String propertyName, @Nonnull PropertyChangeListener l, String beanRef, String listenerRef) {
        this.pcs.addPropertyChangeListener(propertyName, l);
        if (beanRef != null) {
            this.register.put(l, beanRef);
        }
        if (listenerRef != null) {
            this.listenerRefs.put(l, listenerRef);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
        if (listener != null && !BeanUtil.contains(this.pcs.getPropertyChangeListeners(), listener)) {
            this.register.remove(listener);
            this.listenerRefs.remove(listener);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
        if (listener != null && !BeanUtil.contains(this.pcs.getPropertyChangeListeners(), listener)) {
            this.register.remove(listener);
            this.listenerRefs.remove(listener);
        }
    }

    @Override
    @Nonnull
    public synchronized PropertyChangeListener[] getPropertyChangeListenersByReference(@Nonnull String name) {
        ArrayList list = new ArrayList();
        this.register.entrySet().forEach(entry -> {
            PropertyChangeListener l = (PropertyChangeListener)entry.getKey();
            if (((String)entry.getValue()).equals(name)) {
                list.add(l);
            }
        });
        return list.toArray(new PropertyChangeListener[list.size()]);
    }

    @Override
    public synchronized ArrayList<String> getListenerRefs() {
        return new ArrayList<String>(this.listenerRefs.values());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void updateListenerRef(PropertyChangeListener l, String newName) {
        if (this.listenerRefs.containsKey(l)) {
            this.listenerRefs.put(l, newName);
        }
    }

    @Override
    public synchronized String getListenerRef(PropertyChangeListener l) {
        return this.listenerRefs.get(l);
    }

    @Override
    public synchronized int getNumPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners().length;
    }

    @Override
    @Nonnull
    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    @Override
    @Nonnull
    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    @Override
    @Nonnull
    public final String getSystemName() {
        return this.decorated.getSystemName();
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.decorated.getSystemName();
    }

    @Override
    public final String getUserName() {
        return this.decorated.getUserName();
    }

    @Override
    @Nonnull
    public String getBeanType() {
        return this.decorated.getBeanType();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setUserName(String s) throws NamedBean.BadUserNameException {
        this.decorated.setUserName(s);
    }

    @OverridingMethodsMustInvokeSuper
    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void dispose() {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener l : listeners = this.pcs.getPropertyChangeListeners()) {
            this.pcs.removePropertyChangeListener(l);
            this.register.remove(l);
            this.listenerRefs.remove(l);
        }
    }

    @Override
    @Nonnull
    public String describeState(int state) {
        return this.decorated.describeState(state);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setProperty(@Nonnull String key, Object value) {
        this.decorated.setProperty(key, value);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public Object getProperty(@Nonnull String key) {
        return this.decorated.getProperty(key);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    @Nonnull
    public Set<String> getPropertyKeys() {
        return this.decorated.getPropertyKeys();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void removeProperty(String key) {
        this.decorated.removeProperty(key);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        this.decorated.vetoableChange(evt);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AbstractNamedBeanDecorator) {
            AbstractNamedBeanDecorator b = (AbstractNamedBeanDecorator)obj;
            return this.getSystemName().equals(b.getSystemName());
        }
        return this.decorated.equals(obj);
    }

    public int hashCode() {
        return this.getSystemName().hashCode();
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        return this.decorated.compareSystemNameSuffix(suffix1, suffix2, n);
    }
}

