/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPowerServer
implements PropertyChangeListener {
    protected PowerManager p = null;
    private static final Logger log = LoggerFactory.getLogger(AbstractPowerServer.class);

    protected boolean mgrOK() {
        if (this.p == null) {
            this.p = InstanceManager.getNullableDefault(PowerManager.class);
            if (this.p == null) {
                log.error("No power manager instance found");
                try {
                    this.sendErrorStatus();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
            }
            this.p.addPropertyChangeListener("power", this);
        }
        return true;
    }

    public void setOnStatus() {
        if (this.mgrOK()) {
            try {
                this.p.setPower(2);
            }
            catch (JmriException e) {
                log.error("Exception trying to turn power on", (Throwable)e);
                try {
                    this.sendErrorStatus();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public void setOffStatus() {
        if (this.mgrOK()) {
            try {
                this.p.setPower(4);
            }
            catch (JmriException e) {
                log.error("Exception trying to turn power off", (Throwable)e);
                try {
                    this.sendErrorStatus();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        try {
            this.sendStatus(this.p.getPower());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.p != null) {
            this.p.removePropertyChangeListener(this);
        }
    }

    public abstract void sendStatus(int var1) throws IOException;

    public abstract void sendErrorStatus() throws IOException;

    public abstract void parseStatus(String var1) throws JmriException, IOException;
}

