/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Route;
import jmri.RouteManager;
import jmri.Sensor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRouteServer {
    private final HashMap<String, RouteListener> routes = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(AbstractRouteServer.class);

    public abstract void sendStatus(String var1, int var2) throws IOException;

    public abstract void sendErrorStatus(String var1) throws IOException;

    public abstract void parseStatus(String var1) throws JmriException, IOException;

    protected synchronized void addRouteToList(String routeName) {
        Sensor tas;
        Route r;
        if (!this.routes.containsKey(routeName) && (r = InstanceManager.getDefault(RouteManager.class).getRoute(routeName)) != null && (tas = r.getTurnoutsAlgdSensor()) != null) {
            RouteListener rl = new RouteListener(routeName);
            tas.addPropertyChangeListener(rl);
            this.routes.put(routeName, rl);
        }
    }

    protected synchronized void removeRouteFromList(String routeName) {
        Route r;
        if (this.routes.containsKey(routeName) && (r = InstanceManager.getDefault(RouteManager.class).getRoute(routeName)) != null) {
            Sensor tas = r.getTurnoutsAlgdSensor();
            if (tas != null) {
                tas.removePropertyChangeListener(this.routes.get(routeName));
            }
            this.routes.remove(routeName);
        }
    }

    public void setRoute(String routeName) throws IOException {
        Route route = InstanceManager.getDefault(RouteManager.class).getRoute(routeName);
        if (route != null) {
            route.setRoute();
            this.addRouteToList(routeName);
        } else {
            this.sendErrorStatus(routeName);
        }
    }

    public void dispose() {
        for (Map.Entry<String, RouteListener> route : this.routes.entrySet()) {
            Sensor tas;
            Route r = InstanceManager.getDefault(RouteManager.class).getRoute(route.getKey());
            if (r == null || (tas = r.getTurnoutsAlgdSensor()) == null) continue;
            tas.removePropertyChangeListener(route.getValue());
        }
        this.routes.clear();
    }

    class RouteListener
    implements PropertyChangeListener {
        String name = null;
        Sensor sensor = null;

        RouteListener(String routeName) {
            this.name = routeName;
            Route r = InstanceManager.getDefault(RouteManager.class).getRoute(this.name);
            if (r != null) {
                this.sensor = r.getTurnoutsAlgdSensor();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("KnownState")) {
                try {
                    AbstractRouteServer.this.sendStatus(this.name, (Integer)e.getNewValue());
                }
                catch (IOException ie) {
                    log.debug("Error Sending Status");
                    this.sensor.removePropertyChangeListener(this);
                    AbstractRouteServer.this.removeRouteFromList(this.name);
                }
            }
        }
    }
}

