/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.server.json.JsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignalMastServer {
    private final HashMap<String, SignalMastListener> signalMasts = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(AbstractSignalMastServer.class);

    public abstract void sendStatus(String var1, String var2) throws IOException;

    public abstract void sendErrorStatus(String var1) throws IOException;

    public abstract void parseStatus(String var1) throws JmriException, IOException, JsonException;

    protected synchronized void addSignalMastToList(String signalMastName) {
        SignalMast sm;
        if (!this.signalMasts.containsKey(signalMastName) && (sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMastName)) != null) {
            SignalMastListener sml = new SignalMastListener(signalMastName);
            sm.addPropertyChangeListener(sml);
            this.signalMasts.put(signalMastName, sml);
            log.debug("Added listener to signalMast {}", (Object)signalMastName);
        }
    }

    protected synchronized void removeSignalMastFromList(String signalMastName) {
        SignalMast sm;
        if (this.signalMasts.containsKey(signalMastName) && (sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMastName)) != null) {
            sm.removePropertyChangeListener(this.signalMasts.get(signalMastName));
            this.signalMasts.remove(signalMastName);
        }
    }

    protected void setSignalMastAspect(String signalMastName, String signalMastState) {
        try {
            this.addSignalMastToList(signalMastName);
            SignalMast signalMast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMastName);
            if (signalMast == null) {
                log.error("SignalMast {} is not available.", (Object)signalMastName);
            } else {
                String aspect = signalMast.getAspect();
                if (aspect == null || !aspect.equals(signalMastState) || signalMast.getHeld()) {
                    if (signalMastState.equals("Held")) {
                        signalMast.setHeld(true);
                    } else {
                        if (signalMast.getHeld()) {
                            signalMast.setHeld(false);
                        }
                        signalMast.setAspect(signalMastState);
                    }
                } else {
                    try {
                        this.sendStatus(signalMastName, signalMastState);
                    }
                    catch (IOException ex) {
                        log.error("Error sending aspect ", (Throwable)ex);
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error("Exception setting signalMast {} aspect:", (Object)signalMastName, (Object)ex);
        }
    }

    public void dispose() {
        for (Map.Entry<String, SignalMastListener> signalMast : this.signalMasts.entrySet()) {
            SignalMast sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMast.getKey());
            if (sm == null) continue;
            sm.removePropertyChangeListener(signalMast.getValue());
        }
        this.signalMasts.clear();
    }

    class SignalMastListener
    implements PropertyChangeListener {
        String name = null;
        SignalMast signalMast = null;

        SignalMastListener(String signalMastName) {
            this.name = signalMastName;
            this.signalMast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(signalMastName);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("Aspect") || e.getPropertyName().equals("Held") || e.getPropertyName().equals("Lit")) {
                SignalMast sm = (SignalMast)e.getSource();
                String state = sm.getAspect();
                if (sm.getHeld() && sm.getAppearanceMap().getSpecificAppearance(0) != null) {
                    state = "Held";
                } else if (!sm.getLit() && sm.getAppearanceMap().getSpecificAppearance(3) != null) {
                    state = "Dark";
                }
                try {
                    AbstractSignalMastServer.this.sendStatus(this.name, state);
                }
                catch (IOException ie) {
                    if (log.isDebugEnabled()) {
                        log.debug("Unable to send status, removing listener from signalMast {}", (Object)this.name);
                    }
                    this.signalMast.removePropertyChangeListener(this);
                    AbstractSignalMastServer.this.removeSignalMastFromList(this.name);
                }
            }
        }
    }
}

