/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LocoAddress;
import jmri.Throttle;
import jmri.ThrottleListener;
import jmri.ThrottleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractThrottleServer
implements ThrottleListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractThrottleServer.class);
    protected ArrayList<Throttle> throttleList = new ArrayList();

    public abstract void sendStatus(LocoAddress var1) throws IOException;

    public abstract void sendErrorStatus() throws IOException;

    public abstract void sendThrottleFound(LocoAddress var1) throws IOException;

    public abstract void sendThrottleReleased(LocoAddress var1) throws IOException;

    public abstract void parsecommand(String var1) throws JmriException, IOException;

    public void setThrottleSpeedAndDirection(LocoAddress l, float speed, boolean isForward) {
        this.throttleList.forEach(t -> {
            if (t.getLocoAddress() == l) {
                t.setSpeedSetting(speed);
                t.setIsForward(isForward);
            }
        });
    }

    public void setThrottleFunctions(LocoAddress l, ArrayList<Boolean> fList) {
        this.throttleList.forEach(t -> {
            if (t.getLocoAddress() == l) {
                this.setFunctionsByThrottle((Throttle)t, fList);
            }
        });
    }

    protected void setFunctionsByThrottle(Throttle t, ArrayList<Boolean> fList) {
        for (int i = 0; i < fList.size(); ++i) {
            if (i > t.getFunctions().length - 1) {
                log.error("Unable to set Function {} on Throttle {}", (Object)i, (Object)t.getLocoAddress());
                try {
                    this.sendErrorStatus();
                }
                catch (IOException ioe) {
                    log.error("Error writing to network port");
                }
                continue;
            }
            t.setFunction(i, fList.get(i));
        }
    }

    public void requestThrottle(LocoAddress l) {
        ThrottleManager t = InstanceManager.throttleManagerInstance();
        boolean result = t.requestThrottle(l, (ThrottleListener)this, false);
        if (!result) {
            try {
                this.sendErrorStatus();
            }
            catch (IOException ioe) {
                log.error("Error writing to network port");
            }
        }
    }

    public void releaseThrottle(LocoAddress l) {
        ThrottleManager t = InstanceManager.throttleManagerInstance();
        t.cancelThrottleRequest(l, (ThrottleListener)this);
        if (l instanceof DccLocoAddress) {
            this.throttleList.forEach(throttle -> {
                if (throttle.getLocoAddress() == l) {
                    t.releaseThrottle((DccThrottle)throttle, this);
                    this.throttleList.remove(throttle);
                    try {
                        this.sendThrottleReleased(l);
                    }
                    catch (IOException ioe) {
                        log.error("Error writing to network port");
                    }
                }
            });
        }
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        this.throttleList.add(t);
        t.addPropertyChangeListener(new ThrottlePropertyChangeListener(this, t));
        try {
            this.sendThrottleFound(t.getLocoAddress());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        try {
            this.sendErrorStatus();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
    }

    static class ThrottlePropertyChangeListener
    implements PropertyChangeListener {
        protected AbstractThrottleServer clientserver = null;
        protected Throttle throttle = null;

        ThrottlePropertyChangeListener(AbstractThrottleServer ts, Throttle t) {
            this.clientserver = ts;
            this.throttle = t;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            block8 : switch (e.getPropertyName()) {
                case "SpeedSetting": 
                case "SpeedSteps": 
                case "IsForward": {
                    try {
                        this.clientserver.sendStatus(this.throttle.getLocoAddress());
                    }
                    catch (IOException ioe) {
                        log.error("Error writing to network port");
                    }
                    break;
                }
                default: {
                    for (int i = 0; i <= 28; ++i) {
                        if (e.getPropertyName().equals("F" + i)) {
                            try {
                                this.clientserver.sendStatus(this.throttle.getLocoAddress());
                            }
                            catch (IOException ioe) {
                                log.error("Error writing to network port");
                            }
                            break block8;
                        }
                        if (!e.getPropertyName().equals("F" + i + "Momentary")) continue;
                        try {
                            this.clientserver.sendStatus(this.throttle.getLocoAddress());
                        }
                        catch (IOException ioe) {
                            log.error("Error writing to network port");
                        }
                        break block8;
                    }
                }
            }
            log.debug("Property change event received {} / {}", (Object)e.getPropertyName(), e.getNewValue());
        }
    }
}

