/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Turnout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTurnoutServer {
    protected final HashMap<String, TurnoutListener> turnouts = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(AbstractTurnoutServer.class);

    public abstract void sendStatus(String var1, int var2) throws IOException;

    public abstract void sendErrorStatus(String var1) throws IOException;

    public abstract void parseStatus(String var1) throws JmriException, IOException;

    protected synchronized void addTurnoutToList(String turnoutName) {
        Turnout t;
        if (!this.turnouts.containsKey(turnoutName) && (t = InstanceManager.turnoutManagerInstance().getTurnout(turnoutName)) != null) {
            TurnoutListener tl = new TurnoutListener(turnoutName);
            t.addPropertyChangeListener(tl);
            this.turnouts.put(turnoutName, tl);
        }
    }

    protected synchronized void removeTurnoutFromList(String turnoutName) {
        Turnout t;
        if (this.turnouts.containsKey(turnoutName) && (t = InstanceManager.turnoutManagerInstance().getTurnout(turnoutName)) != null) {
            t.removePropertyChangeListener(this.turnouts.get(turnoutName));
            this.turnouts.remove(turnoutName);
        }
    }

    public Turnout initTurnout(String turnoutName) throws IllegalArgumentException {
        Turnout turnout = InstanceManager.turnoutManagerInstance().provideTurnout(turnoutName);
        this.addTurnoutToList(turnoutName);
        return turnout;
    }

    public void closeTurnout(String turnoutName) {
        try {
            if (!this.turnouts.containsKey(turnoutName)) {
                this.sendErrorStatus(turnoutName);
                return;
            }
            Turnout turnout = InstanceManager.turnoutManagerInstance().getTurnout(turnoutName);
            if (turnout == null) {
                log.error("Turnout {} is not available", (Object)turnoutName);
            } else {
                log.debug("about to command CLOSED");
                turnout.setCommandedState(2);
            }
        }
        catch (IOException ex) {
            log.error("Error closing turnout", (Throwable)ex);
        }
    }

    public void throwTurnout(String turnoutName) {
        try {
            Turnout turnout = InstanceManager.turnoutManagerInstance().getTurnout(turnoutName);
            if (!this.turnouts.containsKey(turnoutName)) {
                this.sendErrorStatus(turnoutName);
                return;
            }
            if (turnout == null) {
                log.error("Turnout {} is not available", (Object)turnoutName);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("about to command THROWN");
                }
                turnout.setCommandedState(4);
            }
        }
        catch (IOException ex) {
            log.error("Error throwing turnout", (Throwable)ex);
        }
    }

    public void dispose() {
        for (Map.Entry<String, TurnoutListener> turnout : this.turnouts.entrySet()) {
            Turnout t = InstanceManager.turnoutManagerInstance().getTurnout(turnout.getKey());
            if (t == null) continue;
            t.removePropertyChangeListener(turnout.getValue());
        }
        this.turnouts.clear();
    }

    protected TurnoutListener getListener(String turnoutName) {
        if (!this.turnouts.containsKey(turnoutName)) {
            return new TurnoutListener(turnoutName);
        }
        return this.turnouts.get(turnoutName);
    }

    protected class TurnoutListener
    implements PropertyChangeListener {
        String name = null;
        Turnout turnout = null;

        protected TurnoutListener(String turnoutName) {
            this.name = turnoutName;
            this.turnout = InstanceManager.turnoutManagerInstance().getTurnout(turnoutName);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("KnownState")) {
                int now = (Integer)e.getNewValue();
                try {
                    AbstractTurnoutServer.this.sendStatus(this.name, now);
                }
                catch (IOException ie) {
                    log.debug("Error Sending Status");
                    this.turnout.removePropertyChangeListener(this);
                    AbstractTurnoutServer.this.removeTurnoutFromList(this.name);
                }
            }
        }
    }
}

