/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Locale;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriConnection {
    private final Session session;
    private final DataOutputStream dataOutputStream;
    private Locale locale = Locale.getDefault();
    private static final Logger log = LoggerFactory.getLogger(JmriConnection.class);
    private static final String EX_SENDING_MSG = "Exception sending message";

    public JmriConnection(Session connection) {
        this.session = connection;
        this.dataOutputStream = null;
    }

    public JmriConnection(DataOutputStream output) {
        this.dataOutputStream = output;
        this.session = null;
    }

    public Session getSession() {
        return this.session;
    }

    public DataOutputStream getDataOutputStream() {
        return this.dataOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String message) throws IOException {
        block11: {
            log.trace("Sending \"{}\"", (Object)message);
            if (this.dataOutputStream != null) {
                this.dataOutputStream.writeBytes(message);
            } else {
                if (this.session.isOpen()) {
                    try {
                        RemoteEndpoint remote;
                        RemoteEndpoint remoteEndpoint = remote = this.session.getRemote();
                        synchronized (remoteEndpoint) {
                            remote.sendString(message);
                            break block11;
                        }
                    }
                    catch (WebSocketException ex) {
                        if (ex.getMessage() == null) {
                            throw new IOException(EX_SENDING_MSG, ex);
                        }
                        throw new IOException(ex);
                    }
                    catch (IOException ex) {
                        if (ex.getMessage() == null) {
                            throw new IOException(EX_SENDING_MSG, ex);
                        }
                        throw ex;
                    }
                }
                throw new IOException("Will not send message on non-open session");
            }
        }
    }

    public void close() throws IOException {
        if (this.dataOutputStream != null) {
            this.dataOutputStream.close();
        } else if (this.session != null) {
            this.session.close();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

