/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.util.ThreadingUtil;
import jmri.util.zeroconf.ZeroConfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriServer {
    protected int portNo = 3000;
    protected int timeout = 0;
    protected ServerSocket connectSocket;
    protected ZeroConfService service = null;
    protected ShutDownTask shutDownTask = null;
    private Thread listenThread = null;
    protected ArrayList<ClientListener> connectedClientThreads = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(JmriServer.class);

    public JmriServer() {
        this(3000);
    }

    public JmriServer(int port) {
        this(port, 0);
    }

    public JmriServer(int port, int timeout) {
        try {
            this.connectSocket = new ServerSocket(port);
        }
        catch (IOException e) {
            log.error("Failed to connect to port {}", (Object)port);
        }
        this.portNo = port;
        this.timeout = timeout;
    }

    private synchronized void addClient(ClientListener client) {
        if (!this.connectedClientThreads.contains(client)) {
            this.connectedClientThreads.add(client);
            client.start();
        }
    }

    private synchronized void removeClient(ClientListener client) {
        if (this.connectedClientThreads.contains(client)) {
            client.stop(this);
            this.connectedClientThreads.remove(client);
        }
    }

    public void start() {
        if (this.listenThread == null) {
            this.listenThread = ThreadingUtil.newThread(new NewClientListener(this.connectSocket));
            this.listenThread.start();
            this.advertise();
        }
        if (this.shutDownTask != null) {
            InstanceManager.getDefault(ShutDownManager.class).register(this.shutDownTask);
        }
    }

    protected void advertise() {
        this.advertise("_jmri._tcp.local.");
    }

    protected void advertise(String type) {
        this.advertise(type, new HashMap<String, String>());
    }

    protected void advertise(String type, HashMap<String, String> properties) {
        if (this.service == null) {
            this.service = ZeroConfService.create(type, this.portNo, properties);
        }
        this.service.publish();
    }

    public void stop() {
        this.connectedClientThreads.forEach(client -> client.stop(this));
        this.listenThread = null;
        this.service.stop();
        if (this.shutDownTask != null) {
            InstanceManager.getDefault(ShutDownManager.class).deregister(this.shutDownTask);
        }
    }

    public void handleClient(DataInputStream inStream, DataOutputStream outStream) throws IOException {
        byte[] cmd = new byte[100];
        while (true) {
            int count;
            if ((count = inStream.read(cmd)) == 0) {
                continue;
            }
            outStream.write(cmd);
        }
    }

    public void stopClient(DataInputStream inStream, DataOutputStream outStream) throws IOException {
        outStream.writeBytes("");
    }

    protected class ClientListener
    implements Runnable {
        Socket clientSocket = null;
        DataInputStream inStream = null;
        DataOutputStream outStream = null;
        Thread clientThread = null;

        public ClientListener(Socket socket) {
            log.debug("Starting new Client");
            this.clientSocket = socket;
            try {
                this.inStream = new DataInputStream(this.clientSocket.getInputStream());
                this.outStream = new DataOutputStream(this.clientSocket.getOutputStream());
            }
            catch (IOException e) {
                log.error("Error obtaining I/O Stream from socket.");
            }
        }

        public void start() {
            this.clientThread = ThreadingUtil.newThread(this);
            this.clientThread.start();
        }

        public void stop(JmriServer server) {
            try {
                server.stopClient(this.inStream, this.outStream);
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.clientThread = null;
        }

        @Override
        public void run() {
            try {
                JmriServer.this.handleClient(this.inStream, this.outStream);
            }
            catch (IOException ex) {
                log.debug("Server Exiting");
                JmriServer.this.removeClient(this);
            }
            catch (NullPointerException ex) {
                log.debug("Client Disconnect", (Throwable)ex);
                JmriServer.this.removeClient(this);
            }
        }
    }

    class NewClientListener
    implements Runnable {
        ServerSocket listenSocket = null;
        boolean running = true;

        public NewClientListener(ServerSocket socket) {
            this.listenSocket = socket;
        }

        @Override
        public void run() {
            try {
                while (this.running) {
                    Socket clientSocket = this.listenSocket.accept();
                    clientSocket.setSoTimeout(JmriServer.this.timeout);
                    log.debug(" Client Connected from IP {} port {}", (Object)clientSocket.getInetAddress(), (Object)clientSocket.getPort());
                    JmriServer.this.addClient(new ClientListener(clientSocket));
                }
            }
            catch (IOException e) {
                log.error("IOException while Listening for clients");
            }
        }

        public void stop() {
            this.running = false;
            try {
                this.listenSocket.close();
                log.debug("Listen Socket closed");
            }
            catch (IOException e) {
                log.error("socket in ThreadedServer won't close");
            }
        }
    }
}

