/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.simpleserver;

import java.beans.PropertyChangeEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.management.Attribute;
import jmri.JmriException;
import jmri.jmris.AbstractOperationsServer;
import jmri.jmris.JmriConnection;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.trains.Train;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleOperationsServer
extends AbstractOperationsServer {
    public static final String OPERATIONS = "OPERATIONS";
    public static final String TRAIN = "TRAIN";
    public static final String TRAINS = "TRAINS";
    public static final String LOCATIONS = "LOCATIONS";
    public static final String TRAINLENGTH = "TRAINLENGTH";
    public static final String TRAINWEIGHT = "TRAINWEIGHT";
    public static final String TRAINCARS = "TRAINCARS";
    public static final String TRAINLEADLOCO = "TRAINLEADLOCO";
    public static final String TRAINCABOOSE = "TRAINCABOOSE";
    public static final String TRAINSTATUS = "TRAINSTATUS";
    public static final String TERMINATE = "TERMINATE";
    public static final String TRAINLOCATION = "TRAINLOCATION";
    private static final String REQUEST_DELIMITER = " , ";
    public static final String FIELDSEPARATOR = "=";
    private DataOutputStream output;
    private JmriConnection connection;
    private static final Logger log = LoggerFactory.getLogger(SimpleOperationsServer.class);

    public SimpleOperationsServer(JmriConnection connection) {
        this.connection = connection;
    }

    public SimpleOperationsServer(DataInputStream inStream, DataOutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendMessage(ArrayList<Attribute> contents) throws IOException {
        this.sendMessage(SimpleOperationsServer.constructOperationsMessage(contents) + "\n");
    }

    @Override
    public void sendErrorStatus(String errorStatus) throws IOException {
        this.sendMessage("OPERATIONS: " + errorStatus + "\n");
    }

    public static String constructOperationsMessage(List<Attribute> contents) {
        StringBuilder result = new StringBuilder(OPERATIONS);
        for (Attribute content : contents) {
            result.append(REQUEST_DELIMITER).append(content.getName());
            if (content.getValue() == null) continue;
            result.append(FIELDSEPARATOR).append(content.getValue());
        }
        return new String(result);
    }

    public static ArrayList<Attribute> parseOperationsMessage(String message) {
        ArrayList<Attribute> contents = new ArrayList<Attribute>();
        if (message != null && message.startsWith(OPERATIONS)) {
            int start = message.indexOf(REQUEST_DELIMITER);
            while (start > 0) {
                String request;
                int equals;
                int end = message.indexOf(REQUEST_DELIMITER, start += REQUEST_DELIMITER.length());
                if ((equals = (request = end > 0 ? message.substring(start, end) : message.substring(start, message.length())).indexOf(FIELDSEPARATOR)) > 0 && equals < request.length() - 1) {
                    contents.add(new Attribute(request.substring(0, equals), request.substring(equals + 1, request.length())));
                } else {
                    contents.add(new Attribute(request, null));
                }
                start = end;
            }
        }
        return contents;
    }

    @Override
    public void parseStatus(String statusString) throws JmriException, IOException {
        ArrayList<Attribute> contents = SimpleOperationsServer.parseOperationsMessage(statusString);
        ArrayList<Attribute> response = new ArrayList<Attribute>();
        String trainName = null;
        block20: for (Attribute field : contents) {
            String tag = field.getName();
            if (TRAIN.equals(tag)) {
                trainName = (String)field.getValue();
                response.add(field);
                continue;
            }
            if (LOCATIONS.equals(tag)) {
                this.sendLocationList();
                continue;
            }
            if (TRAINS.equals(tag)) {
                this.sendTrainList();
                continue;
            }
            if (trainName != null) {
                if (null == tag) {
                    throw new JmriException();
                }
                switch (tag) {
                    case "TRAINLENGTH": {
                        String value = this.constructTrainLength(trainName);
                        if (value == null) continue block20;
                        response.add(new Attribute(TRAINLENGTH, value));
                        break;
                    }
                    case "TRAINWEIGHT": {
                        String value = this.constructTrainWeight(trainName);
                        if (value == null) continue block20;
                        response.add(new Attribute(TRAINWEIGHT, value));
                        break;
                    }
                    case "TRAINCARS": {
                        String value = this.constructTrainNumberOfCars(trainName);
                        if (value == null) continue block20;
                        response.add(new Attribute(TRAINCARS, value));
                        break;
                    }
                    case "TRAINLEADLOCO": {
                        String value = this.constructTrainLeadLoco(trainName);
                        if (value == null) continue block20;
                        response.add(new Attribute(TRAINLEADLOCO, value));
                        break;
                    }
                    case "TRAINCABOOSE": {
                        String value = this.constructTrainCaboose(trainName);
                        if (value == null) continue block20;
                        response.add(new Attribute(TRAINCABOOSE, value));
                        break;
                    }
                    case "TRAINSTATUS": {
                        String value = this.constructTrainStatus(trainName);
                        if (value == null) continue block20;
                        response.add(new Attribute(TRAINSTATUS, value));
                        break;
                    }
                    case "TERMINATE": {
                        String value = this.terminateTrain(trainName);
                        if (value == null) continue block20;
                        response.add(new Attribute(TERMINATE, value));
                        break;
                    }
                    case "TRAINLOCATION": {
                        String value = field.getValue() == null ? this.constructTrainLocation(trainName) : this.setTrainLocation(trainName, (String)field.getValue());
                        if (value == null) continue block20;
                        response.add(new Attribute(TRAINLOCATION, value));
                        break;
                    }
                    default: {
                        throw new JmriException();
                    }
                }
                continue;
            }
            throw new JmriException();
        }
        if (response.size() > 1) {
            this.sendMessage(response);
        }
    }

    private void sendMessage(String message) throws IOException {
        if (this.output != null) {
            this.output.writeBytes(message);
        } else {
            this.connection.sendMessage(message);
        }
    }

    @Override
    public void sendTrainList() {
        List<Train> trainList = this.tm.getTrainsByNameList();
        for (Train train : trainList) {
            ArrayList<Attribute> aTrain = new ArrayList<Attribute>(1);
            aTrain.add(new Attribute(TRAINS, train.getName()));
            try {
                this.sendMessage(aTrain);
            }
            catch (IOException ioe) {
                log.debug("could not send train {}", (Object)train.getName());
            }
        }
    }

    @Override
    public void sendLocationList() {
        List<Location> locationList = this.lm.getLocationsByNameList();
        for (Location loc : locationList) {
            ArrayList<Attribute> location = new ArrayList<Attribute>(1);
            location.add(new Attribute(LOCATIONS, loc));
            try {
                this.sendMessage(location);
            }
            catch (IOException ioe) {
                log.debug("could not send train {}", (Object)loc.getName());
            }
        }
    }

    @Override
    public void sendFullStatus(Train train) throws IOException {
        ArrayList<Attribute> status = new ArrayList<Attribute>();
        if (train != null) {
            status.add(new Attribute(TRAIN, train.getName()));
            status.add(new Attribute(TRAINLOCATION, train.getCurrentLocationName()));
            status.add(new Attribute(TRAINLENGTH, String.valueOf(train.getTrainLength())));
            status.add(new Attribute(TRAINWEIGHT, String.valueOf(train.getTrainWeight())));
            status.add(new Attribute(TRAINCARS, String.valueOf(train.getNumberCarsInTrain())));
            status.add(new Attribute(TRAINLEADLOCO, this.constructTrainLeadLoco(train.getName())));
            status.add(new Attribute(TRAINCABOOSE, this.constructTrainCaboose(train.getName())));
            this.sendMessage(status);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("property change: {} old: {} new: {}", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        if (e.getPropertyName().equals("TrainBuilt")) {
            try {
                this.sendFullStatus((Train)e.getSource());
            }
            catch (IOException e1) {
                log.error("Exception: ", (Throwable)e1);
            }
        }
    }
}

