/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.simpleserver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringReader;
import jmri.JmriException;
import jmri.jmris.AbstractPowerServer;
import jmri.jmris.JmriConnection;
import jmri.jmris.simpleserver.parser.JmriServerParser;
import jmri.jmris.simpleserver.parser.ParseException;
import jmri.jmris.simpleserver.parser.SimpleNode;
import jmri.jmris.simpleserver.parser.SimpleVisitor;
import jmri.jmris.simpleserver.parser.TokenMgrError;

public class SimplePowerServer
extends AbstractPowerServer {
    private DataOutputStream output;
    private JmriConnection connection;

    public SimplePowerServer(DataInputStream inStream, DataOutputStream outStream) {
        this.output = outStream;
        this.mgrOK();
    }

    public SimplePowerServer(JmriConnection cnctn) {
        this.connection = cnctn;
        this.mgrOK();
    }

    @Override
    public void sendStatus(int Status2) throws IOException {
        switch (Status2) {
            case 2: {
                this.sendStatus("POWER ON\n");
                break;
            }
            case 4: {
                this.sendStatus("POWER OFF\n");
                break;
            }
            default: {
                this.sendStatus("POWER UNKNOWN\n");
            }
        }
    }

    @Override
    public void sendErrorStatus() throws IOException {
        this.sendStatus("POWER ERROR\n");
    }

    @Override
    public void parseStatus(String statusString) throws JmriException {
        JmriServerParser p = new JmriServerParser(new StringReader(statusString));
        try {
            try {
                SimpleNode e = p.powercmd();
                SimpleVisitor v = new SimpleVisitor();
                e.jjtAccept(v, this);
                if (v.getOutputString() != null) {
                    this.sendStatus(v.getOutputString());
                }
            }
            catch (ParseException | TokenMgrError pe) {
                this.sendErrorStatus();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void sendStatus(String status) throws IOException {
        if (this.output != null) {
            this.output.writeBytes(status);
        } else {
            this.connection.sendMessage(status);
        }
    }
}

