/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.simpleserver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Reportable;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.jmris.AbstractReporterServer;
import jmri.jmris.JmriConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleReporterServer
extends AbstractReporterServer {
    private static final String REPORTER = "REPORTER ";
    private DataOutputStream output;
    private JmriConnection connection;
    private static final Logger log = LoggerFactory.getLogger(SimpleReporterServer.class);

    public SimpleReporterServer(JmriConnection connection) {
        this.connection = connection;
    }

    public SimpleReporterServer(DataInputStream inStream, DataOutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendReport(String reporterName, Object r) throws IOException {
        this.addReporterToList(reporterName);
        if (r != null) {
            if (r instanceof Reportable) {
                this.sendMessage(REPORTER + reporterName + " " + ((Reportable)r).toReportString() + "\n");
            } else {
                this.sendMessage(REPORTER + reporterName + " " + r.toString() + "\n");
            }
        } else {
            this.sendMessage(REPORTER + reporterName + "\n");
        }
    }

    @Override
    public void sendErrorStatus(String reporterName) throws IOException {
        this.sendMessage("REPORTER ERROR\n");
    }

    @Override
    public void parseStatus(String statusString) throws JmriException, IOException {
        int index = statusString.indexOf(32) + 1;
        int index2 = statusString.indexOf(32, index + 1);
        int newlinepos = statusString.indexOf(10);
        String reporterName = statusString.substring(index, index2 > 0 ? index2 : newlinepos);
        this.initReporter(reporterName);
        if (index2 > 0 && newlinepos - (index2 + 1) > 0) {
            this.setReporterReport(reporterName, statusString.substring(index2 + 1, newlinepos));
        } else {
            try {
                Reporter reporter = InstanceManager.getDefault(ReporterManager.class).provideReporter(reporterName);
                this.sendReport(reporterName, reporter.getCurrentReport());
            }
            catch (IllegalArgumentException ex) {
                log.warn("Failed to provide Reporter \"{}\" in parseStatus", (Object)reporterName);
            }
        }
    }

    private void sendMessage(String message) throws IOException {
        if (this.output != null) {
            this.output.writeBytes(message);
        } else {
            this.connection.sendMessage(message);
        }
    }
}

