/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.simpleserver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.jmris.AbstractSensorServer;
import jmri.jmris.JmriConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSensorServer
extends AbstractSensorServer {
    private static final String SENSOR = "SENSOR ";
    private DataOutputStream output;
    private JmriConnection connection;
    private static final Logger log = LoggerFactory.getLogger(SimpleSensorServer.class);

    public SimpleSensorServer(JmriConnection connection) {
        this.connection = connection;
    }

    public SimpleSensorServer(DataInputStream inStream, DataOutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendStatus(String sensorName, int Status2) throws IOException {
        this.addSensorToList(sensorName);
        switch (Status2) {
            case 4: {
                this.sendMessage(SENSOR + sensorName + " INACTIVE\n");
                break;
            }
            case 2: {
                this.sendMessage(SENSOR + sensorName + " ACTIVE\n");
                break;
            }
            default: {
                this.sendMessage(SENSOR + sensorName + " UNKNOWN\n");
            }
        }
    }

    @Override
    public void sendErrorStatus(String sensorName) throws IOException {
        this.sendMessage("SENSOR ERROR\n");
    }

    @Override
    public void parseStatus(String statusString) throws JmriException, IOException {
        int index = statusString.indexOf(32) + 1;
        if (statusString.contains("INACTIVE")) {
            log.debug("Setting Sensor INACTIVE");
            this.initSensor(statusString.substring(index, statusString.indexOf(32, index + 1)));
            this.setSensorInactive(statusString.substring(index, statusString.indexOf(32, index + 1)));
        } else if (statusString.contains("ACTIVE")) {
            log.debug("Setting Sensor ACTIVE");
            this.initSensor(statusString.substring(index, statusString.indexOf(32, index + 1)));
            this.setSensorActive(statusString.substring(index, statusString.indexOf(32, index + 1)));
        } else {
            String sensorName = statusString.substring(index);
            if (sensorName.contains("\n")) {
                sensorName = sensorName.substring(0, sensorName.indexOf(10));
            }
            if (sensorName.contains(" ")) {
                sensorName = sensorName.substring(0, sensorName.indexOf(32));
            }
            try {
                Sensor sensor = InstanceManager.getDefault(SensorManager.class).provideSensor(sensorName);
                this.sendStatus(sensorName, sensor.getKnownState());
            }
            catch (IllegalArgumentException ex) {
                log.warn("Failed to provide Sensor \"{}\" in sendStatus {}", (Object)sensorName, (Object)ex.getMessage());
            }
        }
    }

    private void sendMessage(String message) throws IOException {
        if (this.output != null) {
            this.output.writeBytes(message);
        } else {
            this.connection.sendMessage(message);
        }
    }
}

