/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.simpleserver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Scanner;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.Version;
import jmri.jmris.JmriServer;
import jmri.jmris.simpleserver.SimpleLightServer;
import jmri.jmris.simpleserver.SimpleOperationsServer;
import jmri.jmris.simpleserver.SimplePowerServer;
import jmri.jmris.simpleserver.SimpleReporterServer;
import jmri.jmris.simpleserver.SimpleSensorServer;
import jmri.jmris.simpleserver.SimpleSignalHeadServer;
import jmri.jmris.simpleserver.SimpleTurnoutServer;
import jmri.util.node.NodeIdentity;
import jmri.web.server.WebServerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleServer
extends JmriServer {
    private static final String NOT_SUPPORTED = "not supported\n";
    static ResourceBundle rb = ResourceBundle.getBundle("jmri.jmris.simpleserver.SimpleServerBundle");
    private static final Logger log = LoggerFactory.getLogger(SimpleServer.class);

    public SimpleServer() {
        this(Integer.parseInt(rb.getString("SimpleServerPort")));
    }

    public SimpleServer(int port) {
        super(port);
        InstanceManager.setDefault(SimpleServer.class, this);
        log.info("JMRI SimpleServer started on port {}", (Object)port);
    }

    @Override
    protected void advertise() {
        this.advertise("_jmri-simple._tcp.local.");
    }

    @Override
    public void handleClient(DataInputStream inStream, DataOutputStream outStream) throws IOException {
        try (Scanner inputScanner = new Scanner(new InputStreamReader((InputStream)inStream, StandardCharsets.UTF_8));){
            SimplePowerServer powerServer = new SimplePowerServer(inStream, outStream);
            SimpleTurnoutServer turnoutServer = new SimpleTurnoutServer(inStream, outStream);
            SimpleLightServer lightServer = new SimpleLightServer(inStream, outStream);
            SimpleSensorServer sensorServer = new SimpleSensorServer(inStream, outStream);
            SimpleSignalHeadServer signalHeadServer = new SimpleSignalHeadServer(inStream, outStream);
            SimpleReporterServer reporterServer = new SimpleReporterServer(inStream, outStream);
            SimpleOperationsServer operationsServer = new SimpleOperationsServer(inStream, outStream);
            outStream.writeBytes("JMRI " + Version.name() + " \n");
            outStream.writeBytes("RAILROAD " + InstanceManager.getDefault(WebServerPreferences.class).getRailroadName() + " \n");
            outStream.writeBytes("NODE " + NodeIdentity.networkIdentity() + " \n");
            while (true) {
                String cmd;
                inputScanner.skip("[\r\n]*");
                try {
                    cmd = inputScanner.nextLine();
                }
                catch (NoSuchElementException nse) {
                    break;
                }
                log.debug("Received from client: {}", (Object)cmd);
                if (cmd.startsWith("POWER")) {
                    try {
                        powerServer.parseStatus(cmd);
                        powerServer.sendStatus(InstanceManager.getDefault(PowerManager.class).getPower());
                    }
                    catch (JmriException je) {
                        outStream.writeBytes(NOT_SUPPORTED);
                    }
                    continue;
                }
                if (cmd.startsWith("TURNOUT")) {
                    try {
                        turnoutServer.parseStatus(cmd);
                    }
                    catch (JmriException je) {
                        outStream.writeBytes(NOT_SUPPORTED);
                    }
                    continue;
                }
                if (cmd.startsWith("LIGHT")) {
                    try {
                        lightServer.parseStatus(cmd);
                    }
                    catch (JmriException je) {
                        outStream.writeBytes(NOT_SUPPORTED);
                    }
                    continue;
                }
                if (cmd.startsWith("SENSOR")) {
                    try {
                        sensorServer.parseStatus(cmd);
                    }
                    catch (JmriException je) {
                        outStream.writeBytes(NOT_SUPPORTED);
                    }
                    continue;
                }
                if (cmd.startsWith("SIGNALHEAD")) {
                    try {
                        signalHeadServer.parseStatus(cmd);
                    }
                    catch (JmriException je) {
                        outStream.writeBytes(NOT_SUPPORTED);
                    }
                    continue;
                }
                if (cmd.startsWith("REPORTER")) {
                    try {
                        reporterServer.parseStatus(cmd);
                    }
                    catch (JmriException je) {
                        outStream.writeBytes(NOT_SUPPORTED);
                    }
                    continue;
                }
                if (cmd.startsWith("OPERATIONS")) {
                    try {
                        operationsServer.parseStatus(cmd);
                    }
                    catch (JmriException je) {
                        outStream.writeBytes(NOT_SUPPORTED);
                    }
                    continue;
                }
                outStream.writeBytes("Unknown Command " + cmd + "\n");
            }
        }
    }
}

