/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.simpleserver;

import java.awt.Container;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jmri.jmris.simpleserver.Bundle;
import jmri.jmris.simpleserver.SimpleServerManager;
import jmri.jmris.simpleserver.SimpleServerPreferences;
import jmri.swing.JTitledSeparator;
import jmri.swing.PreferencesPanel;
import jmri.util.swing.JmriJOptionPane;

public class SimpleServerPreferencesPanel
extends JPanel
implements PreferencesPanel {
    private JSpinner port;
    private SimpleServerPreferences preferences = new SimpleServerPreferences();
    private JFrame parentFrame = null;

    public SimpleServerPreferencesPanel() {
        this.preferences.apply(SimpleServerManager.getSimpleServerPreferences());
        this.initGUI();
        this.setGUI();
    }

    public SimpleServerPreferencesPanel(JFrame f) {
        this();
        this.parentFrame = f;
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(new JTitledSeparator(Bundle.getMessage("ServerSectionTitle")));
        this.add(this.portPanel());
        this.add(new JTitledSeparator(Bundle.getMessage("SimpleServerSectionTitle")));
        this.add(Box.createVerticalGlue());
    }

    private void setGUI() {
        this.port.setValue(this.preferences.getPort());
    }

    private boolean setValues() {
        int portNum;
        boolean didSet = true;
        try {
            portNum = (Integer)this.port.getValue();
        }
        catch (NumberFormatException NFE) {
            portNum = 0;
        }
        if (portNum < 1 || portNum > 65535) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("InvalidPortWarningMessage"), Bundle.getMessage("InvalidPortWarningTitle"), 2);
            didSet = false;
        } else {
            this.preferences.setPort(portNum);
        }
        return didSet;
    }

    protected void applyValues() {
        this.setValues();
    }

    protected void cancelValues() {
        Container ancestor = this.getTopLevelAncestor();
        if (ancestor instanceof JFrame) {
            ((JFrame)ancestor).setVisible(false);
        }
    }

    private JPanel portPanel() {
        JPanel panel = new JPanel();
        this.port = new JSpinner(new SpinnerNumberModel(this.preferences.getPort(), 1, 65535, 1));
        ((JSpinner.DefaultEditor)this.port.getEditor()).getTextField().setEditable(true);
        this.port.setEditor(new JSpinner.NumberEditor(this.port, "#"));
        this.port.addChangeListener(e -> this.setValues());
        this.port.setToolTipText(Bundle.getMessage("PortToolTip"));
        panel.add(this.port);
        panel.add(new JLabel(Bundle.getMessage("LabelPort")));
        return panel;
    }

    @Override
    public String getPreferencesItem() {
        return Bundle.getMessage("PreferencesItem");
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("PreferencesItemTitle");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return Bundle.getMessage("PreferencesTabTitle");
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return Bundle.getMessage("PreferencesTooltip");
    }

    @Override
    public void savePreferences() {
        if (this.setValues()) {
            SimpleServerManager.getSimpleServerPreferences().apply(this.preferences);
            SimpleServerManager.getSimpleServerPreferences().save();
            if (this.parentFrame != null) {
                this.parentFrame.dispose();
            }
        }
    }

    @Override
    public boolean isDirty() {
        return this.preferences.compareValuesDifferent(SimpleServerManager.getSimpleServerPreferences()) || SimpleServerManager.getSimpleServerPreferences().isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return SimpleServerManager.getSimpleServerPreferences().isRestartRequired();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }
}

