/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.simpleserver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.jmris.AbstractTurnoutServer;
import jmri.jmris.JmriConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTurnoutServer
extends AbstractTurnoutServer {
    private static final String TURNOUT = "TURNOUT ";
    private DataOutputStream output;
    private JmriConnection connection;
    private static final Logger log = LoggerFactory.getLogger(SimpleTurnoutServer.class);

    public SimpleTurnoutServer(JmriConnection connection) {
        this.connection = connection;
    }

    public SimpleTurnoutServer(DataInputStream inStream, DataOutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendStatus(String turnoutName, int Status2) throws IOException {
        this.addTurnoutToList(turnoutName);
        switch (Status2) {
            case 4: {
                this.sendMessage(TURNOUT + turnoutName + " THROWN\n");
                break;
            }
            case 2: {
                this.sendMessage(TURNOUT + turnoutName + " CLOSED\n");
                break;
            }
            default: {
                this.sendMessage(TURNOUT + turnoutName + " UNKNOWN\n");
            }
        }
    }

    @Override
    public void sendErrorStatus(String turnoutName) throws IOException {
        this.sendMessage("TURNOUT ERROR\n");
    }

    @Override
    public void parseStatus(String statusString) throws JmriException, IOException {
        String turnoutName = statusString.split(" ")[1];
        log.debug("status: {}", (Object)statusString);
        if (statusString.contains("THROWN")) {
            log.debug("Setting Turnout THROWN");
            this.initTurnout(turnoutName);
            this.throwTurnout(turnoutName);
        } else if (statusString.contains("CLOSED")) {
            log.debug("Setting Turnout CLOSED");
            this.initTurnout(turnoutName);
            this.closeTurnout(turnoutName);
        } else {
            try {
                this.sendStatus(turnoutName, InstanceManager.turnoutManagerInstance().provideTurnout(turnoutName).getKnownState());
            }
            catch (IllegalArgumentException ex) {
                log.warn("Failed to provide Turnout \"{}\" in parseStatus", (Object)turnoutName);
            }
        }
    }

    private void sendMessage(String message) throws IOException {
        if (this.output != null) {
            this.output.writeBytes(message);
        } else {
            this.connection.sendMessage(message);
        }
    }
}

