/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.srcp;

import java.beans.PropertyChangeEvent;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.SystemConnectionMemo;
import jmri.Turnout;
import jmri.jmris.AbstractTurnoutServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriSRCPTurnoutServer
extends AbstractTurnoutServer {
    private OutputStream output;
    private static final Logger log = LoggerFactory.getLogger(JmriSRCPTurnoutServer.class);

    public JmriSRCPTurnoutServer(DataInputStream inStream, OutputStream outStream) {
        this.output = outStream;
    }

    @Override
    public void sendStatus(String turnoutName, int Status2) throws IOException {
        this.output.write("499 ERROR unspecified error\n\r".getBytes());
    }

    public void sendStatus(int bus, int address) throws IOException {
        log.debug("send Status called with bus {} and address {}", (Object)bus, (Object)address);
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        SystemConnectionMemo memo = null;
        try {
            memo = list.get(bus - 1);
        }
        catch (IndexOutOfBoundsException obe) {
            this.output.write("412 ERROR wrong value\n\r".getBytes());
            return;
        }
        String turnoutName = memo.getSystemPrefix() + "T" + address;
        try {
            while (InstanceManager.turnoutManagerInstance().provideTurnout(turnoutName).getKnownState() != InstanceManager.turnoutManagerInstance().provideTurnout(turnoutName).getCommandedState()) {
            }
            int Status2 = InstanceManager.turnoutManagerInstance().provideTurnout(turnoutName).getKnownState();
            if (Status2 == 4) {
                this.output.write(("100 INFO " + bus + " GA " + address + " 1 0\n\r").getBytes());
            } else if (Status2 == 2) {
                this.output.write(("100 INFO " + bus + " GA " + address + " 0 0\n\r").getBytes());
            } else {
                this.output.write("411 ERROR unknown value\n\r".getBytes());
            }
        }
        catch (IllegalArgumentException ex) {
            log.warn("Failed to provide Turnout \"{}\" in sendStatus", (Object)turnoutName);
        }
    }

    @Override
    public void sendErrorStatus(String turnoutName) throws IOException {
        this.output.write("499 ERROR unspecified error\n\r".getBytes());
    }

    @Override
    public void parseStatus(String statusString) throws JmriException, IOException {
        this.output.write("499 ERROR unspecified error\n\r".getBytes());
    }

    public void initTurnout(int bus, int address, String protocol) throws JmriException, IOException {
        SystemConnectionMemo memo;
        log.debug("init Turnout called with bus {} address {} and protocol {}", new Object[]{bus, address, protocol});
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        try {
            memo = list.get(bus - 1);
        }
        catch (IndexOutOfBoundsException obe) {
            this.output.write("412 ERROR wrong value\n\r".getBytes());
            return;
        }
        String turnoutName = memo.getSystemPrefix() + "T" + address;
        this.initTurnout(turnoutName);
        this.output.write(("101 INFO " + bus + " GA " + address + " " + protocol + "\n\r").getBytes());
    }

    public void parseStatus(int bus, int address, int value) throws JmriException, IOException {
        SystemConnectionMemo memo;
        log.debug("parse Status called with bus {} address {} and value {}", new Object[]{bus, address, value});
        List<SystemConnectionMemo> list = InstanceManager.getList(SystemConnectionMemo.class);
        try {
            memo = list.get(bus - 1);
        }
        catch (IndexOutOfBoundsException obe) {
            this.output.write("412 ERROR wrong value\n\r".getBytes());
            return;
        }
        String turnoutName = memo.getSystemPrefix() + "T" + address;
        if (value == 1) {
            log.debug("Setting Turnout THROWN");
            this.throwTurnout(turnoutName);
        } else if (value == 0) {
            log.debug("Setting Turnout CLOSED");
            this.closeTurnout(turnoutName);
        }
        this.sendStatus(bus, address);
    }

    @Override
    protected TurnoutListener getListener(String turnoutName) {
        return new TurnoutListener(turnoutName);
    }

    class TurnoutListener
    extends AbstractTurnoutServer.TurnoutListener {
        TurnoutListener(String turnoutName) {
            super(turnoutName);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("KnownState")) {
                try {
                    String Name2 = ((Turnout)e.getSource()).getSystemName();
                    List<SystemConnectionMemo> List2 = InstanceManager.getList(SystemConnectionMemo.class);
                    int i = 0;
                    for (SystemConnectionMemo memo : List2) {
                        String prefix = memo.getClass().getName();
                        if (Name2.startsWith(prefix)) {
                            int address = Integer.parseInt(Name2.substring(prefix.length()));
                            JmriSRCPTurnoutServer.this.sendStatus(i, address);
                            break;
                        }
                        ++i;
                    }
                }
                catch (IOException ie) {
                    log.error("Error Sending Status");
                }
            }
        }
    }
}

