/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.srcp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import jmri.InstanceManager;
import jmri.Timebase;

public class TimeStampedOutput
extends OutputStream {
    private final OutputStream outputStream;

    public TimeStampedOutput(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(byte[] bytes, int i, int i1) throws IOException {
        this.outputStream.write(bytes, i, i1);
    }

    @Override
    public synchronized void write(byte[] bytes) throws IOException {
        Date currentTime = InstanceManager.getDefault(Timebase.class).getTime();
        long time = currentTime.getTime();
        String timeString = String.format("%s.%s ", time / 1000L, time % 1000L);
        byte[] outputBytes = new byte[timeString.length() + bytes.length];
        System.arraycopy(timeString.getBytes(), 0, outputBytes, 0, timeString.length());
        System.arraycopy(bytes, 0, outputBytes, timeString.length(), bytes.length);
        this.outputStream.write(outputBytes);
    }

    @Override
    public void write(int i) throws IOException {
        this.outputStream.write(i);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

