/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmris.srcp.parser;

import java.io.IOException;
import java.util.ArrayList;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.ProgrammingMode;
import jmri.SensorManager;
import jmri.SystemConnectionMemo;
import jmri.ThrottleManager;
import jmri.TurnoutManager;
import jmri.jmris.ServiceHandler;
import jmri.jmris.srcp.JmriSRCPProgrammerServer;
import jmri.jmris.srcp.JmriSRCPSensorServer;
import jmri.jmris.srcp.JmriSRCPServiceHandler;
import jmri.jmris.srcp.JmriSRCPThrottleServer;
import jmri.jmris.srcp.JmriSRCPTimeServer;
import jmri.jmris.srcp.JmriSRCPTurnoutServer;
import jmri.jmris.srcp.parser.ASTconnectionlitteral;
import jmri.jmris.srcp.parser.ASTcv;
import jmri.jmris.srcp.parser.ASTcvbit;
import jmri.jmris.srcp.parser.ASTget;
import jmri.jmris.srcp.parser.ASTgo;
import jmri.jmris.srcp.parser.ASThandshake_set;
import jmri.jmris.srcp.parser.ASTinit;
import jmri.jmris.srcp.parser.ASTprotocollitteral;
import jmri.jmris.srcp.parser.ASTreset;
import jmri.jmris.srcp.parser.ASTset;
import jmri.jmris.srcp.parser.ASTterm;
import jmri.jmris.srcp.parser.ASTwait_cmd;
import jmri.jmris.srcp.parser.SRCPParserDefaultVisitor;
import jmri.jmris.srcp.parser.SimpleNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRCPVisitor
extends SRCPParserDefaultVisitor {
    private String outputString = null;
    private static final Logger log = LoggerFactory.getLogger(SRCPVisitor.class);

    public String getOutputString() {
        return this.outputString;
    }

    private boolean isSupported(int bus, String devicegroup) {
        try {
            SystemConnectionMemo memo = InstanceManager.getList(SystemConnectionMemo.class).get(bus - 1);
            if (memo != null) {
                log.debug("devicegroup {}", (Object)devicegroup);
                if (devicegroup.equals("FB")) {
                    if (memo.provides(SensorManager.class)) {
                        return true;
                    }
                    this.outputString = "422 ERROR unsupported device group";
                } else if (devicegroup.equals("GA")) {
                    if (memo.provides(TurnoutManager.class)) {
                        return true;
                    }
                    this.outputString = "422 ERROR unsupported device group";
                } else if (devicegroup.equals("GL")) {
                    if (memo.provides(ThrottleManager.class)) {
                        return true;
                    }
                    this.outputString = "422 ERROR unsupported device group";
                } else if (devicegroup.equals("POWER")) {
                    if (memo.provides(PowerManager.class)) {
                        return true;
                    }
                    this.outputString = "422 ERROR unsupported device group";
                } else if (devicegroup.equals("SM")) {
                    if (memo.provides(GlobalProgrammerManager.class)) {
                        return true;
                    }
                    this.outputString = "422 ERROR unsupported device group";
                } else {
                    this.outputString = "422 ERROR unsupported device group";
                }
            } else {
                this.outputString = "416 ERROR no data";
            }
        }
        catch (IndexOutOfBoundsException obe) {
            this.outputString = "412 ERROR wrong value";
        }
        return false;
    }

    @Override
    public Object visit(ASTgo node, Object data) {
        log.debug("Go {}", node.jjtGetValue());
        JmriSRCPServiceHandler handle = (JmriSRCPServiceHandler)data;
        if (handle.getClientVersion().startsWith("0.8")) {
            handle.setRunMode();
            this.outputString = "200 OK GO " + ((JmriSRCPServiceHandler)data).getSessionNumber();
        } else {
            this.outputString = "402 ERROR insufficient data";
        }
        return data;
    }

    @Override
    public Object visit(ASThandshake_set node, Object data) {
        log.debug("Handshake Mode SET ");
        JmriSRCPServiceHandler handle = (JmriSRCPServiceHandler)data;
        if (node.jjtGetChild(0).getClass() == ASTprotocollitteral.class) {
            String version = (String)((SimpleNode)node.jjtGetChild(1)).jjtGetValue();
            if (version.startsWith("0.8")) {
                handle.setClientVersion(version);
                this.outputString = "201 OK PROTOCOL SRCP";
            } else {
                this.outputString = "400 ERROR unsupported protocol";
            }
        } else if (node.jjtGetChild(0).getClass() == ASTconnectionlitteral.class) {
            String mode = (String)((SimpleNode)node.jjtGetChild(1)).jjtGetValue();
            this.outputString = "202 OK CONNECTIONMODEOK";
            if (mode.equals("COMMAND")) {
                handle.setCommandMode(true);
            } else if (mode.equals("INFO")) {
                handle.setCommandMode(false);
            } else {
                this.outputString = "401 ERROR unsupported connection mode";
            }
        } else {
            this.outputString = "500 ERROR out of resources";
        }
        return data;
    }

    @Override
    public Object visit(ASTget node, Object data) {
        block61: {
            log.debug("Get {}", ((SimpleNode)node.jjtGetChild(1)).jjtGetValue());
            int bus = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(0)).jjtGetValue());
            if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("POWER") && this.isSupported(bus, "POWER")) {
                try {
                    ((ServiceHandler)data).getPowerServer().sendStatus(InstanceManager.getDefault(PowerManager.class).getPower());
                }
                catch (IOException iOException) {}
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("GA") && this.isSupported(bus, "GA")) {
                int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
                try {
                    ((JmriSRCPTurnoutServer)((ServiceHandler)data).getTurnoutServer()).sendStatus(bus, address);
                }
                catch (IOException iOException) {}
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("FB") && this.isSupported(bus, "FB")) {
                int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
                try {
                    ((JmriSRCPSensorServer)((ServiceHandler)data).getSensorServer()).sendStatus(bus, address);
                }
                catch (IOException iOException) {}
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("SM") && this.isSupported(bus, "SM")) {
                ProgrammingMode modeno = ProgrammingMode.REGISTERMODE;
                if (node.jjtGetChild(3).getClass() == ASTcv.class) {
                    modeno = ProgrammingMode.DIRECTBYTEMODE;
                } else if (node.jjtGetChild(3).getClass() == ASTcvbit.class) {
                    modeno = ProgrammingMode.DIRECTBITMODE;
                }
                int cv = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
                ((JmriSRCPProgrammerServer)((ServiceHandler)data).getProgrammerServer()).readCV(modeno, cv);
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("GL") && this.isSupported(bus, "GL")) {
                int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
                try {
                    ((JmriSRCPThrottleServer)((ServiceHandler)data).getThrottleServer()).sendStatus(bus, address);
                }
                catch (IOException cv) {}
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("TIME")) {
                try {
                    ((ServiceHandler)data).getTimeServer().sendTime();
                }
                catch (IOException address) {}
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("SERVER")) {
                this.outputString = "100 INFO 0 SERVER RUNNING";
            } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("DESCRIPTION")) {
                SimpleNode descriptionnode = (SimpleNode)node.jjtGetChild(1);
                int children = descriptionnode.jjtGetNumChildren();
                if (children == 0) {
                    if (bus == 0) {
                        this.outputString = "100 INFO 0 DESCRIPTION SERVER SESSION TIME";
                    } else {
                        this.outputString = "100 INFO " + bus;
                        try {
                            SystemConnectionMemo memo = InstanceManager.getList(SystemConnectionMemo.class).get(bus - 1);
                            if (memo != null) {
                                this.outputString = this.outputString + " DESCRIPTION";
                                if (memo.provides(SensorManager.class)) {
                                    this.outputString = this.outputString + " FB";
                                }
                                if (memo.provides(TurnoutManager.class)) {
                                    this.outputString = this.outputString + " GA";
                                }
                                if (memo.provides(ThrottleManager.class)) {
                                    this.outputString = this.outputString + " GL";
                                }
                                if (memo.provides(PowerManager.class)) {
                                    this.outputString = this.outputString + " POWER";
                                }
                                if (memo.provides(GlobalProgrammerManager.class)) {
                                    this.outputString = this.outputString + " SM";
                                }
                                break block61;
                            }
                            this.outputString = "416 ERROR no data";
                        }
                        catch (IndexOutOfBoundsException obe) {
                            this.outputString = "412 ERROR wrong value";
                        }
                    }
                } else if (children == 1) {
                    String devicegroup = (String)((SimpleNode)descriptionnode.jjtGetChild(0)).jjtGetValue();
                    this.outputString = "100 INFO " + bus;
                    log.debug("devicegroup {}", (Object)devicegroup);
                    this.outputString = devicegroup.equals("FB") && this.isSupported(bus, devicegroup) ? "419 ERROR list too short" : (devicegroup.equals("GA") && this.isSupported(bus, devicegroup) ? "419 ERROR list too short" : (devicegroup.equals("GL") && this.isSupported(bus, devicegroup) ? "419 ERROR list too short" : (devicegroup.equals("POWER") && this.isSupported(bus, devicegroup) ? this.outputString + " POWER" : (devicegroup.equals("SM") && this.isSupported(bus, devicegroup) ? "419 ERROR list too short" : "422 ERROR unsupported device group"))));
                } else if (children == 2) {
                    this.outputString = "100 INFO " + bus;
                    SystemConnectionMemo memo = InstanceManager.getList(SystemConnectionMemo.class).get(bus - 1);
                    if (memo != null) {
                        String devicegroup = (String)((SimpleNode)descriptionnode.jjtGetChild(0)).jjtGetValue();
                        String address = (String)((SimpleNode)descriptionnode.jjtGetChild(1)).jjtGetValue();
                        if (devicegroup.equals("FB") && this.isSupported(bus, devicegroup)) {
                            SensorManager mgr = memo.get(SensorManager.class);
                            try {
                                String searchName = mgr.createSystemName(address, memo.getSystemPrefix());
                                if (mgr.getBySystemName(searchName) != null) {
                                    this.outputString = this.outputString + " FB " + address;
                                    break block61;
                                }
                                this.outputString = "412 ERROR wrong value";
                            }
                            catch (JmriException je) {
                                this.outputString = "412 ERROR wrong value";
                            }
                        } else if (devicegroup.equals("GA") && this.isSupported(bus, devicegroup)) {
                            TurnoutManager mgr = memo.get(TurnoutManager.class);
                            try {
                                String searchName = mgr.createSystemName(address, memo.getSystemPrefix());
                                if (mgr.getBySystemName(searchName) != null) {
                                    this.outputString = this.outputString + " GA " + address + " N";
                                    break block61;
                                }
                                this.outputString = "412 ERROR wrong value";
                            }
                            catch (JmriException je) {
                                this.outputString = "412 ERROR wrong value";
                            }
                        } else if (devicegroup.equals("GL") && this.isSupported(bus, devicegroup)) {
                            this.outputString = "416 ERROR no data";
                        } else if (devicegroup.equals("POWER") && this.isSupported(bus, devicegroup)) {
                            this.outputString = "418 ERROR list too long";
                        } else if (devicegroup.equals("SM") && this.isSupported(bus, devicegroup)) {
                            this.outputString = "416 ERROR no data";
                        }
                    }
                } else {
                    this.outputString = "418 ERROR list too long";
                }
            } else {
                this.outputString = "422 ERROR unsupported device group";
            }
        }
        return data;
    }

    @Override
    public Object visit(ASTset node, Object data) {
        SimpleNode target = (SimpleNode)node.jjtGetChild(1);
        log.debug("Set {}", target.jjtGetValue());
        int bus = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(0)).jjtGetValue());
        if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("POWER") && this.isSupported(bus, "POWER")) {
            try {
                ((ServiceHandler)data).getPowerServer().parseStatus((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            }
            catch (IOException iOException) {
            }
            catch (JmriException jmriException) {}
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("GA") && this.isSupported(bus, "GA")) {
            int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            int port = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue());
            try {
                ((JmriSRCPTurnoutServer)((ServiceHandler)data).getTurnoutServer()).parseStatus(bus, address, port);
            }
            catch (JmriException jmriException) {
            }
            catch (IOException iOException) {}
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("FB") && this.isSupported(bus, "FB")) {
            int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            int value = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue());
            try {
                ((JmriSRCPSensorServer)((ServiceHandler)data).getSensorServer()).parseStatus(bus, address, value);
            }
            catch (IOException iOException) {}
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("SM") && this.isSupported(bus, "SM")) {
            ProgrammingMode modeno = ProgrammingMode.REGISTERMODE;
            if (node.jjtGetChild(3).getClass() == ASTcv.class) {
                modeno = ProgrammingMode.DIRECTBYTEMODE;
            } else if (node.jjtGetChild(3).getClass() == ASTcvbit.class) {
                modeno = ProgrammingMode.DIRECTBITMODE;
            }
            int cv = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
            int value = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(5)).jjtGetValue());
            ((JmriSRCPProgrammerServer)((ServiceHandler)data).getProgrammerServer()).writeCV(modeno, cv, value);
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("GL") && this.isSupported(bus, "GL")) {
            int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            String drivemode = (String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue();
            int speedstep = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
            int maxspeedstep = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(5)).jjtGetValue());
            ((JmriSRCPThrottleServer)((ServiceHandler)data).getThrottleServer()).setThrottleSpeedAndDirection(bus, address, (float)speedstep / (float)maxspeedstep, drivemode.equals("0"));
            int numFunctions = node.jjtGetNumChildren() - 6;
            ArrayList<Boolean> functionList = new ArrayList<Boolean>();
            for (int i = 0; i < numFunctions; ++i) {
                String functionMode = (String)((SimpleNode)node.jjtGetChild(i + 6)).jjtGetValue();
                functionList.add(functionMode.equals("1"));
            }
            ((JmriSRCPThrottleServer)((ServiceHandler)data).getThrottleServer()).setThrottleFunctions(bus, address, functionList);
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("TIME")) {
            try {
                JmriSRCPTimeServer ts = (JmriSRCPTimeServer)((ServiceHandler)data).getTimeServer();
                int julDay = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
                int hour = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue());
                int minute = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
                int second = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
                ts.parseTime(julDay, hour, minute, second);
                ts.startTime();
                ts.sendTime();
            }
            catch (IOException iOException) {}
        } else {
            this.outputString = "422 ERROR unsupported device group";
        }
        return data;
    }

    @Override
    public Object visit(ASTterm node, Object data) {
        SimpleNode target = (SimpleNode)node.jjtGetChild(1);
        int bus = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(0)).jjtGetValue());
        log.debug("TERM {} {}", (Object)bus, target.jjtGetValue());
        if (target.jjtGetValue().equals("SERVER")) {
            this.outputString = "200 OK";
            return data;
        }
        if (target.jjtGetValue().equals("SESSION")) {
            this.outputString = "102 INFO " + bus + " SESSION " + ((JmriSRCPServiceHandler)data).getSessionNumber();
            return data;
        }
        if (target.jjtGetValue().equals("GL")) {
            int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            try {
                ((JmriSRCPThrottleServer)((ServiceHandler)data).getThrottleServer()).releaseThrottle(bus, address);
            }
            catch (IOException ioe) {
                log.error("Error writing to network port");
            }
            return data;
        }
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTreset node, Object data) {
        log.debug("RESET {}", ((SimpleNode)node.jjtGetChild(1)).jjtGetValue());
        if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("SERVER")) {
            this.outputString = "413 ERROR temporarily prohibited";
            return data;
        }
        this.outputString = "422 ERROR unsupported device group";
        return node.childrenAccept(this, data);
    }

    @Override
    public Object visit(ASTinit node, Object data) {
        int bus = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(0)).jjtGetValue());
        log.debug("INIT {}", ((SimpleNode)node.jjtGetChild(1)).jjtGetValue());
        if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("POWER") && this.isSupported(bus, "POWER")) {
            this.outputString = "200 OK";
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("GA") && this.isSupported(bus, "GA")) {
            int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            String protocol = (String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue();
            try {
                ((JmriSRCPTurnoutServer)((ServiceHandler)data).getTurnoutServer()).initTurnout(bus, address, protocol);
            }
            catch (JmriException jmriException) {
            }
            catch (IOException iOException) {}
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("GL") && this.isSupported(bus, "GL")) {
            String protocol;
            int address = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            SimpleNode protocolNode = (SimpleNode)node.jjtGetChild(3);
            switch (protocol = (String)protocolNode.jjtGetValue()) {
                case "N": {
                    int protocolversion = Integer.parseInt((String)((SimpleNode)protocolNode.jjtGetChild(0)).jjtGetValue());
                    int speedsteps = Integer.parseInt((String)((SimpleNode)protocolNode.jjtGetChild(1)).jjtGetValue());
                    int functions = Integer.parseInt((String)((SimpleNode)protocolNode.jjtGetChild(2)).jjtGetValue());
                    try {
                        ((JmriSRCPThrottleServer)((ServiceHandler)data).getThrottleServer()).initThrottle(bus, address, protocolversion == 2, speedsteps, functions);
                    }
                    catch (IOException iOException) {}
                    break;
                }
                default: {
                    this.outputString = "420 ERROR unsupported device protocol";
                    return data;
                }
            }
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("TIME")) {
            try {
                int modeltime = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
                int realtime = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue());
                JmriSRCPTimeServer ts = (JmriSRCPTimeServer)((ServiceHandler)data).getTimeServer();
                ts.parseRate(modeltime, realtime);
                ts.sendRate();
            }
            catch (IOException iOException) {}
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("SM") && this.isSupported(bus, "SM")) {
            this.outputString = "200 OK";
        } else if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("FB") && this.isSupported(bus, "FB")) {
            this.outputString = "200 OK";
        }
        return data;
    }

    @Override
    public Object visit(ASTwait_cmd node, Object data) {
        log.debug("Received WAIT CMD {}", node.jjtGetValue());
        if (((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("TIME")) {
            long julday = Long.parseLong((String)((SimpleNode)node.jjtGetChild(2)).jjtGetValue());
            int Hour = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(3)).jjtGetValue());
            int Minute = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(4)).jjtGetValue());
            int Second = Integer.parseInt((String)((SimpleNode)node.jjtGetChild(5)).jjtGetValue());
            ((JmriSRCPTimeServer)((ServiceHandler)data).getTimeServer()).setAlarm(julday, Hour, Minute, Second);
        } else {
            this.outputString = ((SimpleNode)node.jjtGetChild(1)).jjtGetValue().equals("FB") ? "425 ERROR not supported" : "423 ERROR unsupported operation";
        }
        return data;
    }
}

