/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Font;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.ThrottleManager;
import jmri.jmrix.openlcb.OpenLcbLocoAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DccLocoAddressSelector
extends JPanel {
    JComboBox<String> box = null;
    JTextField text = new JTextField();
    private static final int FONT_SIZE_MIN = 12;
    private static final int FONT_SIZE_MAX = 96;
    private static final int FONT_INCREMENT = 2;
    private boolean locked = true;
    private boolean boxUsed = false;
    private boolean textUsed = false;
    private boolean panelUsed = false;
    boolean varFontSize = false;
    private static final String LONGEST_STRING = "MMMM";
    static final ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.DccLocoAddressSelectorBundle");
    private static final Logger log = LoggerFactory.getLogger(DccLocoAddressSelector.class);

    public DccLocoAddressSelector() {
        if (InstanceManager.getNullableDefault(ThrottleManager.class) != null && !InstanceManager.throttleManagerInstance().addressTypeUnique()) {
            this.configureBox(InstanceManager.throttleManagerInstance().getAddressTypes());
        } else {
            this.configureBox(new String[]{LocoAddress.Protocol.DCC_SHORT.getPeopleName(), LocoAddress.Protocol.DCC_LONG.getPeopleName()});
        }
    }

    public DccLocoAddressSelector(String[] protocols) {
        this.configureBox(protocols);
    }

    private void configureBox(String[] protocols) {
        this.box = new JComboBox<String>(protocols);
        this.box.setSelectedIndex(0);
        this.text = new JTextField();
        this.text.setColumns(4);
        this.text.setToolTipText(rb.getString("TooltipTextFieldEnabled"));
        this.box.setToolTipText(rb.getString("TooltipComboBoxEnabled"));
    }

    public void setLocked(boolean l) {
        this.locked = l;
    }

    public boolean getLocked(boolean l) {
        return this.locked;
    }

    public DccLocoAddress getAddress() {
        if (this.text.getText().isEmpty()) {
            return null;
        }
        if (InstanceManager.getNullableDefault(ThrottleManager.class) != null) {
            LocoAddress.Protocol protocol = InstanceManager.throttleManagerInstance().getProtocolFromString((String)this.box.getSelectedItem());
            return (DccLocoAddress)InstanceManager.throttleManagerInstance().getAddress(this.text.getText(), protocol);
        }
        int num = Integer.parseInt(this.text.getText());
        LocoAddress.Protocol protocol = LocoAddress.Protocol.getByPeopleName((String)this.box.getSelectedItem());
        return new DccLocoAddress(num, protocol);
    }

    public void setAddress(DccLocoAddress a) {
        if (a != null) {
            if (a instanceof OpenLcbLocoAddress) {
                OpenLcbLocoAddress oa = (OpenLcbLocoAddress)a;
                this.text.setText(oa.getNode().toString());
                this.box.setSelectedItem(LocoAddress.Protocol.OPENLCB.getPeopleName());
            } else {
                this.text.setText("" + a.getNumber());
                if (InstanceManager.getNullableDefault(ThrottleManager.class) != null) {
                    this.box.setSelectedItem(InstanceManager.throttleManagerInstance().getAddressTypeString(a.getProtocol()));
                } else {
                    this.box.setSelectedItem(a.getProtocol().getPeopleName());
                }
            }
        }
    }

    public void setVariableSize(boolean s) {
        this.varFontSize = s;
    }

    public void reset() {
        this.box.setSelectedIndex(0);
        this.text.setText("");
    }

    public JPanel getCombinedJPanel() {
        if (this.panelUsed) {
            log.error("getCombinedPanel invoked after panel already requested");
            return null;
        }
        if (this.textUsed) {
            log.error("getCombinedPanel invoked after text already requested");
            return null;
        }
        if (this.boxUsed) {
            log.error("getCombinedPanel invoked after text already requested");
            return null;
        }
        this.panelUsed = true;
        if (this.varFontSize) {
            this.text.setFont(new Font("", 0, 32));
        }
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.text);
        if (!this.locked || InstanceManager.getNullableDefault(ThrottleManager.class) != null && !InstanceManager.throttleManagerInstance().addressTypeUnique()) {
            p.add(this.box);
        }
        p.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                DccLocoAddressSelector.this.changeFontSizes();
            }
        });
        return p;
    }

    private void changeFontSizes() {
        Font f;
        if (!this.varFontSize) {
            return;
        }
        int fieldWidth = this.text.getSize().width;
        int stringWidth = this.text.getFontMetrics(this.text.getFont()).stringWidth(LONGEST_STRING) + 8;
        int fontSize = this.text.getFont().getSize();
        if (stringWidth > fieldWidth) {
            while (stringWidth > fieldWidth && fontSize >= 14) {
                f = new Font("", 0, fontSize -= 2);
                this.text.setFont(f);
                stringWidth = this.text.getFontMetrics(this.text.getFont()).stringWidth(LONGEST_STRING) + 8;
            }
        } else {
            while (fieldWidth - stringWidth > 10 && fontSize <= 94) {
                f = new Font("", 0, fontSize += 2);
                this.text.setFont(f);
                stringWidth = this.text.getFontMetrics(this.text.getFont()).stringWidth(LONGEST_STRING) + 8;
            }
        }
        int fieldHeight = this.text.getSize().height;
        int stringHeight = this.text.getFontMetrics(this.text.getFont()).getHeight();
        while (stringHeight > fieldHeight && fontSize >= 14) {
            Font f2 = new Font("", 0, fontSize -= 2);
            this.text.setFont(f2);
            stringHeight = this.text.getFontMetrics(this.text.getFont()).getHeight();
        }
    }

    @Override
    public void setEnabled(boolean e) {
        this.text.setEditable(e);
        this.text.setEnabled(e);
        this.text.setFocusable(e);
        this.box.setEnabled(e);
        if (e) {
            this.text.setToolTipText(rb.getString("TooltipTextFieldEnabled"));
            this.box.setToolTipText(rb.getString("TooltipComboBoxEnabled"));
        } else {
            this.text.setToolTipText(rb.getString("TooltipTextFieldDisabled"));
            this.box.setToolTipText(rb.getString("TooltipComboBoxDisabled"));
        }
    }

    public void setEnabledProtocol(boolean e) {
        this.box.setEnabled(e);
        if (e) {
            this.box.setToolTipText(rb.getString("TooltipComboBoxEnabled"));
        } else {
            this.box.setToolTipText(rb.getString("TooltipComboBoxDisabled"));
        }
    }

    public JTextField getTextField() {
        if (this.textUsed) {
            this.reportError("getTextField invoked after text already requested");
            return null;
        }
        this.textUsed = true;
        return this.text;
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="Error String needs to be evaluated unchanged.")
    void reportError(String msg) {
        log.error(msg, (Throwable)new Exception("traceback"));
    }

    public JComboBox<String> getSelector() {
        if (this.boxUsed) {
            log.error("getSelector invoked after text already requested");
            return null;
        }
        this.boxUsed = true;
        return this.box;
    }

    @Override
    public void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
        this.text.addKeyListener(l);
    }
}

