/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sound {
    public static final long LARGE_SIZE = 100000L;
    private final URL url;
    private boolean streaming = false;
    private boolean streamingStop = false;
    private AtomicReference<Clip> clipRef = new AtomicReference();
    private boolean autoClose = true;
    private static final Logger log = LoggerFactory.getLogger(Sound.class);

    public Sound(@Nonnull String path) throws NullPointerException {
        this(FileUtil.findURL(path));
    }

    public Sound(@Nonnull File file) throws MalformedURLException {
        this(file.toURI().toURL());
    }

    public Sound(@Nonnull URL url) throws NullPointerException {
        if (url == null) {
            throw new NullPointerException();
        }
        this.url = url;
        try {
            this.streaming = this.needStreaming();
            if (!this.streaming) {
                this.clipRef.updateAndGet(clip -> this.openClip());
            }
        }
        catch (URISyntaxException ex) {
            this.streaming = false;
        }
        catch (IOException ex) {
            log.error("Unable to open {}", (Object)url);
        }
    }

    private Clip openClip() {
        Clip newClip = null;
        try {
            newClip = AudioSystem.getClip(null);
            newClip.addLineListener(event -> {
                if (LineEvent.Type.STOP.equals(event.getType()) && this.autoClose) {
                    this.clipRef.updateAndGet(clip -> {
                        if (clip != null) {
                            clip.close();
                        }
                        return null;
                    });
                }
            });
            newClip.open(AudioSystem.getAudioInputStream(this.url));
        }
        catch (IOException ex) {
            log.error("Unable to open {}", (Object)this.url);
        }
        catch (LineUnavailableException ex) {
            log.error("Unable to provide audio playback", (Throwable)ex);
        }
        catch (UnsupportedAudioFileException ex) {
            log.error("{} is not a recognised audio format", (Object)this.url);
        }
        return newClip;
    }

    public void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public boolean getAutoClose() {
        return this.autoClose;
    }

    public void close() {
        if (this.streaming) {
            this.streamingStop = true;
        } else {
            this.clipRef.updateAndGet(clip -> {
                if (clip != null) {
                    clip.close();
                }
                return null;
            });
        }
    }

    public void play() {
        this.play(false);
    }

    public void play(boolean autoClose) {
        this.streamingStop = false;
        if (this.streaming) {
            StreamingSound streamSound = new StreamingSound(this.url);
            Thread tStream = ThreadingUtil.newThread(streamSound);
            String path = this.url.getPath();
            tStream.setName("Play " + path.substring(path.lastIndexOf(47) + 1));
            tStream.start();
        } else {
            this.clipRef.updateAndGet(clip -> {
                if (clip == null) {
                    clip = this.openClip();
                }
                if (clip != null) {
                    if (autoClose) {
                        clip.addLineListener(event -> {
                            if (event.getType() == LineEvent.Type.STOP) {
                                event.getLine().close();
                            }
                        });
                    }
                    clip.start();
                }
                return clip;
            });
        }
    }

    public void loop() {
        this.loop(-1);
    }

    public void loop(int count) {
        this.streamingStop = false;
        if (this.streaming) {
            StreamingSound streamSound = new StreamingSound(this.url, count);
            Thread tStream = ThreadingUtil.newThread(streamSound);
            String path = this.url.getPath();
            tStream.setName("Loop " + path.substring(path.lastIndexOf(47) + 1));
            tStream.start();
        } else {
            this.clipRef.updateAndGet(clip -> {
                if (clip == null) {
                    clip = this.openClip();
                }
                if (clip != null) {
                    clip.loop(count);
                }
                return clip;
            });
        }
    }

    public void stop() {
        if (this.streaming) {
            this.streamingStop = true;
        } else {
            this.clipRef.updateAndGet(clip -> {
                if (clip != null) {
                    clip.stop();
                }
                return clip;
            });
        }
    }

    private boolean needStreaming() throws URISyntaxException, IOException {
        if (this.url != null) {
            if ("file".equals(this.url.getProtocol())) {
                return new File(this.url.toURI()).length() > 100000L;
            }
            return this.url.openConnection().getContentLengthLong() > 100000L;
        }
        return false;
    }

    public static void playSoundBuffer(byte[] wavData) {
        SourceDataLine line;
        boolean bigEndian;
        float sampleRate = 11200.0f;
        int sampleSizeInBits = 8;
        int channels = 1;
        boolean signed = sampleSizeInBits > 8;
        AudioFormat format = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian = true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
        if (!AudioSystem.isLineSupported(info)) {
            log.warn("line not supported: {}", (Object)info);
            return;
        }
        try {
            line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
        }
        catch (LineUnavailableException ex) {
            log.error("error opening line", (Throwable)ex);
            return;
        }
        line.start();
        line.write(wavData, 0, wavData.length);
    }

    public void dispose() {
        if (!this.streaming) {
            this.clipRef.updateAndGet(clip -> {
                if (clip != null) {
                    clip.close();
                }
                return null;
            });
        }
    }

    public class StreamingSound
    implements Runnable {
        private final URL localUrl;
        private AudioInputStream stream = null;
        private AudioFormat format = null;
        private SourceDataLine line = null;
        private Sensor streamingSensor = null;
        private final int count;

        public StreamingSound(URL url) {
            this(url, 1);
        }

        public StreamingSound(URL url, int count) {
            this.localUrl = url;
            this.count = count;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.stream = AudioSystem.getAudioInputStream(this.localUrl);
                this.format = this.stream.getFormat();
                log.debug("Audio format: {}", (Object)this.format);
                if (this.format.getEncoding() == AudioFormat.Encoding.ULAW || this.format.getEncoding() == AudioFormat.Encoding.ALAW) {
                    AudioFormat newFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.format.getSampleRate(), this.format.getSampleSizeInBits() * 2, this.format.getChannels(), this.format.getFrameSize() * 2, this.format.getFrameRate(), true);
                    this.stream = AudioSystem.getAudioInputStream(newFormat, this.stream);
                    log.info("Converted Audio format: {}", (Object)newFormat);
                    this.format = newFormat;
                    log.debug("new converted Audio format: {}", (Object)this.format);
                }
            }
            catch (UnsupportedAudioFileException e) {
                log.error("AudioFileException {}", (Object)e.getMessage());
                return;
            }
            catch (IOException e) {
                log.error("IOException {}", (Object)e.getMessage());
                return;
            }
            if (this.streamingSensor == null) {
                this.streamingSensor = InstanceManager.sensorManagerInstance().provideSensor("ISSOUNDSTREAMING");
            }
            this.setSensor(2);
            if (!Sound.this.streamingStop) {
                try {
                    DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.format);
                    if (!AudioSystem.isLineSupported(info)) {
                        log.error("Audio play() does not support: {}", (Object)this.format);
                        return;
                    }
                    this.line = (SourceDataLine)AudioSystem.getLine(info);
                    this.line.open(this.format);
                }
                catch (Exception e) {
                    log.error("Exception while creating Audio out {}", (Object)e.getMessage());
                    return;
                }
            }
            if (Sound.this.streamingStop) {
                if (this.line != null) {
                    this.line.close();
                }
                this.setSensor(4);
                return;
            }
            byte[] buffer = new byte[this.line.getBufferSize()];
            log.debug("streaming sound buffer size = {}", (Object)this.line.getBufferSize());
            this.line.start();
            try {
                if (this.stream.markSupported()) {
                    this.stream.mark(Integer.MAX_VALUE);
                }
                int i = 0;
                while (!(Sound.this.streamingStop || i++ >= this.count && this.count != -1)) {
                    int numRead;
                    while ((numRead = this.stream.read(buffer, 0, buffer.length)) >= 0) {
                        for (int offset = 0; offset < numRead; offset += this.line.write(buffer, offset, numRead - offset)) {
                        }
                    }
                    if (this.stream.markSupported()) {
                        this.stream.reset();
                        continue;
                    }
                    this.stream.close();
                    try {
                        this.stream = AudioSystem.getAudioInputStream(this.localUrl);
                    }
                    catch (UnsupportedAudioFileException e) {
                        log.error("AudioFileException {}", (Object)e.getMessage());
                        this.closeLine();
                        return;
                    }
                    catch (IOException e) {
                        log.error("IOException {}", (Object)e.getMessage());
                        this.closeLine();
                        return;
                    }
                }
            }
            catch (IOException e) {
                log.error("IOException while reading sound file {}", (Object)e.getMessage());
            }
            this.closeLine();
        }

        private void closeLine() {
            this.line.drain();
            this.line.stop();
            this.line.close();
            this.setSensor(4);
        }

        private void setSensor(int mode) {
            if (this.streamingSensor != null) {
                try {
                    this.streamingSensor.setState(mode);
                }
                catch (JmriException ex) {
                    log.error("Exception while setting ISSOUNDSTREAMING sensor {} to {}", (Object)this.streamingSensor.getDisplayName(), (Object)mode);
                }
            }
        }
    }

    public static class WavBuffer {
        @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
        int fmtOffset;
        byte[] buffer;

        public WavBuffer(byte[] content) {
            this.buffer = Arrays.copyOf(content, content.length);
            int index = 12;
            while (index < this.buffer.length) {
                if (this.buffer[index] == 102 && this.buffer[index + 1] == 109 && this.buffer[index + 2] == 116 && this.buffer[index + 3] == 32) {
                    this.fmtOffset = index;
                    return;
                }
                index = index + 8 + this.buffer[index + 4] + this.buffer[index + 5] * 256 + this.buffer[index + 6] * 256 * 256 + this.buffer[index + 7] * 256 * 256 * 256;
                log.debug("index now {}", (Object)index);
            }
            log.error("Didn't find fmt chunk");
        }

        float getSampleRate() {
            return 11200.0f;
        }

        int getSampleSizeInBits() {
            return 8;
        }

        int getChannels() {
            return 1;
        }

        boolean getBigEndian() {
            return false;
        }

        boolean getSigned() {
            return this.getSampleSizeInBits() > 8;
        }
    }
}

