/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.ServiceLoader;
import javax.annotation.CheckForNull;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JSeparator;
import jmri.AddressedProgrammerManager;
import jmri.ConsistManager;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.ThrottleManager;
import jmri.jmris.simpleserver.SimpleServerAction;
import jmri.jmris.srcp.JmriSRCPServerAction;
import jmri.jmrit.Bundle;
import jmri.jmrit.analogclock.AnalogClockAction;
import jmri.jmrit.beantable.ListedTableAction;
import jmri.jmrit.beantable.OBlockTableAction;
import jmri.jmrit.blockboss.BlockBossAction;
import jmri.jmrit.cabsignals.CabSignalAction;
import jmri.jmrit.consisttool.ConsistToolAction;
import jmri.jmrit.ctc.CtcRunAction;
import jmri.jmrit.ctc.editor.CtcEditorAction;
import jmri.jmrit.dispatcher.DispatcherAction;
import jmri.jmrit.dualdecoder.DualDecoderToolAction;
import jmri.jmrit.lcdclock.LcdClockAction;
import jmri.jmrit.logixng.tools.swing.LogixNGMenu;
import jmri.jmrit.nixieclock.NixieClockAction;
import jmri.jmrit.operations.OperationsMenu;
import jmri.jmrit.powerpanel.PowerPanelAction;
import jmri.jmrit.pragotronclock.PragotronClockAction;
import jmri.jmrit.sendpacket.SendPacketAction;
import jmri.jmrit.sensorgroup.SensorGroupAction;
import jmri.jmrit.simpleclock.SimpleClockAction;
import jmri.jmrit.simplelightctrl.SimpleLightCtrlAction;
import jmri.jmrit.simpleprog.SimpleProgAction;
import jmri.jmrit.simpleturnoutctrl.SimpleTurnoutCtrlAction;
import jmri.jmrit.speedometer.SpeedometerAction;
import jmri.jmrit.swing.ToolsMenuAction;
import jmri.jmrit.swing.meter.MeterAction;
import jmri.jmrit.symbolicprog.tabbedframe.PaneOpsProgAction;
import jmri.jmrit.symbolicprog.tabbedframe.PaneProgAction;
import jmri.jmrit.throttle.LoadDefaultXmlThrottlesLayoutAction;
import jmri.jmrit.throttle.LoadXmlThrottlesLayoutAction;
import jmri.jmrit.throttle.StoreDefaultXmlThrottlesLayoutAction;
import jmri.jmrit.throttle.StoreXmlThrottlesLayoutAction;
import jmri.jmrit.throttle.ThrottleCreationAction;
import jmri.jmrit.throttle.ThrottlesListAction;
import jmri.jmrit.timetable.swing.TimeTableAction;
import jmri.jmrit.vsdecoder.VSDecoderCreationAction;
import jmri.jmrit.vsdecoder.swing.ManageLocationsAction;
import jmri.jmrit.vsdecoder.swing.VSDPreferencesAction;
import jmri.jmrit.whereused.WhereUsedAction;
import jmri.jmrit.withrottle.WiThrottleCreationAction;
import jmri.jmrit.z21server.Z21serverCreationAction;
import jmri.jmrix.ConnectionConfig;
import jmri.jmrix.ConnectionConfigManager;
import jmri.jmrix.ConnectionStatus;
import jmri.util.gui.GuiLafPreferencesManager;
import jmri.web.server.WebServerAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolsMenu
extends JMenu {
    ConnectionConfig serModeProCon = null;
    ConnectionConfig opsModeProCon = null;
    AbstractAction serviceAction = new PaneProgAction(Bundle.getMessage("MenuItemDecoderProServiceProgrammer"));
    AbstractAction opsAction = new PaneOpsProgAction(Bundle.getMessage("MenuItemDecoderProOpsModeProgrammer"));
    private static final Logger log = LoggerFactory.getLogger(ToolsMenu.class);

    public ToolsMenu(String name) {
        this();
        this.setText(name);
    }

    public ToolsMenu() {
        this.setText(Bundle.getMessage("MenuTools"));
        JMenu programmerMenu = new JMenu(Bundle.getMessage("MenuProgrammers"));
        programmerMenu.add(new SimpleProgAction());
        programmerMenu.add(this.serviceAction);
        programmerMenu.add(this.opsAction);
        programmerMenu.add(new DualDecoderToolAction());
        this.add(programmerMenu);
        if (InstanceManager.getNullableDefault(AddressedProgrammerManager.class) == null && InstanceManager.getNullableDefault(GlobalProgrammerManager.class) == null) {
            programmerMenu.setEnabled(false);
        }
        JMenu tableMenu = new JMenu(Bundle.getMessage("MenuTables"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemTurnoutTable"), "jmri.jmrit.beantable.TurnoutTableTabAction"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemSensorTable"), "jmri.jmrit.beantable.SensorTableTabAction"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemLightTable"), "jmri.jmrit.beantable.LightTableTabAction"));
        JMenu signalMenu = new JMenu(Bundle.getMessage("MenuSignals"));
        signalMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemSignalTable"), "jmri.jmrit.beantable.SignalHeadTableAction"));
        signalMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemSignalMastTable"), "jmri.jmrit.beantable.SignalMastTableAction"));
        signalMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemSignalGroupTable"), "jmri.jmrit.beantable.SignalGroupTableAction"));
        signalMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemSignalMastLogicTable"), "jmri.jmrit.beantable.SignalMastLogicTableAction"));
        tableMenu.add(signalMenu);
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemReporterTable"), "jmri.jmrit.beantable.ReporterTableTabAction"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemMemoryTable"), "jmri.jmrit.beantable.MemoryTableAction"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemStringIOTable"), "jmri.jmrit.beantable.StringIOTableAction"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemRouteTable"), "jmri.jmrit.beantable.RouteTableAction"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemLRouteTable"), "jmri.jmrit.beantable.LRouteTableAction"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemLogixTable"), "jmri.jmrit.beantable.LogixTableAction"));
        JMenu logixNG_Menu = new JMenu(Bundle.getMessage("MenuLogixNG"));
        logixNG_Menu.add(new ListedTableAction(Bundle.getMessage("MenuItemLogixNGTable"), "jmri.jmrit.beantable.LogixNGTableAction"));
        logixNG_Menu.add(new ListedTableAction(Bundle.getMessage("MenuItemLogixNGModuleTable"), "jmri.jmrit.beantable.LogixNGModuleTableAction"));
        logixNG_Menu.add(new ListedTableAction(Bundle.getMessage("MenuItemLogixNGTableTable"), "jmri.jmrit.beantable.LogixNGTableTableAction"));
        logixNG_Menu.add(new ListedTableAction(Bundle.getMessage("MenuItemLogixNGGlobalVariableTableAction"), "jmri.jmrit.beantable.LogixNGGlobalVariableTableAction"));
        tableMenu.add(logixNG_Menu);
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemBlockTable"), "jmri.jmrit.beantable.BlockTableAction"));
        if (InstanceManager.getDefault(GuiLafPreferencesManager.class).isOblockEditTabbed()) {
            tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemOBlockTable"), "jmri.jmrit.beantable.OBlockTableAction"));
        } else {
            tableMenu.add(new OBlockTableAction(Bundle.getMessage("MenuItemOBlockTable")));
        }
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemSectionTable"), "jmri.jmrit.beantable.SectionTableAction"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemTransitTable"), "jmri.jmrit.beantable.TransitTableAction"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemAudioTable"), "jmri.jmrit.beantable.AudioTableAction"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemIdTagTable"), "jmri.jmrit.beantable.IdTagTableTabAction"));
        tableMenu.add(new ListedTableAction(Bundle.getMessage("MenuItemRailComTable"), "jmri.jmrit.beantable.RailComTableAction"));
        this.add(tableMenu);
        JMenu throttleMenu = new JMenu(Bundle.getMessage("MenuThrottles"));
        ThrottleCreationAction.addNewThrottleItemsToThrottleMenu(throttleMenu);
        throttleMenu.add(new ThrottlesListAction(Bundle.getMessage("MenuItemThrottlesList")));
        throttleMenu.addSeparator();
        throttleMenu.add(new StoreXmlThrottlesLayoutAction(Bundle.getMessage("MenuItemSaveThrottleLayout")));
        throttleMenu.add(new LoadXmlThrottlesLayoutAction(Bundle.getMessage("MenuItemLoadThrottleLayout")));
        throttleMenu.addSeparator();
        throttleMenu.add(new StoreDefaultXmlThrottlesLayoutAction(Bundle.getMessage("MenuItemSaveAsDefaultThrottleLayout")));
        throttleMenu.add(new LoadDefaultXmlThrottlesLayoutAction(Bundle.getMessage("MenuItemLoadDefaultThrottleLayout")));
        throttleMenu.add(new JSeparator());
        throttleMenu.add(new WiThrottleCreationAction(Bundle.getMessage("MenuItemStartWiThrottle")));
        this.add(throttleMenu);
        if (InstanceManager.getNullableDefault(ThrottleManager.class) == null) {
            throttleMenu.setEnabled(false);
        }
        ConsistToolAction consistAction = new ConsistToolAction(Bundle.getMessage("MenuItemConsistTool"));
        this.add(consistAction);
        ConsistManager consistManager = InstanceManager.getNullableDefault(ConsistManager.class);
        if (consistManager == null) {
            consistAction.setEnabled(false);
        } else if (consistManager.canBeDisabled()) {
            consistManager.registerEnableListener(value -> consistAction.setEnabled(value));
            consistAction.setEnabled(consistManager.isEnabled());
        }
        JMenu clockMenu = new JMenu(Bundle.getMessage("MenuClocks"));
        clockMenu.add(new SimpleClockAction(Bundle.getMessage("MenuItemSetupClock")));
        clockMenu.add(new NixieClockAction(Bundle.getMessage("MenuItemNixieClock")));
        clockMenu.add(new LcdClockAction(Bundle.getMessage("MenuItemLcdClock")));
        clockMenu.add(new AnalogClockAction(Bundle.getMessage("MenuItemAnalogClock")));
        clockMenu.add(new PragotronClockAction(Bundle.getMessage("MenuItemPragotronClock")));
        this.add(clockMenu);
        this.add(new JSeparator());
        this.add(new PowerPanelAction(Bundle.getMessage("MenuItemPowerControl")));
        this.add(new SimpleTurnoutCtrlAction(Bundle.getMessage("MenuItemTurnoutControl")));
        this.add(new SimpleLightCtrlAction(Bundle.getMessage("MenuItemLightControl")));
        this.add(new SpeedometerAction(Bundle.getMessage("MenuItemSpeedometer")));
        this.add(new MeterAction(Bundle.getMessage("MenuItemMeter")));
        this.add(new SensorGroupAction(Bundle.getMessage("MenuItemSensorGroup")));
        this.add(new BlockBossAction(Bundle.getMessage("MenuItemSimpleSignal")));
        this.add(new SendPacketAction(Bundle.getMessage("MenuItemSendDCCPacket")));
        this.add(new JSeparator());
        this.add(new OperationsMenu());
        this.add(new DispatcherAction(Bundle.getMessage("MenuItemDispatcher")));
        this.add(new TimeTableAction(Bundle.getMessage("MenuItemTimeTable")));
        this.add(new WhereUsedAction(Bundle.getMessage("MenuItemWhereUsed")));
        JMenu ctcMenu = new JMenu(Bundle.getMessage("MenuCTC"));
        ctcMenu.add(new CtcEditorAction(Bundle.getMessage("MenuItemCTCEditor")));
        ctcMenu.add(new CtcRunAction(Bundle.getMessage("MenuItemCTCMain")));
        this.add(ctcMenu);
        this.add(new jmri.jmrit.ussctc.ToolsMenu());
        this.add(new CabSignalAction());
        this.add(new JSeparator());
        JMenu serverMenu = new JMenu(Bundle.getMessage("MenuServers"));
        serverMenu.add(new WebServerAction());
        serverMenu.add(new WiThrottleCreationAction());
        serverMenu.add(new Z21serverCreationAction());
        serverMenu.add(new JSeparator());
        serverMenu.add(new SimpleServerAction());
        serverMenu.add(new JmriSRCPServerAction());
        this.add(serverMenu);
        this.add(new JSeparator());
        JMenu vsdMenu = new JMenu(Bundle.getMessage("MenuItemVSDecoder"));
        vsdMenu.add(new VSDecoderCreationAction(Bundle.getMessage("MenuItemVSDecoderManager")));
        vsdMenu.add(new ManageLocationsAction(Bundle.getMessage("MenuItemVSDecoderLocationManager")));
        vsdMenu.add(new VSDPreferencesAction(Bundle.getMessage("MenuItemVSDecoderPreferences")));
        this.add(vsdMenu);
        this.add(new JSeparator());
        this.add(new LogixNGMenu());
        this.updateProgrammerStatus(null);
        ConnectionStatus.instance().addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("change") || e.getPropertyName().equals("add")) {
                log.debug("Received property {} with value {} ", (Object)e.getPropertyName(), e.getNewValue());
                this.updateProgrammerStatus(e);
            }
        });
        InstanceManager.addPropertyChangeListener(InstanceManager.getListPropertyName(AddressedProgrammerManager.class), evt -> {
            AddressedProgrammerManager m = (AddressedProgrammerManager)evt.getNewValue();
            if (m != null) {
                m.addPropertyChangeListener(this::updateProgrammerStatus);
            }
            this.updateProgrammerStatus(evt);
        });
        InstanceManager.getList(AddressedProgrammerManager.class).forEach(m -> m.addPropertyChangeListener(this::updateProgrammerStatus));
        InstanceManager.addPropertyChangeListener(InstanceManager.getListPropertyName(GlobalProgrammerManager.class), evt -> {
            GlobalProgrammerManager m = (GlobalProgrammerManager)evt.getNewValue();
            if (m != null) {
                m.addPropertyChangeListener(this::updateProgrammerStatus);
            }
            this.updateProgrammerStatus(evt);
        });
        InstanceManager.getList(GlobalProgrammerManager.class).forEach(m -> m.addPropertyChangeListener(this::updateProgrammerStatus));
        ArrayList<ToolsMenuAction> newItemList = new ArrayList<ToolsMenuAction>();
        ServiceLoader.load(ToolsMenuAction.class).forEach(toolsMenuAction -> newItemList.add((ToolsMenuAction)toolsMenuAction));
        if (!newItemList.isEmpty()) {
            this.add(new JSeparator());
            newItemList.forEach(item -> {
                log.info("Adding Plug In '{}' to Tools Menu", item);
                this.add((Action)item);
            });
        }
    }

    protected void updateProgrammerStatus(@CheckForNull PropertyChangeEvent evt) {
        log.debug("Updating Programmer Status for property {}", (Object)(evt != null ? evt.getPropertyName() : "null"));
        ConnectionConfig oldServMode = this.serModeProCon;
        ConnectionConfig oldOpsMode = this.opsModeProCon;
        GlobalProgrammerManager gpm = null;
        AddressedProgrammerManager apm = null;
        if (InstanceManager.containsDefault(GlobalProgrammerManager.class) || evt != null && evt.getPropertyName().equals(InstanceManager.getDefaultsPropertyName(GlobalProgrammerManager.class)) && evt.getNewValue() == null) {
            gpm = InstanceManager.getNullableDefault(GlobalProgrammerManager.class);
            log.trace("found global programming manager {}", (Object)gpm);
        }
        if (gpm != null) {
            String serviceModeProgrammerName = gpm.getUserName();
            log.debug("GlobalProgrammerManager found of class {} name {} ", gpm.getClass(), (Object)serviceModeProgrammerName);
            InstanceManager.getOptionalDefault(ConnectionConfigManager.class).ifPresent(ccm -> {
                for (ConnectionConfig connection : ccm) {
                    log.debug("Checking connection name {}", (Object)connection.getConnectionName());
                    if (connection.getConnectionName() == null || !connection.getConnectionName().equals(serviceModeProgrammerName)) continue;
                    log.debug("Connection found for GlobalProgrammermanager");
                    this.serModeProCon = connection;
                }
            });
        }
        if (InstanceManager.containsDefault(AddressedProgrammerManager.class) || evt != null && evt.getPropertyName().equals(InstanceManager.getDefaultsPropertyName(AddressedProgrammerManager.class)) && evt.getNewValue() == null) {
            apm = InstanceManager.getNullableDefault(AddressedProgrammerManager.class);
            log.trace("found addressed programming manager {}", (Object)gpm);
        }
        if (apm != null) {
            String opsModeProgrammerName = apm.getUserName();
            log.debug("AddressedProgrammerManager found of class {} name {} ", apm.getClass(), (Object)opsModeProgrammerName);
            InstanceManager.getOptionalDefault(ConnectionConfigManager.class).ifPresent(ccm -> {
                for (ConnectionConfig connection : ccm) {
                    log.debug("Checking connection name {}", (Object)connection.getConnectionName());
                    if (connection.getConnectionName() == null || !connection.getConnectionName().equals(opsModeProgrammerName)) continue;
                    log.debug("Connection found for AddressedProgrammermanager");
                    this.opsModeProCon = connection;
                }
            });
        }
        log.trace("start global check with {}, {}, {}", new Object[]{this.serModeProCon, gpm, gpm != null ? Boolean.valueOf(gpm.isGlobalProgrammerAvailable()) : "<none>"});
        if (gpm != null && gpm.isGlobalProgrammerAvailable()) {
            log.debug("service mode available");
            if (oldServMode == null) {
                this.serviceAction.setEnabled(true);
                this.firePropertyChange("setprogservice", "setEnabled", (Object)true);
            }
        } else {
            log.debug("no service programmer");
            if (oldServMode != null) {
                this.serviceAction.setEnabled(false);
                this.firePropertyChange("setprogservice", "setEnabled", (Object)false);
            }
            this.serModeProCon = null;
        }
        if (apm != null && apm.isAddressedModePossible()) {
            log.debug("ops mode available");
            if (oldOpsMode == null) {
                this.opsAction.setEnabled(true);
                this.firePropertyChange("setprogops", "setEnabled", (Object)true);
            }
        } else {
            log.debug("no ops mode programmer");
            if (oldOpsMode != null) {
                this.opsAction.setEnabled(false);
                this.firePropertyChange("setprogops", "setEnabled", (Object)false);
            }
            this.opsModeProCon = null;
        }
    }
}

