/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.analogclock;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.jmrit.analogclock.Bundle;
import jmri.jmrit.catalog.NamedIcon;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;

public class AnalogClockFrame
extends JmriJFrame
implements PropertyChangeListener {
    Timebase clock = InstanceManager.getDefault(Timebase.class);
    double minuteAngle;
    double hourAngle;
    String amPm;
    JButton b;

    public AnalogClockFrame() {
        super(Bundle.getMessage("MenuItemAnalogClock"));
        this.setPreferredSize(new Dimension(200, 200));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        ClockPanel analogClockPanel = new ClockPanel();
        analogClockPanel.setOpaque(true);
        this.getContentPane().add(analogClockPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        this.b = new JButton(Bundle.getMessage("ButtonPauseClock"));
        buttonPanel.add(this.b);
        this.updateButtonText();
        this.b.addActionListener(new ButtonListener());
        this.b.setOpaque(true);
        this.b.setVisible(true);
        this.getContentPane().add(buttonPanel);
        buttonPanel.setVisible(this.clock.getShowStopButton());
        this.pack();
        ThreadingUtil.runOnGUIEventually(() -> this.update());
        this.clock.addPropertyChangeListener(this);
        this.clock.addMinuteChangeListener(e -> this.update());
    }

    void update() {
        Date now = this.clock.getTime();
        int hours = now.getHours();
        int minutes = now.getMinutes();
        this.minuteAngle = (double)minutes * 6.0;
        this.hourAngle = (double)hours * 30.0 + 30.0 * this.minuteAngle / 360.0;
        this.amPm = hours < 12 ? Bundle.getMessage("ClockAM") : Bundle.getMessage("ClockPM");
        if (hours == 12 && minutes == 0) {
            this.amPm = Bundle.getMessage("ClockNoon");
        }
        if (hours == 0 && minutes == 0) {
            this.amPm = Bundle.getMessage("ClockMidnight");
        }
        if (!this.clock.getRun()) {
            this.amPm = this.amPm + " " + Bundle.getMessage("ClockStopped");
        } else {
            Object rate = "" + (int)this.clock.userGetRate();
            if (Math.floor(this.clock.userGetRate()) != this.clock.userGetRate()) {
                DecimalFormat format = new DecimalFormat("0.###");
                rate = format.format(this.clock.userGetRate());
            }
            this.amPm = this.amPm + " " + (String)rate + ":1";
        }
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.updateButtonText();
        this.update();
    }

    private void updateButtonText() {
        this.b.setText(Bundle.getMessage(this.clock.getRun() ? "ButtonPauseClock" : "ButtonRunClock"));
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent a) {
            AnalogClockFrame.this.clock.setRun(!AnalogClockFrame.this.clock.getRun());
            AnalogClockFrame.this.updateButtonText();
        }
    }

    public class ClockPanel
    extends JPanel {
        Image logo;
        Image scaledLogo;
        NamedIcon jmriIcon;
        NamedIcon scaledIcon;
        int[] hourX = new int[]{-12, -11, -25, -10, -10, 0, 10, 10, 25, 11, 12};
        int[] hourY = new int[]{-31, -163, -170, -211, -276, -285, -276, -211, -170, -163, -31};
        int[] minuteX = new int[]{-12, -11, -24, -11, -11, 0, 11, 11, 24, 11, 12};
        int[] minuteY = new int[]{-31, -261, -266, -314, -381, -391, -381, -314, -266, -261, -31};
        int[] scaledHourX = new int[this.hourX.length];
        int[] scaledHourY = new int[this.hourY.length];
        int[] scaledMinuteX = new int[this.minuteX.length];
        int[] scaledMinuteY = new int[this.minuteY.length];
        int[] rotatedHourX = new int[this.hourX.length];
        int[] rotatedHourY = new int[this.hourY.length];
        int[] rotatedMinuteX = new int[this.minuteX.length];
        int[] rotatedMinuteY = new int[this.minuteY.length];
        Polygon scaledHourHand;
        Polygon scaledMinuteHand;
        int minuteHeight;
        double scaleRatio;
        int faceSize;
        int size;
        int logoWidth;
        int logoHeight;
        int centreX;
        int centreY;

        public ClockPanel() {
            this.jmriIcon = new NamedIcon("resources/logo.gif", "resources/logo.gif");
            this.scaledIcon = new NamedIcon("resources/logo.gif", "resources/logo.gif");
            this.logo = this.jmriIcon.getImage();
            Polygon minuteHand = new Polygon(this.minuteX, this.minuteY, 11);
            this.minuteHeight = minuteHand.getBounds().getSize().height;
            AnalogClockFrame.this.amPm = "AM";
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ClockPanel.this.scaleFace();
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            int i;
            g.translate(this.centreX, this.centreY);
            g.setColor(Color.white);
            g.fillOval(-this.faceSize / 2, -this.faceSize / 2, this.faceSize, this.faceSize);
            g.setColor(Color.black);
            g.drawOval(-this.faceSize / 2, -this.faceSize / 2, this.faceSize, this.faceSize);
            int dotSize = this.faceSize / 40;
            g.fillOval(-dotSize * 2, -dotSize * 2, 4 * dotSize, 4 * dotSize);
            g.setColor(Color.white);
            g.fillOval(-dotSize, -dotSize, 2 * dotSize, 2 * dotSize);
            g.setColor(Color.black);
            g.fillOval(-dotSize / 2, -dotSize / 2, dotSize, dotSize);
            g.drawImage(this.scaledLogo, -this.logoWidth / 2, -this.faceSize / 4, this.logoWidth, this.logoHeight, this);
            int dashSize = this.size / 60;
            for (i = 0; i < 360; i += 6) {
                g.drawLine(this.dotX((double)this.faceSize / 2.0, i), this.dotY((double)this.faceSize / 2.0, i), this.dotX((double)this.faceSize / 2.0 - (double)dashSize, i), this.dotY((double)this.faceSize / 2.0 - (double)dashSize, i));
            }
            for (i = 0; i < 360; i += 30) {
                g.drawLine(this.dotX((double)this.faceSize / 2.0, i), this.dotY((double)this.faceSize / 2.0, i), this.dotX((double)this.faceSize / 2.0 - (double)(3 * dashSize), i), this.dotY((double)this.faceSize / 2.0 - (double)(3 * dashSize), i));
            }
            int fontSize = this.faceSize / 10;
            if (fontSize < 1) {
                fontSize = 1;
            }
            Font sizedFont = new Font("Serif", 0, fontSize);
            g.setFont(sizedFont);
            FontMetrics fontM = g.getFontMetrics(sizedFont);
            for (int i2 = 0; i2 < 12; ++i2) {
                String hour = Integer.toString(i2 + 1);
                int xOffset = fontM.stringWidth(hour);
                int yOffset = fontM.getHeight();
                g.drawString(Integer.toString(i2 + 1), this.dotX(this.faceSize / 2 - 6 * dashSize, i2 * 30 - 60) - xOffset / 2, this.dotY(this.faceSize / 2 - 6 * dashSize, i2 * 30 - 60) + yOffset / 4);
            }
            double minuteAngleRad = Math.toRadians(AnalogClockFrame.this.minuteAngle);
            for (int i3 = 0; i3 < this.scaledMinuteX.length; ++i3) {
                this.rotatedMinuteX[i3] = (int)((double)this.scaledMinuteX[i3] * Math.cos(minuteAngleRad) - (double)this.scaledMinuteY[i3] * Math.sin(minuteAngleRad));
                this.rotatedMinuteY[i3] = (int)((double)this.scaledMinuteX[i3] * Math.sin(minuteAngleRad) + (double)this.scaledMinuteY[i3] * Math.cos(minuteAngleRad));
            }
            this.scaledMinuteHand = new Polygon(this.rotatedMinuteX, this.rotatedMinuteY, this.rotatedMinuteX.length);
            double hourAngleRad = Math.toRadians(AnalogClockFrame.this.hourAngle);
            for (int i4 = 0; i4 < this.scaledHourX.length; ++i4) {
                this.rotatedHourX[i4] = (int)((double)this.scaledHourX[i4] * Math.cos(hourAngleRad) - (double)this.scaledHourY[i4] * Math.sin(hourAngleRad));
                this.rotatedHourY[i4] = (int)((double)this.scaledHourX[i4] * Math.sin(hourAngleRad) + (double)this.scaledHourY[i4] * Math.cos(hourAngleRad));
            }
            this.scaledHourHand = new Polygon(this.rotatedHourX, this.rotatedHourY, this.rotatedHourX.length);
            g.fillPolygon(this.scaledHourHand);
            g.fillPolygon(this.scaledMinuteHand);
            int amPmFontSize = (int)((double)fontSize * 0.75);
            if (amPmFontSize < 1) {
                amPmFontSize = 1;
            }
            Font amPmSizedFont = new Font("Serif", 0, amPmFontSize);
            g.setFont(amPmSizedFont);
            FontMetrics amPmFontM = g.getFontMetrics(amPmSizedFont);
            g.drawString(AnalogClockFrame.this.amPm, -amPmFontM.stringWidth(AnalogClockFrame.this.amPm) / 2, this.faceSize / 5);
        }

        int dotX(double radius, double angle) {
            int xDist = (int)Math.round(radius * Math.cos(Math.toRadians(angle)));
            return xDist;
        }

        int dotY(double radius, double angle) {
            int yDist = (int)Math.round(radius * Math.sin(Math.toRadians(angle)));
            return yDist;
        }

        public void scaleFace() {
            int panelHeight = this.getSize().height;
            int panelWidth = this.getSize().width;
            this.size = Math.min(panelHeight, panelWidth);
            this.faceSize = (int)((double)this.size * 0.97);
            if (this.faceSize == 0) {
                this.faceSize = 1;
            }
            int logoScaleWidth = this.faceSize / 6;
            int logoScaleHeight = (int)((float)logoScaleWidth * (float)this.jmriIcon.getIconHeight() / (float)this.jmriIcon.getIconWidth());
            this.scaledLogo = this.logo.getScaledInstance(Math.max(1, logoScaleWidth), Math.max(1, logoScaleHeight), 4);
            this.scaledIcon.setImage(this.scaledLogo);
            this.logoWidth = this.scaledIcon.getIconWidth();
            this.logoHeight = this.scaledIcon.getIconHeight();
            this.scaleRatio = (double)this.faceSize / 2.7 / (double)this.minuteHeight;
            for (int i = 0; i < this.minuteX.length; ++i) {
                this.scaledMinuteX[i] = (int)((double)this.minuteX[i] * this.scaleRatio);
                this.scaledMinuteY[i] = (int)((double)this.minuteY[i] * this.scaleRatio);
                this.scaledHourX[i] = (int)((double)this.hourX[i] * this.scaleRatio);
                this.scaledHourY[i] = (int)((double)this.hourY[i] * this.scaleRatio);
            }
            this.scaledHourHand = new Polygon(this.scaledHourX, this.scaledHourY, this.scaledHourX.length);
            this.scaledMinuteHand = new Polygon(this.scaledMinuteX, this.scaledMinuteY, this.scaledMinuteX.length);
            this.centreX = panelWidth / 2;
            this.centreY = panelHeight / 2;
        }
    }
}

