/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import java.io.InputStream;
import java.nio.ByteBuffer;
import jmri.implementation.AbstractAudio;
import jmri.jmrit.audio.AudioBuffer;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAudioBuffer
extends AbstractAudio
implements AudioBuffer {
    private String url = "";
    private long startLoopPoint;
    private long endLoopPoint;
    private boolean streamed = false;
    private boolean streamedForced = false;
    protected static final int LOOP_POINT_START = 1;
    protected static final int LOOP_POINT_END = 2;
    protected static final int LOOP_POINT_BOTH = 3;
    private static final Logger log = LoggerFactory.getLogger(AbstractAudioBuffer.class);

    public AbstractAudioBuffer(String systemName) {
        super(systemName);
        this.setState(32);
    }

    public AbstractAudioBuffer(String systemName, String userName) {
        super(systemName, userName);
        this.setState(32);
    }

    @Override
    public char getSubType() {
        return 'B';
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void setURL(String url) {
        this.url = FileUtil.getPortableFilename(url);
        this.loadBuffer();
        if (log.isDebugEnabled()) {
            log.debug("Set url of Buffer {} to {}", (Object)this.getSystemName(), (Object)url);
        }
    }

    @Override
    public void setInputStream(InputStream stream) {
        this.url = "stream";
        this.loadBuffer(stream);
        if (log.isDebugEnabled()) {
            log.debug("Set inputstream of Buffer {} to stream", (Object)this.getSystemName());
        }
    }

    @Override
    public int getFrameSize() {
        switch (this.getFormat()) {
            case 17: {
                return 1;
            }
            case 33: {
                return 2;
            }
            case 65: {
                return 4;
            }
            case 97: {
                return 6;
            }
            case 113: {
                return 7;
            }
            case 129: {
                return 8;
            }
            case 18: {
                return 2;
            }
            case 34: {
                return 4;
            }
            case 66: {
                return 8;
            }
            case 98: {
                return 12;
            }
            case 114: {
                return 14;
            }
            case 130: {
                return 16;
            }
        }
        return 0;
    }

    protected abstract boolean loadBuffer();

    protected abstract boolean loadBuffer(InputStream var1);

    @Override
    public void setStartLoopPoint(long startLoopPoint) {
        this.setStartLoopPoint(startLoopPoint, true);
    }

    @Override
    public boolean loadBuffer(ByteBuffer b, int format, int frequency) {
        return false;
    }

    protected void setStartLoopPoint(long startLoopPoint, boolean generateLoopBuffers) {
        this.startLoopPoint = startLoopPoint;
        if (generateLoopBuffers) {
            this.generateLoopBuffers(1);
        }
        if (log.isDebugEnabled()) {
            log.debug("Set start loop point of Buffer {} to {}", (Object)this.getSystemName(), (Object)startLoopPoint);
        }
    }

    @Override
    public long getStartLoopPoint() {
        return this.startLoopPoint;
    }

    @Override
    public void setEndLoopPoint(long endLoopPoint) {
        this.setEndLoopPoint(endLoopPoint, true);
    }

    protected void setEndLoopPoint(long endLoopPoint, boolean generateLoopBuffers) {
        this.endLoopPoint = endLoopPoint;
        if (generateLoopBuffers) {
            this.generateLoopBuffers(2);
        }
        if (log.isDebugEnabled()) {
            log.debug("Set end loop point of Buffer {} to {}", (Object)this.getSystemName(), (Object)endLoopPoint);
        }
    }

    @Override
    public long getEndLoopPoint() {
        return this.endLoopPoint;
    }

    @Override
    public void setStreamed(boolean streamed) {
        if (streamed) {
            log.warn("Streaming not yet supported!!");
            streamed = !streamed;
        }
        boolean changed = this.streamed != streamed;
        boolean bl = this.streamed = this.streamedForced ? true : streamed;
        if (log.isDebugEnabled()) {
            log.debug("Set streamed property of Buffer {} to {}; changed = {}", new Object[]{this.getSystemName(), streamed, changed});
        }
        if (streamed && changed) {
            this.generateStreamingBuffers();
        } else if (!streamed && changed) {
            this.removeStreamingBuffers();
        }
    }

    @Override
    public boolean isStreamed() {
        return this.streamed;
    }

    protected void setStreamedForced(boolean streamedForced) {
        boolean changed = !this.streamedForced && streamedForced;
        this.streamedForced = streamedForced;
        if (log.isDebugEnabled()) {
            log.debug("Set streamedForced property of Buffer {} to {}; changed = {}", new Object[]{this.getSystemName(), streamedForced, changed});
        }
        this.setStreamed(streamedForced ? true : this.streamed);
        if (changed) {
            this.generateLoopBuffers(3);
        }
    }

    @Override
    public boolean isStreamedForced() {
        return this.streamedForced;
    }

    protected abstract void generateLoopBuffers(int var1);

    protected abstract boolean generateStreamingBuffers();

    protected abstract void removeStreamingBuffers();

    @Override
    public void stateChanged(int oldState) {
    }
}

