/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import jmri.Audio;

public class AudioCommand {
    private final Audio audio;
    private final int command;

    public AudioCommand(Audio audio, int command) {
        this.audio = audio;
        this.command = command;
    }

    public synchronized Audio getAudio() {
        return this.audio;
    }

    public synchronized int getCommand() {
        return this.command;
    }

    public String toString() {
        if (this.audio != null) {
            return "Command " + this.commandString() + " for Audio " + this.audio.getSystemName();
        }
        return "Command " + this.commandString() + " for null object";
    }

    private String commandString() {
        switch (this.command) {
            case 1: {
                return "Initialise Factory (0x" + Integer.toHexString(this.command) + ")";
            }
            case 32: {
                return "Load Sound (0x" + Integer.toHexString(this.command) + ")";
            }
            case 48: {
                return "Bind buffer (0x" + Integer.toHexString(this.command) + ")";
            }
            case 49: {
                return "Queue buffers (0x" + Integer.toHexString(this.command) + ")";
            }
            case 50: {
                return "Unqueue buffers (0x" + Integer.toHexString(this.command) + ")";
            }
            case 64: {
                return "Play (0x" + Integer.toHexString(this.command) + ")";
            }
            case 67: {
                return "Pause (0x" + Integer.toHexString(this.command) + ")";
            }
            case 66: {
                return "Play/Stop toggle (0x" + Integer.toHexString(this.command) + ")";
            }
            case 69: {
                return "Pause/Resume toggle (0x" + Integer.toHexString(this.command) + ")";
            }
            case 68: {
                return "Resume (0x" + Integer.toHexString(this.command) + ")";
            }
            case 65: {
                return "Stop (0x" + Integer.toHexString(this.command) + ")";
            }
            case 70: {
                return "Rewind (0x" + Integer.toHexString(this.command) + ")";
            }
            case 71: {
                return "Fade-in (0x" + Integer.toHexString(this.command) + ")";
            }
            case 72: {
                return "Fade-out (0x" + Integer.toHexString(this.command) + ")";
            }
        }
        return "Unknown (0x" + Integer.toHexString(this.command) + ")";
    }
}

