/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.TreeSet;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AbstractAudioFactory;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.audio.JavaSoundAudioBuffer;
import jmri.jmrit.audio.JavaSoundAudioListener;
import jmri.jmrit.audio.JavaSoundAudioSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSoundAudioFactory
extends AbstractAudioFactory {
    private static boolean initialised = false;
    private static volatile Mixer mixer;
    private JavaSoundAudioListener activeAudioListener;
    private static final Logger log;

    @Override
    public boolean init() {
        if (initialised) {
            return true;
        }
        if (mixer == null) {
            for (Mixer.Info mixerInfo : AudioSystem.getMixerInfo()) {
                if (!mixerInfo.getName().equals("Java Sound Audio Engine")) continue;
                JavaSoundAudioFactory.setMixer(AudioSystem.getMixer(mixerInfo));
                break;
            }
        }
        if (mixer == null) {
            log.debug("No JavaSound audio system found.");
            return false;
        }
        if (log.isInfoEnabled()) {
            log.info("Initialised JavaSound: vendor - {} version - {}", (Object)mixer.getMixerInfo().getVendor(), (Object)mixer.getMixerInfo().getVersion());
        }
        super.init();
        JavaSoundAudioFactory.setInit(true);
        return true;
    }

    private static synchronized void setInit(boolean newVal) {
        initialised = newVal;
    }

    private static synchronized void setMixer(Mixer newMixer) {
        mixer = newMixer;
    }

    public String toString() {
        return "JavaSoundAudioFactory: vendor - " + mixer.getMixerInfo().getVendor() + " version - " + mixer.getMixerInfo().getVersion();
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="OK to write to static variable mixer as we are cleaning up")
    public void cleanup() {
        super.cleanup();
        AudioManager am = InstanceManager.getDefault(AudioManager.class);
        TreeSet<Audio> sources = new TreeSet<Audio>(am.getNamedBeanSet('S'));
        for (Audio audio : sources) {
            if (log.isDebugEnabled()) {
                log.debug("Removing JavaSoundAudioSource: {}", (Object)audio.getSystemName());
            }
            audio.dispose();
        }
        TreeSet<Audio> buffers = new TreeSet<Audio>(am.getNamedBeanSet('B'));
        for (Audio buffer : buffers) {
            if (log.isDebugEnabled()) {
                log.debug("Removing JavaSoundAudioBuffer: {}", (Object)buffer.getSystemName());
            }
            buffer.dispose();
        }
        TreeSet<Audio> treeSet = new TreeSet<Audio>(am.getNamedBeanSet('L'));
        for (Audio listener : treeSet) {
            if (log.isDebugEnabled()) {
                log.debug("Removing JavaSoundAudioListener: {}", (Object)listener.getSystemName());
            }
            listener.dispose();
        }
        log.debug("Shutting down JavaSound");
        mixer = null;
        initialised = false;
    }

    @Override
    public boolean isInitialised() {
        return initialised;
    }

    @Override
    public AudioBuffer createNewBuffer(String systemName, String userName) {
        return new JavaSoundAudioBuffer(systemName, userName);
    }

    @Override
    public AudioListener createNewListener(String systemName, String userName) {
        this.activeAudioListener = new JavaSoundAudioListener(systemName, userName);
        return this.activeAudioListener;
    }

    @Override
    public AudioListener getActiveAudioListener() {
        return this.activeAudioListener;
    }

    @Override
    public AudioSource createNewSource(String systemName, String userName) {
        return new JavaSoundAudioSource(systemName, userName);
    }

    public static synchronized Mixer getMixer() {
        return mixer;
    }

    static {
        log = LoggerFactory.getLogger(JavaSoundAudioFactory.class);
    }
}

