/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import javax.vecmath.Vector3f;
import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AbstractAudioListener;
import jmri.jmrit.audio.JavaSoundAudioSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSoundAudioListener
extends AbstractAudioListener {
    private static final Logger log = LoggerFactory.getLogger(JavaSoundAudioListener.class);

    public JavaSoundAudioListener(String systemName) {
        super(systemName);
        if (log.isDebugEnabled()) {
            log.debug("New JavaSoundAudioListener: {}", (Object)systemName);
        }
    }

    public JavaSoundAudioListener(String systemName, String userName) {
        super(systemName, userName);
        if (log.isDebugEnabled()) {
            log.debug("New JavaSoundAudioListener: {} ({})", (Object)userName, (Object)systemName);
        }
    }

    @Override
    protected void changePosition(Vector3f pos) {
        this.recalculateSources();
    }

    @Override
    public void setGain(float gain) {
        super.setGain(gain);
        this.recalculateSources();
    }

    private void recalculateSources() {
        AudioManager am = InstanceManager.getDefault(AudioManager.class);
        for (Audio audio : am.getNamedBeanSet()) {
            if (audio.getSubType() != 'S' || !(audio instanceof JavaSoundAudioSource)) continue;
            ((JavaSoundAudioSource)audio).calculateGain();
            ((JavaSoundAudioSource)audio).calculatePan();
            if (!log.isDebugEnabled()) continue;
            log.debug("Recalculating gain & pan for JavaSoundAudioSource {}", (Object)audio.getSystemName());
        }
    }

    @Override
    protected void cleanup() {
        if (log.isDebugEnabled()) {
            log.debug("Cleanup JavaSoundAudioListener ({})", (Object)this.getSystemName());
        }
    }
}

