/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AbstractAudioSource;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.audio.AudioFactory;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.JavaSoundAudioBuffer;
import jmri.jmrit.audio.JavaSoundAudioFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSoundAudioSource
extends AbstractAudioSource {
    private static Mixer mixer = JavaSoundAudioFactory.getMixer();
    private AudioListener activeAudioListener = this.loadAudioListener();
    private boolean initialised = false;
    private transient Clip clip = null;
    private transient JavaSoundAudioChannel audioChannel = null;
    private boolean jsState;
    private static final Logger log = LoggerFactory.getLogger(JavaSoundAudioSource.class);

    private AudioListener loadAudioListener() {
        AudioFactory audioFact = InstanceManager.getDefault(AudioManager.class).getActiveAudioFactory();
        if (audioFact != null) {
            return audioFact.getActiveAudioListener();
        }
        log.error("no AudioListener found");
        return null;
    }

    public JavaSoundAudioSource(String systemName) {
        super(systemName);
        log.debug("New JavaSoundAudioSource: {}", (Object)systemName);
        this.initialised = this.init();
    }

    public JavaSoundAudioSource(String systemName, String userName) {
        super(systemName, userName);
        log.debug("New JavaSoundAudioSource: {} ({})", (Object)userName, (Object)systemName);
        this.initialised = this.init();
    }

    private boolean init() {
        return true;
    }

    @Override
    boolean bindAudioBuffer(AudioBuffer audioBuffer) {
        if (!this.initialised) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        while (audioBuffer.getState() != 33 && System.currentTimeMillis() - startTime < 20000L) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                log.debug("bindAudioBuffer was interruped");
            }
        }
        if (audioBuffer instanceof JavaSoundAudioBuffer && audioBuffer.getState() == 33) {
            Clip newClip;
            JavaSoundAudioBuffer buffer = (JavaSoundAudioBuffer)audioBuffer;
            DataLine.Info lineInfo = new DataLine.Info(Clip.class, buffer.getAudioFormat());
            try {
                newClip = (Clip)mixer.getLine(lineInfo);
            }
            catch (LineUnavailableException ex) {
                log.warn("Error binding JavaSoundSource ({}) to AudioBuffer ({}) ", new Object[]{this.getSystemName(), this.getAssignedBufferName(), ex});
                return false;
            }
            this.clip = newClip;
            try {
                this.clip.open(buffer.getAudioFormat(), buffer.getDataStorageBuffer(), 0, buffer.getDataStorageBuffer().length);
            }
            catch (LineUnavailableException ex) {
                log.warn("Error binding JavaSoundSource ({}) to AudioBuffer ({}) ", new Object[]{this.getSystemName(), this.getAssignedBufferName(), ex});
            }
            if (log.isDebugEnabled()) {
                log.debug("Bind JavaSoundAudioSource ({}) to JavaSoundAudioBuffer ({})", (Object)this.getSystemName(), (Object)audioBuffer.getSystemName());
            }
            return true;
        }
        log.warn("AudioBuffer not loaded error when binding JavaSoundSource ({}) to AudioBuffer ({})", (Object)this.getSystemName(), (Object)this.getAssignedBufferName());
        return false;
    }

    @Override
    protected void changePosition(Vector3f pos) {
        if (this.initialised && this.isBound() && this.audioChannel != null) {
            this.calculateGain();
            this.calculatePan();
        }
    }

    @Override
    public void setGain(float gain) {
        super.setGain(gain);
        if (this.initialised && this.isBound() && this.audioChannel != null) {
            this.calculateGain();
        }
    }

    @Override
    public void setPitch(float pitch) {
        super.setPitch(pitch);
        if (this.initialised && this.isBound() && this.audioChannel != null) {
            this.calculatePitch();
        }
    }

    @Override
    public void setReferenceDistance(float referenceDistance) {
        super.setReferenceDistance(referenceDistance);
        if (this.initialised && this.isBound() && this.audioChannel != null) {
            this.calculateGain();
        }
    }

    @Override
    public void setOffset(long offset) {
        super.setOffset(offset);
        if (this.initialised && this.isBound() && this.audioChannel != null) {
            this.clip.setFramePosition((int)offset);
        }
    }

    @Override
    public int getState() {
        boolean old = this.jsState;
        boolean bl = this.jsState = this.clip != null && this.clip.isActive();
        if (this.jsState != old) {
            if (this.jsState) {
                this.setState(17);
            } else {
                this.setState(16);
            }
        }
        return super.getState();
    }

    @Override
    public void stateChanged(int oldState) {
        super.stateChanged(oldState);
        if (this.initialised && this.isBound() && this.audioChannel != null) {
            this.calculateGain();
            this.calculatePan();
            this.calculatePitch();
        } else {
            this.initialised = this.init();
        }
    }

    @Override
    protected void doPlay() {
        log.debug("Play JavaSoundAudioSource ({})", (Object)this.getSystemName());
        if (this.initialised && this.isBound()) {
            this.doRewind();
            this.doResume();
        }
    }

    @Override
    protected void doStop() {
        log.debug("Stop JavaSoundAudioSource ({})", (Object)this.getSystemName());
        if (this.initialised && this.isBound()) {
            this.doPause();
            this.doRewind();
        }
    }

    @Override
    protected void doPause() {
        if (log.isDebugEnabled()) {
            log.debug("Pause JavaSoundAudioSource ({})", (Object)this.getSystemName());
        }
        if (this.initialised && this.isBound()) {
            this.clip.stop();
            if (this.audioChannel != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Remove JavaSoundAudioChannel for Source {}", (Object)this.getSystemName());
                }
                this.audioChannel = null;
            }
        }
        this.setState(16);
    }

    @Override
    protected void doResume() {
        if (log.isDebugEnabled()) {
            log.debug("Resume JavaSoundAudioSource ({})", (Object)this.getSystemName());
        }
        if (this.initialised && this.isBound()) {
            if (this.audioChannel == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Create JavaSoundAudioChannel for Source {}", (Object)this.getSystemName());
                }
                this.audioChannel = new JavaSoundAudioChannel(this);
            }
            this.clip.loop(this.getNumLoops());
            this.setState(17);
        }
    }

    @Override
    protected void doRewind() {
        if (log.isDebugEnabled()) {
            log.debug("Rewind JavaSoundAudioSource ({})", (Object)this.getSystemName());
        }
        if (this.initialised && this.isBound()) {
            this.clip.setFramePosition(0);
        }
    }

    @Override
    protected void doFadeIn() {
        if (log.isDebugEnabled()) {
            log.debug("Fade-in JavaSoundAudioSource ({})", (Object)this.getSystemName());
        }
        if (this.initialised && this.isBound()) {
            this.doPlay();
            AbstractAudioSource.AudioSourceFadeThread asft = new AbstractAudioSource.AudioSourceFadeThread(this);
            asft.start();
        }
    }

    @Override
    protected void doFadeOut() {
        if (log.isDebugEnabled()) {
            log.debug("Fade-out JavaSoundAudioSource ({})", (Object)this.getSystemName());
        }
        if (this.initialised && this.isBound()) {
            AbstractAudioSource.AudioSourceFadeThread asft = new AbstractAudioSource.AudioSourceFadeThread(this);
            asft.start();
        }
    }

    @Override
    protected void cleanup() {
        if (this.initialised && this.isBound()) {
            this.clip.stop();
            this.clip.close();
            this.clip = null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Cleanup JavaSoundAudioSource ({})", (Object)this.getSystemName());
        }
    }

    protected void calculatePan() {
        Vector3f side = new Vector3f();
        side.cross(this.activeAudioListener.getOrientation(2), this.activeAudioListener.getOrientation(1));
        side.normalize();
        Vector3f vecX = new Vector3f(this.getCurrentPosition());
        Vector3f vecZ = new Vector3f(this.getCurrentPosition());
        float x = vecX.dot(side);
        float z = vecZ.dot(this.activeAudioListener.getOrientation(1));
        float angle = (float)Math.atan2(x, z);
        float pan = (float)(-Math.sin(angle));
        if (this.audioChannel != null) {
            this.audioChannel.setPan(pan);
        }
        if (log.isDebugEnabled()) {
            log.debug("Set pan of JavaSoundAudioSource {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(pan));
        }
    }

    @Override
    protected void calculateGain() {
        Vector3f distance = new Vector3f(this.getCurrentPosition());
        if (!this.isPositionRelative()) {
            distance.sub((Tuple3f)this.activeAudioListener.getCurrentPosition());
        }
        float distanceFromListener = (float)Math.sqrt(distance.dot(distance));
        if (log.isDebugEnabled()) {
            log.debug("Distance of JavaSoundAudioSource {} from Listener = {}", (Object)this.getSystemName(), (Object)Float.valueOf(distanceFromListener));
        }
        float currentGain = 1.0f;
        AudioFactory audioFact = InstanceManager.getDefault(AudioManager.class).getActiveAudioFactory();
        if (audioFact != null && audioFact.isDistanceAttenuated()) {
            distanceFromListener = Math.max(distanceFromListener, this.getReferenceDistance());
            if (log.isDebugEnabled()) {
                log.debug("After initial clamping, distance of JavaSoundAudioSource {} from Listener = {}", (Object)this.getSystemName(), (Object)Float.valueOf(distanceFromListener));
            }
            distanceFromListener = Math.min(distanceFromListener, this.getMaximumDistance());
            if (log.isDebugEnabled()) {
                log.debug("After final clamping, distance of JavaSoundAudioSource {} from Listener = {}", (Object)this.getSystemName(), (Object)Float.valueOf(distanceFromListener));
            }
            currentGain = this.activeAudioListener.getMetersPerUnit() * (this.getReferenceDistance() / (this.getReferenceDistance() + this.getRollOffFactor() * (distanceFromListener - this.getReferenceDistance())));
            if (log.isDebugEnabled()) {
                log.debug("Calculated for JavaSoundAudioSource {} gain = {}", (Object)this.getSystemName(), (Object)Float.valueOf(currentGain));
            }
            if (currentGain > 1.0f) {
                currentGain = 1.0f;
            } else if (currentGain < 0.0f) {
                currentGain = 0.0f;
            }
        }
        currentGain *= this.getGain() * this.activeAudioListener.getGain() * this.getFadeGain();
        if (this.audioChannel != null) {
            this.audioChannel.setGain(currentGain);
            if (log.isDebugEnabled()) {
                log.debug("Set current gain of JavaSoundAudioSource {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(currentGain));
            }
        }
    }

    protected void calculatePitch() {
        if (this.audioChannel != null) {
            this.audioChannel.setPitch(this.getPitch());
        }
    }

    private static class JavaSoundAudioChannel {
        private FloatControl gainControl = null;
        private FloatControl panControl = null;
        private FloatControl sampleRateControl = null;
        private float initialSampleRate = 0.0f;
        private float initialGain = 0.0f;
        private final JavaSoundAudioSource audio;
        private final Clip clip;

        public JavaSoundAudioChannel(JavaSoundAudioSource audio) {
            this.audio = audio;
            this.clip = this.audio.clip;
            if (this.clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                this.gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                this.initialGain = this.gainControl.getValue();
                if (log.isDebugEnabled()) {
                    log.debug("JavaSound gain control created");
                    log.debug("Initial Gain = {}", (Object)Float.valueOf(this.initialGain));
                }
            } else {
                log.info("Gain control is not supported");
                this.gainControl = null;
            }
            if (this.clip.isControlSupported(FloatControl.Type.PAN)) {
                this.panControl = (FloatControl)this.clip.getControl(FloatControl.Type.PAN);
                log.debug("JavaSound pan control created");
            } else {
                log.info("Pan control is not supported");
                this.panControl = null;
            }
            if (this.clip.isControlSupported(FloatControl.Type.SAMPLE_RATE)) {
                this.sampleRateControl = (FloatControl)this.clip.getControl(FloatControl.Type.SAMPLE_RATE);
                this.initialSampleRate = this.sampleRateControl.getValue();
                if (log.isDebugEnabled()) {
                    log.debug("JavaSound pitch control created");
                    log.debug("Initial Sample Rate = {}", (Object)Float.valueOf(this.initialSampleRate));
                }
            } else {
                log.info("Sample Rate control is not supported");
                this.sampleRateControl = null;
                this.initialSampleRate = 0.0f;
            }
        }

        protected void setGain(float gain) {
            if (this.gainControl != null) {
                if (gain <= 0.0f) {
                    gain = 1.0E-4f;
                } else if (gain > 1.0f) {
                    gain = 1.0f;
                }
                float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
                this.gainControl.setValue(dB);
                if (log.isDebugEnabled()) {
                    log.debug("Actual gain value of JavaSoundAudioSource {} is {}", (Object)this.audio.getDebugString(), (Object)Float.valueOf(this.gainControl.getValue()));
                }
            }
            log.debug("Set gain of JavaSoundAudioSource {} to {}", (Object)this.audio.getDebugString(), (Object)Float.valueOf(gain));
        }

        protected void setPan(float pan) {
            if (this.panControl != null) {
                this.panControl.setValue(pan);
            }
            log.debug("Set pan of JavaSoundAudioSource {} to {}", (Object)this.audio.getDebugString(), (Object)Float.valueOf(pan));
        }

        protected void setPitch(float pitch) {
            if (this.sampleRateControl != null) {
                this.sampleRateControl.setValue(pitch * this.initialSampleRate);
            }
            log.debug("Set pitch of JavaSoundAudioSource {} to {}", (Object)this.audio.getDebugString(), (Object)Float.valueOf(pitch));
        }
    }
}

