/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALException;
import com.jogamp.openal.util.ALut;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jmri.jmrit.audio.AbstractAudioBuffer;
import jmri.jmrit.audio.JoalAudioFactory;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoalAudioBuffer
extends AbstractAudioBuffer {
    private static AL al = JoalAudioFactory.getAL();
    private int[] format = new int[1];
    private int[] dataStorageBuffer = new int[1];
    private ByteBuffer[] data = new ByteBuffer[1];
    private int[] size = new int[1];
    private int[] freq = new int[1];
    private int[] loop = new int[1];
    private boolean initialised = false;
    private static final Logger log = LoggerFactory.getLogger(JoalAudioBuffer.class);

    public JoalAudioBuffer(String systemName) {
        super(systemName);
        log.debug("New JoalAudioBuffer: {}", (Object)systemName);
        this.initialised = this.init();
    }

    public JoalAudioBuffer(String systemName, String userName) {
        super(systemName, userName);
        log.debug("New JoalAudioBuffer: {} ({})", (Object)userName, (Object)systemName);
        this.initialised = this.init();
    }

    private boolean init() {
        if (al == null) {
            log.warn("Al Factory not yet initialised");
            return false;
        }
        al.alGenBuffers(1, this.dataStorageBuffer, 0);
        if (JoalAudioFactory.checkALError()) {
            log.warn("Error creating JoalAudioBuffer ({})", (Object)this.getSystemName());
            return false;
        }
        this.setState(32);
        return true;
    }

    protected int[] getDataStorageBuffer() {
        return this.dataStorageBuffer;
    }

    private String parseFormat() {
        switch (this.format[0]) {
            case 4352: {
                return "8-bit mono";
            }
            case 4353: {
                return "16-bit mono";
            }
            case 4354: {
                return "8-bit stereo";
            }
            case 4355: {
                return "16-bit stereo";
            }
        }
        log.error("Unhandled audio format type: {}", (Object)this.format[0]);
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_QUAD8 && JoalAudioFactory.AL_FORMAT_QUAD8 != 0) {
            return "8-bit quadrophonic";
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_QUAD16 && JoalAudioFactory.AL_FORMAT_QUAD16 != 0) {
            return "16-bit quadrophonic";
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_51CHN8 && JoalAudioFactory.AL_FORMAT_51CHN8 != 0) {
            return "8-bit 5.1 surround";
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_51CHN16 && JoalAudioFactory.AL_FORMAT_51CHN16 != 0) {
            return "16-bit 5.1 surround";
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_61CHN8 && JoalAudioFactory.AL_FORMAT_61CHN8 != 0) {
            return "8-bit 6.1 surround";
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_61CHN16 && JoalAudioFactory.AL_FORMAT_61CHN16 != 0) {
            return "16-bit 6.1 surround";
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_71CHN8 && JoalAudioFactory.AL_FORMAT_71CHN8 != 0) {
            return "8 bit 7.1 surround";
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_71CHN16 && JoalAudioFactory.AL_FORMAT_71CHN16 != 0) {
            return "16 bit 7.1 surround";
        }
        return "unknown format";
    }

    @Override
    protected boolean loadBuffer(InputStream stream) {
        if (!this.initialised) {
            return false;
        }
        this.setStartLoopPoint(0L, false);
        this.setEndLoopPoint(0L, false);
        this.setState(32);
        try {
            ALut.alutLoadWAVFile((InputStream)stream, (int[])this.format, (ByteBuffer[])this.data, (int[])this.size, (int[])this.freq, (int[])this.loop);
        }
        catch (ALException e) {
            log.warn("Exception loading JoalAudioBuffer from stream: {}", (Object)e.toString());
            return false;
        }
        return this.processBuffer();
    }

    @Override
    protected boolean loadBuffer() {
        if (!this.initialised) {
            return false;
        }
        this.setStartLoopPoint(0L, false);
        this.setEndLoopPoint(0L, false);
        this.setState(32);
        try {
            ALut.alutLoadWAVFile((String)FileUtil.getExternalFilename(this.getURL()), (int[])this.format, (ByteBuffer[])this.data, (int[])this.size, (int[])this.freq, (int[])this.loop);
        }
        catch (ALException e) {
            log.warn("Exception loading JoalAudioBuffer from file: {}", (Object)e.toString());
            return false;
        }
        return this.processBuffer();
    }

    @Override
    public boolean loadBuffer(ByteBuffer b, int format, int freq) {
        if (!this.initialised) {
            return false;
        }
        this.setStartLoopPoint(0L, false);
        this.setEndLoopPoint(0L, false);
        this.setState(32);
        this.data[0] = b;
        this.format[0] = format;
        this.freq[0] = freq;
        this.size[0] = b.limit();
        return this.processBuffer();
    }

    private boolean processBuffer() {
        al.alBufferData(this.dataStorageBuffer[0], this.format[0], (Buffer)this.data[0], this.size[0], this.freq[0]);
        this.setStartLoopPoint(0L, false);
        this.setEndLoopPoint(this.size[0], false);
        this.generateLoopBuffers(3);
        this.setState(33);
        if (log.isDebugEnabled()) {
            log.debug("Loaded buffer: {}", (Object)this.getSystemName());
            log.debug(" from file: {}", (Object)this.getURL());
            log.debug(" format: {}, {} Hz", (Object)this.parseFormat(), (Object)this.freq[0]);
            log.debug(" length: {}", (Object)this.size[0]);
        }
        return true;
    }

    @Override
    protected boolean generateStreamingBuffers() {
        if (log.isDebugEnabled()) {
            log.debug("Method generateStreamingBuffers() called for JoalAudioBuffer {}", (Object)this.getSystemName());
        }
        return true;
    }

    @Override
    protected void removeStreamingBuffers() {
        if (log.isDebugEnabled()) {
            log.debug("Method removeStreamingBuffers() called for JoalAudioBuffer {}", (Object)this.getSystemName());
        }
    }

    @Override
    protected void generateLoopBuffers(int which) {
        if (log.isDebugEnabled()) {
            log.debug("Method generateLoopBuffers() called for JoalAudioBuffer {}", (Object)this.getSystemName());
        }
    }

    @Override
    public int getFormat() {
        switch (this.format[0]) {
            case 4352: {
                return 17;
            }
            case 4353: {
                return 18;
            }
            case 4354: {
                return 33;
            }
            case 4355: {
                return 34;
            }
        }
        log.error("Unhandled audio format type {}", (Object)this.format[0]);
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_QUAD8 && JoalAudioFactory.AL_FORMAT_QUAD8 != 0) {
            return 65;
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_QUAD16 && JoalAudioFactory.AL_FORMAT_QUAD16 != 0) {
            return 66;
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_51CHN8 && JoalAudioFactory.AL_FORMAT_51CHN8 != 0) {
            return 97;
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_51CHN16 && JoalAudioFactory.AL_FORMAT_51CHN16 != 0) {
            return 98;
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_61CHN8 && JoalAudioFactory.AL_FORMAT_61CHN8 != 0) {
            return 113;
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_61CHN16 && JoalAudioFactory.AL_FORMAT_61CHN16 != 0) {
            return 114;
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_71CHN8 && JoalAudioFactory.AL_FORMAT_71CHN8 != 0) {
            return 129;
        }
        if (this.format[0] == JoalAudioFactory.AL_FORMAT_71CHN16 && JoalAudioFactory.AL_FORMAT_71CHN16 != 0) {
            return 130;
        }
        return 0;
    }

    @Override
    public long getLength() {
        if (this.getFrameSize() == 0) {
            return 0L;
        }
        return (long)this.size[0] / (long)this.getFrameSize();
    }

    @Override
    public int getFrequency() {
        return this.freq[0];
    }

    @Override
    protected void cleanup() {
        if (this.initialised) {
            al.alDeleteBuffers(1, this.dataStorageBuffer, 0);
        }
        if (log.isDebugEnabled()) {
            log.debug("Cleanup JoalAudioBuffer ({})", (Object)this.getSystemName());
        }
    }
}

