/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALExt;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.util.ALut;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.TreeSet;
import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AbstractAudioFactory;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.audio.JoalAudioBuffer;
import jmri.jmrit.audio.JoalAudioListener;
import jmri.jmrit.audio.JoalAudioSource;
import jmri.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoalAudioFactory
extends AbstractAudioFactory {
    private static AL al;
    private static ALC alc;
    private static ALExt alext;
    private static ALCdevice alcDevice;
    static int[] uiEffectSlots;
    static int[] uiEffect;
    private static boolean initialised;
    private JoalAudioListener activeAudioListener;
    static int AL_FORMAT_QUAD8;
    static int AL_FORMAT_QUAD16;
    static int AL_FORMAT_51CHN8;
    static int AL_FORMAT_51CHN16;
    static int AL_FORMAT_61CHN8;
    static int AL_FORMAT_61CHN16;
    static int AL_FORMAT_71CHN8;
    static int AL_FORMAT_71CHN16;
    private static final Logger log;

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="OK to write to static variables as we only do so if not initialised")
    public boolean init() {
        if (initialised) {
            return true;
        }
        try {
            ALut.alutInit();
            al = ALFactory.getAL();
            al.alGetError();
            log.info("Initialised JOAL using OpenAL: vendor - {} version - {}", (Object)al.alGetString(45057), (Object)al.alGetString(45058));
        }
        catch (ALException e) {
            log.warn("Error initialising JOAL", (Throwable)LoggingUtil.shortenStacktrace(e));
            return false;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            log.warn("Error loading OpenAL libraries: {}", (Object)e.getMessage());
            return false;
        }
        catch (RuntimeException e) {
            log.warn("Error initialising OpenAL", (Throwable)LoggingUtil.shortenStacktrace(e));
            return false;
        }
        int checkMultiChannel = al.alGetEnumValue("AL_FORMAT_QUAD8");
        JoalAudioFactory.checkALError();
        if (checkMultiChannel != 0) {
            AL_FORMAT_QUAD8 = checkMultiChannel;
        }
        checkMultiChannel = al.alGetEnumValue("AL_FORMAT_QUAD16");
        JoalAudioFactory.checkALError();
        if (checkMultiChannel != 0) {
            AL_FORMAT_QUAD16 = checkMultiChannel;
        }
        checkMultiChannel = al.alGetEnumValue("AL_FORMAT_51CHN8");
        JoalAudioFactory.checkALError();
        if (checkMultiChannel != 0) {
            AL_FORMAT_51CHN8 = checkMultiChannel;
        }
        checkMultiChannel = al.alGetEnumValue("AL_FORMAT_51CHN16");
        JoalAudioFactory.checkALError();
        if (checkMultiChannel != 0) {
            AL_FORMAT_51CHN16 = checkMultiChannel;
        }
        checkMultiChannel = al.alGetEnumValue("AL_FORMAT_61CHN8");
        JoalAudioFactory.checkALError();
        if (checkMultiChannel != 0) {
            AL_FORMAT_61CHN8 = checkMultiChannel;
        }
        checkMultiChannel = al.alGetEnumValue("AL_FORMAT_61CHN16");
        JoalAudioFactory.checkALError();
        if (checkMultiChannel != 0) {
            AL_FORMAT_61CHN16 = checkMultiChannel;
        }
        checkMultiChannel = al.alGetEnumValue("AL_FORMAT_71CHN8");
        JoalAudioFactory.checkALError();
        if (checkMultiChannel != 0) {
            AL_FORMAT_71CHN8 = checkMultiChannel;
        }
        checkMultiChannel = al.alGetEnumValue("AL_FORMAT_71CHN16");
        JoalAudioFactory.checkALError();
        if (checkMultiChannel != 0) {
            AL_FORMAT_71CHN16 = checkMultiChannel;
        }
        log.debug("8-bit quadrophonic supported? {}", (Object)(AL_FORMAT_QUAD8 == 0 ? "No" : "Yes"));
        log.debug("16-bit quadrophonic supported? {}", (Object)(AL_FORMAT_QUAD16 == 0 ? "No" : "Yes"));
        log.debug("8-bit 5.1 surround supported? {}", (Object)(AL_FORMAT_51CHN8 == 0 ? "No" : "Yes"));
        log.debug("16-bit 5.1 surround supported? {}", (Object)(AL_FORMAT_51CHN16 == 0 ? "No" : "Yes"));
        log.debug("8-bit 6.1 surround supported? {}", (Object)(AL_FORMAT_61CHN8 == 0 ? "No" : "Yes"));
        log.debug("16-bit 6.1 surround supported? {}", (Object)(AL_FORMAT_61CHN16 == 0 ? "No" : "Yes"));
        log.debug("8 bit 7.1 surround supported? {}", (Object)(AL_FORMAT_71CHN8 == 0 ? "No" : "Yes"));
        log.debug("16 bit 7.1 surround supported? {}", (Object)(AL_FORMAT_71CHN16 == 0 ? "No" : "Yes"));
        alc = ALFactory.getALC();
        alext = ALFactory.getALExt();
        alcDevice = alc.alcGetContextsDevice(alc.alcGetCurrentContext());
        if (!JoalAudioFactory.checkALCError(alcDevice)) {
            int[] size = new int[1];
            alc.alcGetIntegerv(alcDevice, 4098, size.length, size, 0);
            log.debug("Size of ALC_ATTRIBUTES: {}", (Object)size[0]);
            if (!JoalAudioFactory.checkALCError(alcDevice) && size[0] > 0) {
                int[] attributes = new int[size[0]];
                alc.alcGetIntegerv(alcDevice, 4099, attributes.length, attributes, 0);
                block11: for (int i = 0; i < attributes.length; ++i) {
                    if (i % 2 != 0) continue;
                    switch (attributes[i]) {
                        case 0: {
                            log.debug("Invalid");
                            continue block11;
                        }
                        case 4112: {
                            log.debug("Number of mono sources: {}", (Object)attributes[i + 1]);
                            continue block11;
                        }
                        case 4113: {
                            log.debug("Number of stereo sources: {}", (Object)attributes[i + 1]);
                            continue block11;
                        }
                        case 4103: {
                            log.debug("Frequency: {}", (Object)attributes[i + 1]);
                            continue block11;
                        }
                        case 4104: {
                            log.debug("Refresh: {}", (Object)attributes[i + 1]);
                            continue block11;
                        }
                        default: {
                            log.debug("Attribute {}: {}", (Object)i, (Object)attributes[i]);
                        }
                    }
                }
                if (alc.alcIsExtensionPresent(alcDevice, "ALC_EXT_EFX")) {
                    JoalAudioFactory.loadEffect();
                } else {
                    log.warn("Extension EFX not present");
                }
            }
        }
        super.init();
        initialised = true;
        return true;
    }

    static int loadEffect() {
        al.alGetError();
        alext.alGenAuxiliaryEffectSlots(1, uiEffectSlots, 0);
        if (al.alGetError() != 0) {
            return 0;
        }
        log.debug("Generated 1 effect slot {}", (Object)uiEffectSlots[0]);
        alext.alGenEffects(1, uiEffect, 0);
        if (al.alGetError() != 0) {
            return 0;
        }
        log.debug("Generated 1 effect");
        if (alext.alIsEffect(uiEffect[0])) {
            alext.alEffecti(uiEffect[0], 32769, 1);
            if (al.alGetError() != 0) {
                log.warn("ReverbEffect not supported");
                return 0;
            }
        }
        alext.alAuxiliaryEffectSloti(uiEffectSlots[0], 1, uiEffect[0]);
        if (al.alGetError() != 0) {
            log.warn("Could not load effect into effect slot");
            return 0;
        }
        log.debug("Successfully loaded effect into effect slot");
        return 1;
    }

    public String toString() {
        if (al == null) {
            return "JoalAudioFactory, using null";
        }
        try {
            return "JoalAudioFactory, using OpenAL: vendor - " + al.alGetString(45057) + " version - " + al.alGetString(45058);
        }
        catch (NullPointerException e) {
            log.error("NPE from JoalAudioFactory", (Throwable)e);
            return "JoalAudioFactory, using Null";
        }
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="OK to write to static variables to record static library status")
    public void cleanup() {
        super.cleanup();
        AudioManager am = InstanceManager.getDefault(AudioManager.class);
        TreeSet<Audio> sources = new TreeSet<Audio>(am.getNamedBeanSet('S'));
        for (Audio audio : sources) {
            if (log.isDebugEnabled()) {
                log.debug("Removing JoalAudioSource: {}", (Object)audio.getSystemName());
            }
            audio.dispose();
        }
        TreeSet<Audio> buffers = new TreeSet<Audio>(am.getNamedBeanSet('B'));
        for (Audio buffer : buffers) {
            if (log.isDebugEnabled()) {
                log.debug("Removing JoalAudioBuffer: {}", (Object)buffer.getSystemName());
            }
            buffer.dispose();
        }
        TreeSet<Audio> treeSet = new TreeSet<Audio>(am.getNamedBeanSet('L'));
        for (Audio listener : treeSet) {
            if (log.isDebugEnabled()) {
                log.debug("Removing JoalAudioListener: {}", (Object)listener.getSystemName());
            }
            listener.dispose();
        }
        alext.alDeleteAuxiliaryEffectSlots(1, uiEffectSlots, 0);
        alext.alDeleteEffects(1, uiEffect, 0);
        log.debug("Shutting down OpenAL, initialised: {}", (Object)initialised);
        if (initialised) {
            ALut.alutExit();
        }
        initialised = false;
    }

    @Override
    public boolean isInitialised() {
        return initialised;
    }

    @Override
    public AudioBuffer createNewBuffer(String systemName, String userName) {
        return new JoalAudioBuffer(systemName, userName);
    }

    @Override
    public AudioListener createNewListener(String systemName, String userName) {
        this.activeAudioListener = new JoalAudioListener(systemName, userName);
        return this.activeAudioListener;
    }

    @Override
    public AudioListener getActiveAudioListener() {
        return this.activeAudioListener;
    }

    @Override
    public AudioSource createNewSource(String systemName, String userName) {
        return new JoalAudioSource(systemName, userName);
    }

    @Override
    public void setDistanceAttenuated(boolean attenuated) {
        super.setDistanceAttenuated(attenuated);
        if (this.isDistanceAttenuated()) {
            al.alDistanceModel(53250);
        } else {
            al.alDistanceModel(0);
        }
    }

    public static synchronized AL getAL() {
        return al;
    }

    public static boolean checkALError() {
        return JoalAudioFactory.checkALError("");
    }

    public static boolean checkALError(String msg) {
        if (((String)(msg = ((String)msg).trim())).length() > 0) {
            msg = (String)msg + " ";
        }
        switch (al.alGetError()) {
            case 0: {
                return false;
            }
            case 40961: {
                log.warn("{}Invalid name parameter", msg);
                return true;
            }
            case 40962: {
                log.warn("{}Invalid enumerated parameter value", msg);
                return true;
            }
            case 40963: {
                log.warn("{}Invalid parameter value", msg);
                return true;
            }
            case 40964: {
                log.warn("{}Requested operation is not valid", msg);
                return true;
            }
            case 40965: {
                log.warn("{}Out of memory", msg);
                return true;
            }
        }
        log.warn("{}Unrecognised error occurred", msg);
        return true;
    }

    public static boolean checkALCError(ALCdevice alcDevice) {
        return JoalAudioFactory.checkALCError(alcDevice, "");
    }

    public static boolean checkALCError(ALCdevice alcDevice, String msg) {
        if (((String)(msg = ((String)msg).trim())).length() > 0) {
            msg = (String)msg + " ";
        }
        switch (alc.alcGetError(alcDevice)) {
            case 0: {
                return false;
            }
            case 40961: {
                log.warn("{}Invalid device", msg);
                return true;
            }
            case 40962: {
                log.warn("{}Invalid context", msg);
                return true;
            }
            case 40963: {
                log.warn("{}Invalid enumerated parameter value", msg);
                return true;
            }
            case 40964: {
                log.warn("{}Invalid parameter value", msg);
                return true;
            }
            case 40965: {
                log.warn("{}Out of memory", msg);
                return true;
            }
        }
        log.warn("{}Unrecognised error occurred", msg);
        return true;
    }

    static {
        uiEffectSlots = new int[1];
        uiEffect = new int[1];
        initialised = false;
        AL_FORMAT_QUAD8 = 0;
        AL_FORMAT_QUAD16 = 0;
        AL_FORMAT_51CHN8 = 0;
        AL_FORMAT_51CHN16 = 0;
        AL_FORMAT_61CHN8 = 0;
        AL_FORMAT_61CHN16 = 0;
        AL_FORMAT_71CHN8 = 0;
        AL_FORMAT_71CHN16 = 0;
        log = LoggerFactory.getLogger(JoalAudioFactory.class);
    }
}

