/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import com.jogamp.openal.AL;
import javax.vecmath.Vector3f;
import jmri.jmrit.audio.AbstractAudioListener;
import jmri.jmrit.audio.JoalAudioFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoalAudioListener
extends AbstractAudioListener {
    private static AL al = JoalAudioFactory.getAL();
    private boolean initialised = false;
    private static final Logger log = LoggerFactory.getLogger(JoalAudioListener.class);

    public JoalAudioListener(String systemName) {
        super(systemName);
        if (log.isDebugEnabled()) {
            log.debug("New JoalAudioListener: {}", (Object)systemName);
        }
        this.initialised = this.init();
    }

    public JoalAudioListener(String systemName, String userName) {
        super(systemName, userName);
        if (log.isDebugEnabled()) {
            log.debug("New JoalAudioListener: {} ({})", (Object)userName, (Object)systemName);
        }
        this.initialised = this.init();
    }

    private boolean init() {
        return true;
    }

    @Override
    protected void changePosition(Vector3f pos) {
        if (this.initialised) {
            al.alListener3f(4100, pos.x, pos.y, pos.z);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating position of JoalAudioListener ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void setVelocity(Vector3f vel) {
        super.setVelocity(vel);
        if (this.initialised) {
            al.alListener3f(4102, vel.x, vel.y, vel.z);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating velocity setting of JoalAudioListener ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void setOrientation(Vector3f at, Vector3f up) {
        super.setOrientation(at, up);
        if (this.initialised) {
            al.alListenerfv(4111, new float[]{at.x, at.y, at.z, up.x, up.y, up.z}, 0);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating orientation of JoalAudioListener ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void setGain(float gain) {
        super.setGain(gain);
        if (this.initialised) {
            al.alListenerf(4106, gain);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating gain setting of JoalAudioListener ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void setMetersPerUnit(float metersPerUnit) {
        super.setMetersPerUnit(metersPerUnit);
        if (this.initialised) {
            al.alListenerf(131076, metersPerUnit);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating meters per unit setting of JoalAudioListener ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void stateChanged(int oldState) {
        super.stateChanged(oldState);
        if (this.initialised) {
            al.alListenerf(4106, this.getGain());
            al.alListener3f(4100, this.getCurrentPosition().x, this.getCurrentPosition().y, this.getCurrentPosition().z);
            al.alListener3f(4102, this.getVelocity().x, this.getVelocity().y, this.getVelocity().z);
            al.alListenerfv(4111, new float[]{this.getOrientation((int)1).x, this.getOrientation((int)1).y, this.getOrientation((int)1).z, this.getOrientation((int)2).x, this.getOrientation((int)2).y, this.getOrientation((int)2).z}, 0);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating JoalAudioListener ({})", (Object)this.getSystemName());
            }
        } else {
            this.initialised = this.init();
        }
    }

    @Override
    protected void cleanup() {
        if (log.isDebugEnabled()) {
            log.debug("Cleanup JoalAudioListener ({})", (Object)this.getSystemName());
        }
    }
}

