/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import com.jogamp.openal.AL;
import java.util.Queue;
import javax.vecmath.Vector3f;
import jmri.jmrit.audio.AbstractAudioSource;
import jmri.jmrit.audio.AbstractAudioThread;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.audio.JoalAudioBuffer;
import jmri.jmrit.audio.JoalAudioFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoalAudioSource
extends AbstractAudioSource {
    private static AL al = JoalAudioFactory.getAL();
    private boolean _initialised = false;
    private int[] _source = new int[1];
    private int[] _alState = new int[1];
    private static final Logger log = LoggerFactory.getLogger(JoalAudioSource.class);

    public JoalAudioSource(String systemName) {
        super(systemName);
        log.debug("New JoalAudioSource: {}", (Object)systemName);
        this._initialised = this.init();
    }

    public JoalAudioSource(String systemName, String userName) {
        super(systemName, userName);
        if (log.isDebugEnabled()) {
            log.debug("New JoalAudioSource: {} ({})", (Object)userName, (Object)systemName);
        }
        this._initialised = this.init();
    }

    private boolean init() {
        if (al == null) {
            log.warn("Al Factory not yet initialised");
            return false;
        }
        if (!this.isAudioAlive()) {
            log.debug("Command thread not yet alive...");
            return false;
        }
        log.debug("Command thread is alive - continue.");
        al.alGenSources(1, this._source, 0);
        if (JoalAudioFactory.checkALError()) {
            log.warn("Error creating JoalSource ({})", (Object)this.getSystemName());
            this._source = null;
            return false;
        }
        return true;
    }

    @Override
    public boolean queueAudioBuffer(AudioBuffer audioBuffer) {
        if (!this._initialised || !this.isAudioAlive()) {
            log.error("Source Not Initialized: {}", (Object)this.getSystemName());
            return false;
        }
        if (audioBuffer instanceof JoalAudioBuffer) {
            int[] bids = new int[]{((JoalAudioBuffer)audioBuffer).getDataStorageBuffer()[0]};
            if (log.isDebugEnabled()) {
                log.debug("Queueing Buffer: {} bid: {} Source: {}", new Object[]{audioBuffer.getSystemName(), ((JoalAudioBuffer)audioBuffer).getDataStorageBuffer()[0], this.getSystemName()});
            }
            al.alSourceQueueBuffers(this._source[0], 1, bids, 0);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error queueing JoalSource ({}) to AudioBuffers ({})", (Object)this.getSystemName(), (Object)audioBuffer.getDisplayName());
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("Queue JoalAudioBuffer ({}) to JoalAudioSource ({})", (Object)audioBuffer.getSystemName(), (Object)this.getSystemName());
            }
            return true;
        }
        throw new IllegalArgumentException(audioBuffer.getSystemName() + " is not a JoalAudioBuffer");
    }

    @Override
    public boolean queueAudioBuffers(Queue<AudioBuffer> audioBuffers) {
        AudioBuffer b;
        if (!this._initialised || !this.isAudioAlive()) {
            return false;
        }
        int[] bids = new int[1];
        int i = 0;
        while ((b = audioBuffers.poll()) != null) {
            if (!(b instanceof JoalAudioBuffer)) {
                throw new IllegalArgumentException(b.getSystemName() + " is not a JoalAudioBuffer");
            }
            bids[0] = ((JoalAudioBuffer)b).getDataStorageBuffer()[0];
            al.alSourceQueueBuffers(this._source[0], 1, bids, 0);
            if (log.isDebugEnabled()) {
                log.debug("Queueing Buffer [{}] {}", (Object)i, (Object)b.getSystemName());
            }
            ++i;
            if (!JoalAudioFactory.checkALError()) continue;
            log.warn("Error queueing JoalSource ({}) to AudioBuffers ({}) etc.", (Object)this.getSystemName(), (Object)b.getDisplayName());
            return false;
        }
        return true;
    }

    @Override
    public boolean unqueueAudioBuffers() {
        if (!this._initialised || !this.isAudioAlive()) {
            return false;
        }
        int[] num_processed = new int[1];
        al.alGetSourcei(this._source[0], 4118, num_processed, 0);
        if (JoalAudioFactory.checkALError()) {
            log.warn("Error getting # processed buffers from  JoalSource ({})", (Object)this.getSystemName());
            return false;
        }
        if (num_processed[0] > 0) {
            int[] bids = new int[num_processed[0]];
            al.alSourceUnqueueBuffers(this._source[0], num_processed[0], bids, 0);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error removing {} buffers from  JoalSource ({})", (Object)num_processed[0], (Object)this.getSystemName());
                return false;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Removed {} buffers from JoalAudioSource ({})", (Object)num_processed[0], (Object)this.getSystemName());
        }
        return this.numQueuedBuffers() != 0;
    }

    @Override
    public int numProcessedBuffers() {
        if (!this.isAudioAlive()) {
            return 0;
        }
        int[] num_processed = new int[1];
        al.alGetSourcei(this._source[0], 4118, num_processed, 0);
        if (JoalAudioFactory.checkALError()) {
            log.warn("Error getting # processed buffers from  JoalSource ({})", (Object)this.getSystemName());
            return 0;
        }
        return num_processed[0];
    }

    @Override
    public int numQueuedBuffers() {
        if (!this._initialised || !this.isAudioAlive()) {
            return 0;
        }
        int[] num_queued = new int[1];
        al.alGetSourcei(this._source[0], 4117, num_queued, 0);
        if (JoalAudioFactory.checkALError()) {
            log.warn("Error getting # queued buffers from  JoalSource ({})", (Object)this.getSystemName());
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug("Queued {} buffers on JoalAudioSource ({})", (Object)num_queued[0], (Object)this.getSystemName());
        }
        return num_queued[0];
    }

    @Override
    boolean bindAudioBuffer(AudioBuffer audioBuffer) {
        if (!this._initialised || !this.isAudioAlive()) {
            return false;
        }
        al.alSourcei(this._source[0], 4105, ((JoalAudioBuffer)audioBuffer).getDataStorageBuffer()[0]);
        if (JoalAudioFactory.checkALError()) {
            log.warn("Error binding JoalSource ({}) to AudioBuffer ({})", (Object)this.getSystemName(), (Object)this.getAssignedBufferName());
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Bind JoalAudioSource ({}) to JoalAudioBuffer ({})", (Object)this.getSystemName(), (Object)audioBuffer.getSystemName());
        }
        return true;
    }

    @Override
    protected void changePosition(Vector3f pos) {
        if (this._initialised && this.isAudioAlive() && this._source != null) {
            al.alSource3f(this._source[0], 4100, pos.x, pos.y, pos.z);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating position of JoalAudioSource ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void setPositionRelative(boolean relative) {
        super.setPositionRelative(relative);
        if (this._initialised && this.isAudioAlive()) {
            al.alSourcei(this._source[0], 514, relative ? 1 : 0);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating relative position property of JoalAudioSource ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void setVelocity(Vector3f vel) {
        super.setVelocity(vel);
        if (this._initialised && this.isAudioAlive()) {
            al.alSource3f(this._source[0], 4102, vel.x, vel.y, vel.z);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating velocity of JoalAudioSource ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void setGain(float gain) {
        super.setGain(gain);
        if (this._initialised && this.isAudioAlive()) {
            this.calculateGain();
        }
    }

    @Override
    public void setPitch(float pitch) {
        super.setPitch(pitch);
        if (this._initialised && this.isAudioAlive()) {
            al.alSourcef(this._source[0], 4099, pitch);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating pitch of JoalAudioSource ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void setReferenceDistance(float referenceDistance) {
        super.setReferenceDistance(referenceDistance);
        if (this._initialised && this.isAudioAlive()) {
            al.alSourcef(this._source[0], 4128, referenceDistance);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating reference distance of JoalAudioSource ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void setOffset(long offset) {
        super.setOffset(offset);
        if (this._initialised && this.isAudioAlive()) {
            al.alSourcei(this._source[0], 4133, (int)this.getOffset());
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating Sample Offset of JoalAudioSource ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void setMaximumDistance(float maximumDistance) {
        super.setMaximumDistance(maximumDistance);
        if (this._initialised && this.isAudioAlive()) {
            al.alSourcef(this._source[0], 4131, maximumDistance);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating maximum distance of JoalAudioSource ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public void setRollOffFactor(float rollOffFactor) {
        super.setRollOffFactor(rollOffFactor);
        if (this._initialised && this.isAudioAlive()) {
            al.alSourcef(this._source[0], 4129, rollOffFactor);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating roll-off factor of JoalAudioSource ({})", (Object)this.getSystemName());
            }
        }
    }

    @Override
    public int getState() {
        if (this._source != null && this.isAudioAlive()) {
            int old = this._alState[0];
            al.alGetSourcei(this._source[0], 4112, this._alState, 0);
            if (this._alState[0] != old) {
                if (this._alState[0] == 4114) {
                    this.setState(17);
                } else {
                    this.setState(16);
                }
            }
            return super.getState();
        }
        return 16;
    }

    @Override
    public void stateChanged(int oldState) {
        super.stateChanged(oldState);
        if (this._initialised && this.isAudioAlive()) {
            if (this._source != null) {
                al.alSourcef(this._source[0], 4099, this.getPitch());
                al.alSourcef(this._source[0], 4106, this.getGain());
                al.alSource3f(this._source[0], 4100, this.getCurrentPosition().x, this.getCurrentPosition().y, this.getCurrentPosition().z);
                al.alSource3f(this._source[0], 4102, this.getVelocity().x, this.getVelocity().y, this.getVelocity().z);
                al.alSourcei(this._source[0], 4103, this.isLooped() ? 1 : 0);
                if (JoalAudioFactory.checkALError()) {
                    log.warn("Error updating JoalAudioSource ({})", (Object)this.getSystemName());
                }
            }
        } else {
            this._initialised = this.init();
        }
    }

    @Override
    public int attachSourcesToEffects() {
        if (!this.isAudioAlive()) {
            return 0;
        }
        al.alSource3i(this._source[0], 131078, 1, 0, 0);
        if (JoalAudioFactory.checkALError()) {
            log.warn("Failed to configure source send 1");
            return 0;
        }
        return 1;
    }

    @Override
    public int detachSourcesToEffects() {
        if (!this.isAudioAlive()) {
            return 0;
        }
        al.alSource3i(this._source[0], 131078, 0, 0, 0);
        if (JoalAudioFactory.checkALError()) {
            log.warn("Failed to detach");
            return 0;
        }
        return 1;
    }

    @Override
    protected void doPlay() {
        log.debug("Play JoalAudioSource ({})", (Object)this.getSystemName());
        if (this._initialised && this.isAudioAlive() && (this.isBound() || this.isQueued())) {
            this.doRewind();
            this.doResume();
        }
    }

    @Override
    protected void doStop() {
        log.debug("Stop JoalAudioSource ({})", (Object)this.getSystemName());
        if (this._source != null) {
            boolean stopped;
            if (this._initialised && this.isAudioAlive() && (this.isBound() || this.isQueued())) {
                al.alSourceStop(this._source[0]);
                this.doRewind();
            }
            int[] myState = new int[1];
            al.alGetSourcei(this._source[0], 4112, myState, 0);
            boolean bl = stopped = myState[0] != 4103;
            while (!stopped) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                al.alGetSourcei(this._source[0], 4112, myState, 0);
                stopped = myState[0] != 4103;
            }
            this.setState(16);
        }
    }

    @Override
    protected void doPause() {
        log.debug("Pause JoalAudioSource ({})", (Object)this.getSystemName());
        if (this._initialised && this.isAudioAlive() && (this.isBound() || this.isQueued())) {
            al.alSourcePause(this._source[0]);
        }
        this.setState(16);
    }

    @Override
    protected void doResume() {
        log.debug("Resume JoalAudioSource ({})", (Object)this.getSystemName());
        if (this._initialised && this.isAudioAlive() && (this.isBound() || this.isQueued())) {
            this.calculateGain();
            al.alSourcei(this._source[0], 4103, this.isLooped() ? 1 : 0);
            al.alSourcePlay(this._source[0]);
            int numLoops = this.getNumLoops();
            if (numLoops > 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Create LoopThread for JoalAudioSource {}", (Object)this.getSystemName());
                }
                AudioSourceLoopThread aslt = new AudioSourceLoopThread(this, numLoops);
                aslt.start();
            }
        }
        this.setState(17);
    }

    @Override
    protected void doRewind() {
        log.debug("Rewind JoalAudioSource ({})", (Object)this.getSystemName());
        if (this._initialised && this.isAudioAlive() && (this.isBound() || this.isQueued())) {
            al.alSourceRewind(this._source[0]);
        }
    }

    @Override
    protected void doFadeIn() {
        log.debug("Fade-in JoalAudioSource ({})", (Object)this.getSystemName());
        if (this._initialised && this.isAudioAlive() && (this.isBound() || this.isQueued())) {
            this.doPlay();
            AbstractAudioSource.AudioSourceFadeThread asft = new AbstractAudioSource.AudioSourceFadeThread(this);
            asft.start();
        }
    }

    @Override
    protected void doFadeOut() {
        log.debug("Fade-out JoalAudioSource ({})", (Object)this.getSystemName());
        if (this._initialised && this.isAudioAlive() && (this.isBound() || this.isQueued())) {
            AbstractAudioSource.AudioSourceFadeThread asft = new AbstractAudioSource.AudioSourceFadeThread(this);
            asft.start();
        }
    }

    @Override
    protected void cleanup() {
        log.debug("Cleanup JoalAudioSource ({})", (Object)this.getSystemName());
        int[] source_type = new int[1];
        al.alGetSourcei(this._source[0], 4135, source_type, 0);
        if (this._initialised && (this.isBound() || this.isQueued() || source_type[0] == 4144) || source_type[0] == 4137) {
            al.alSourceStop(this._source[0]);
            al.alDeleteSources(1, this._source, 0);
            this._source = null;
            log.debug("...done cleanup");
        }
    }

    @Override
    protected void calculateGain() {
        float currentGain = this.getGain() * this.getFadeGain();
        if (this._initialised && this.isAudioAlive()) {
            al.alSourcef(this._source[0], 4106, currentGain);
            if (JoalAudioFactory.checkALError()) {
                log.warn("Error updating gain setting of JoalAudioSource ({})", (Object)this.getSystemName());
            }
            if (log.isDebugEnabled()) {
                log.debug("Set current gain of JoalAudioSource {} to {}", (Object)this.getSystemName(), (Object)Float.valueOf(currentGain));
            }
        }
    }

    private int[] getSourceBuffer() {
        return this._source;
    }

    private static class AudioSourceLoopThread
    extends AbstractAudioThread {
        private int numLoops;
        private int[] sourceBuffer;

        AudioSourceLoopThread(JoalAudioSource audioSource, int numLoops) {
            this.setName("loopsrc-" + super.getName());
            this.sourceBuffer = audioSource.getSourceBuffer();
            this.numLoops = numLoops;
            if (log.isDebugEnabled()) {
                log.debug("Created AudioSourceLoopThread for AudioSource {} loopcount {}", (Object)audioSource.getSystemName(), (Object)this.numLoops);
            }
        }

        @Override
        public void run() {
            int loopCount = 0;
            float oldPos = 0.0f;
            float[] newPos = new float[1];
            al.alSourcei(this.sourceBuffer[0], 4103, 1);
            while (!this.dying()) {
                al.alGetSourcef(this.sourceBuffer[0], 4132, newPos, 0);
                if (oldPos > newPos[0]) {
                    log.debug("Loop count {}", (Object)(++loopCount));
                }
                oldPos = newPos[0];
                if (loopCount >= this.numLoops) {
                    this.die();
                }
                AudioSourceLoopThread.snooze(20L);
            }
            al.alSourcei(this.sourceBuffer[0], 4103, 0);
            if (log.isDebugEnabled()) {
                log.debug("Clean up thread {}", (Object)this.getName());
            }
            this.cleanup();
        }

        @Override
        protected void cleanup() {
            this.die();
            this.sourceBuffer = null;
            super.cleanup();
        }
    }
}

