/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import java.io.InputStream;
import jmri.jmrit.audio.AbstractAudioBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullAudioBuffer
extends AbstractAudioBuffer {
    private static final Logger log = LoggerFactory.getLogger(NullAudioBuffer.class);

    public NullAudioBuffer(String systemName) {
        super(systemName);
        if (log.isDebugEnabled()) {
            log.debug("New NullAudioBuffer: {}", (Object)systemName);
        }
    }

    public NullAudioBuffer(String systemName, String userName) {
        super(systemName, userName);
        if (log.isDebugEnabled()) {
            log.debug("New NullAudioBuffer: {} ({})", (Object)userName, (Object)systemName);
        }
    }

    @Override
    protected boolean loadBuffer(InputStream stream) {
        return true;
    }

    @Override
    protected boolean loadBuffer() {
        return true;
    }

    @Override
    protected void generateLoopBuffers(int which) {
    }

    @Override
    protected boolean generateStreamingBuffers() {
        return true;
    }

    @Override
    protected void removeStreamingBuffers() {
    }

    @Override
    public int getFormat() {
        return 0;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public int getFrequency() {
        return 0;
    }

    @Override
    protected void cleanup() {
        if (log.isDebugEnabled()) {
            log.debug("Cleanup NullAudioBuffer ({})", (Object)this.getSystemName());
        }
    }
}

