/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.TreeSet;
import jmri.Audio;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.Version;
import jmri.jmrit.audio.AbstractAudioFactory;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.audio.NullAudioBuffer;
import jmri.jmrit.audio.NullAudioListener;
import jmri.jmrit.audio.NullAudioSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullAudioFactory
extends AbstractAudioFactory {
    private static boolean initialised = false;
    private NullAudioListener activeAudioListener;
    private static final Logger log = LoggerFactory.getLogger(NullAudioFactory.class);

    @Override
    public boolean init() {
        if (initialised) {
            return true;
        }
        log.info("Initialised Null audio system - no sounds will be available.");
        super.init();
        NullAudioFactory.setInit(true);
        return true;
    }

    private static synchronized void setInit(boolean newVal) {
        initialised = newVal;
    }

    public String toString() {
        return "NullAudioFactory: vendor - JMRI Community version - " + Version.name();
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="OK to write to static variables to record static library status")
    public void cleanup() {
        super.cleanup();
        AudioManager am = InstanceManager.getDefault(AudioManager.class);
        TreeSet<Audio> sources = new TreeSet<Audio>(am.getNamedBeanSet('S'));
        for (Audio audio : sources) {
            if (log.isDebugEnabled()) {
                log.debug("Removing NullAudioSource: {}", (Object)audio.getSystemName());
            }
            audio.dispose();
        }
        TreeSet<Audio> buffers = new TreeSet<Audio>(am.getNamedBeanSet('B'));
        for (Audio buffer : buffers) {
            if (log.isDebugEnabled()) {
                log.debug("Removing NullAudioBuffer: {}", (Object)buffer.getSystemName());
            }
            buffer.dispose();
        }
        TreeSet<Audio> treeSet = new TreeSet<Audio>(am.getNamedBeanSet('L'));
        for (Audio listener : treeSet) {
            if (log.isDebugEnabled()) {
                log.debug("Removing NullAudioListener: {}", (Object)listener.getSystemName());
            }
            listener.dispose();
        }
        log.debug("Shutting down NullAudio");
        initialised = false;
    }

    @Override
    public boolean isInitialised() {
        return initialised;
    }

    @Override
    public AudioBuffer createNewBuffer(String systemName, String userName) {
        return new NullAudioBuffer(systemName, userName);
    }

    @Override
    public AudioListener createNewListener(String systemName, String userName) {
        this.activeAudioListener = new NullAudioListener(systemName, userName);
        return this.activeAudioListener;
    }

    @Override
    public AudioListener getActiveAudioListener() {
        return this.activeAudioListener;
    }

    @Override
    public AudioSource createNewSource(String systemName, String userName) {
        return new NullAudioSource(systemName, userName);
    }
}

