/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio.swing;

import java.awt.FlowLayout;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.vecmath.Vector3f;
import jmri.Audio;
import jmri.implementation.AbstractAudio;
import jmri.jmrit.audio.swing.Bundle;
import jmri.jmrit.beantable.AudioTableAction;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;

public abstract class AbstractAudioFrame
extends JmriJFrame {
    AbstractAudioFrame frame = this;
    JPanel main = new JPanel();
    private JScrollPane scroll = new JScrollPane(this.main, 22, 31);
    AudioTableAction.AudioTableDataModel model;
    private static final int INT_PRECISION = (int)Math.pow(10.0, 2.0);
    static final float FLT_PRECISION = 1.0f / (float)INT_PRECISION;
    private static final JLabel SYS_NAME_LABEL = new JLabel(Bundle.getMessage("LabelSystemName"));
    JTextField sysName = new JTextField(5);
    private static final JLabel USER_NAME_LABEL = new JLabel(Bundle.getMessage("LabelUserName"));
    JTextField userName = new JTextField(15);

    public AbstractAudioFrame(String title, AudioTableAction.AudioTableDataModel model) {
        super(title);
        this.model = model;
    }

    public void layoutFrame() {
        this.frame.addHelpMenu("package.jmri.jmrit.beantable.AudioAddEdit", true);
        this.frame.getContentPane().setLayout(new BoxLayout(this.frame.getContentPane(), 1));
        this.main.setLayout(new BoxLayout(this.main, 1));
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(SYS_NAME_LABEL);
        p.add(this.sysName);
        this.frame.getContentPane().add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.add(USER_NAME_LABEL);
        p.add(this.userName);
        this.frame.getContentPane().add(p);
        this.frame.add(this.scroll);
    }

    public abstract void resetFrame();

    public void populateFrame(Audio a) {
        this.sysName.setText(a.getSystemName());
        this.userName.setText(a.getUserName());
    }

    protected boolean entryError(String entry, String prefix, String counter) {
        if (!entry.startsWith(prefix)) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("AudioCreateError", prefix), Bundle.getMessage("AudioCreateErrorTitle"), 0);
            this.sysName.setText(prefix + counter);
            return true;
        }
        return false;
    }

    protected static class JPanelSliderf
    extends JPanel {
        JSlider slider = new JSlider();
        JSpinner spinner = new JSpinner();

        JPanelSliderf(String title, Float min, Float max, int majorTicks, int minorTicks) {
            int iMin = Math.round(min.floatValue() * (float)INT_PRECISION);
            int iMax = Math.round(max.floatValue() * (float)INT_PRECISION);
            int iInterval = (iMax - iMin) / majorTicks;
            this.setLayout(new FlowLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.slider.setMinimum(Math.round(min.floatValue() * (float)INT_PRECISION));
            this.slider.setMaximum(Math.round(max.floatValue() * (float)INT_PRECISION));
            this.slider.setMajorTickSpacing(iInterval);
            this.slider.setMinorTickSpacing(iInterval / minorTicks);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            for (int i = iMin; i <= iMax; i += iInterval) {
                float f = i;
                labelTable.put(i, new JLabel(Float.toString(f /= (float)INT_PRECISION)));
            }
            this.slider.setLabelTable(labelTable);
            this.slider.setPaintTicks(true);
            this.slider.setPaintLabels(true);
            this.slider.addChangeListener(e -> {
                float f = this.slider.getValue();
                this.spinner.setValue(Float.valueOf(f /= (float)INT_PRECISION));
            });
            this.spinner.setPreferredSize(new JTextField(5).getPreferredSize());
            this.spinner.setModel(new SpinnerNumberModel(min, min, max, Float.valueOf(FLT_PRECISION)));
            this.spinner.setEditor(new JSpinner.NumberEditor(this.spinner, "0.00"));
            this.spinner.addChangeListener(e -> this.slider.setValue(Math.round(((Float)this.spinner.getValue()).floatValue() * (float)INT_PRECISION)));
            this.add(this.slider);
            this.add(this.spinner);
        }

        public void setValue(float value) {
            this.spinner.setValue(Float.valueOf(value));
        }

        public float getValue() {
            return AbstractAudio.roundDecimal(((Float)this.spinner.getValue()).floatValue());
        }
    }

    protected static class JPanelVector3f
    extends JPanel {
        JLabel xLabel = new JLabel(Bundle.getMessage("LabelX"));
        JSpinner xValue = new JSpinner();
        JLabel yLabel = new JLabel(Bundle.getMessage("LabelY"));
        JSpinner yValue = new JSpinner();
        JLabel zLabel = new JLabel(Bundle.getMessage("LabelZ"));
        JSpinner zValue = new JSpinner();
        JLabel unitsLabel = new JLabel();

        JPanelVector3f() {
            this.layoutPanel("", "");
        }

        JPanelVector3f(String title) {
            this.layoutPanel(title, "");
        }

        JPanelVector3f(String title, String units) {
            this.layoutPanel(title, units);
        }

        private void layoutPanel(String title, String units) {
            this.setLayout(new FlowLayout());
            if (title.length() != 0) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            }
            this.add(this.xLabel);
            this.xValue.setPreferredSize(new JTextField(8).getPreferredSize());
            this.xValue.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(-9999.99f), Float.valueOf(9999.99f), Float.valueOf(FLT_PRECISION)));
            this.xValue.setEditor(new JSpinner.NumberEditor(this.xValue, "0.00"));
            this.add(this.xValue);
            this.add(this.yLabel);
            this.yValue.setPreferredSize(new JTextField(8).getPreferredSize());
            this.yValue.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(-9999.99f), Float.valueOf(9999.99f), Float.valueOf(FLT_PRECISION)));
            this.yValue.setEditor(new JSpinner.NumberEditor(this.yValue, "0.00"));
            this.add(this.yValue);
            this.add(this.zLabel);
            this.zValue.setPreferredSize(new JTextField(8).getPreferredSize());
            this.zValue.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(-9999.99f), Float.valueOf(9999.99f), Float.valueOf(FLT_PRECISION)));
            this.zValue.setEditor(new JSpinner.NumberEditor(this.zValue, "0.00"));
            this.add(this.zValue);
            if (units.length() != 0) {
                this.unitsLabel.setText(units);
                this.add(this.unitsLabel);
            }
        }

        public void setValue(Vector3f value) {
            this.xValue.setValue(Float.valueOf(value.x));
            this.yValue.setValue(Float.valueOf(value.y));
            this.zValue.setValue(Float.valueOf(value.z));
        }

        public Vector3f getValue() {
            return new Vector3f(AbstractAudio.roundDecimal(((Float)this.xValue.getValue()).floatValue()), AbstractAudio.roundDecimal(((Float)this.yValue.getValue()).floatValue()), AbstractAudio.roundDecimal(((Float)this.zValue.getValue()).floatValue()));
        }
    }
}

