/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio.swing;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.Audio;
import jmri.AudioException;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.jmrit.audio.AudioBuffer;
import jmri.jmrit.audio.swing.AbstractAudioFrame;
import jmri.jmrit.audio.swing.Bundle;
import jmri.jmrit.beantable.AudioTableAction;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJFileChooser;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioBufferFrame
extends AbstractAudioFrame {
    private static int counter = 1;
    private boolean newBuffer;
    private final Object lock = new Object();
    JLabel urlLabel = new JLabel(Bundle.getMessage("MakeLabel", Bundle.getMessage("LabelURL")));
    JTextField url = new JTextField(40);
    JButton buttonBrowse = new JButton("...");
    JCheckBox stream = new JCheckBox(Bundle.getMessage("LabelStream"));
    JLabel loopStartLabel = new JLabel(Bundle.getMessage("LabelLoopStart"));
    JSpinner loopStart = new JSpinner();
    JLabel loopEndLabel = new JLabel(Bundle.getMessage("LabelLoopEnd"));
    JSpinner loopEnd = new JSpinner();
    JFileChooser fileChooser;
    private static final String PREFIX = "IAB";
    private static final Logger log = LoggerFactory.getLogger(AudioBufferFrame.class);

    public AudioBufferFrame(String title, AudioTableAction.AudioTableDataModel model) {
        super(title, model);
        this.layoutFrame();
        this.loopStart.setEnabled(false);
        this.loopStartLabel.setEnabled(false);
        this.loopEnd.setEnabled(false);
        this.loopEndLabel.setEnabled(false);
    }

    @Override
    public void layoutFrame() {
        super.layoutFrame();
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LabelSample")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        p2.add(this.urlLabel);
        p2.add(this.url);
        this.buttonBrowse.addActionListener(this::browsePressed);
        this.buttonBrowse.setToolTipText(Bundle.getMessage("ToolTipButtonBrowse"));
        p2.add(this.buttonBrowse);
        p.add(p2);
        p2 = new JPanel();
        p2.setLayout(new FlowLayout());
        p2.add(this.stream);
        p.add(p2);
        this.main.add(p);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LabelLoopPoints")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        p.add(this.loopStartLabel);
        this.loopStart.setPreferredSize(new JTextField(8).getPreferredSize());
        this.loopStart.setModel(new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE), (Number)1L));
        this.loopStart.addChangeListener(e -> this.loopEnd.setValue((Long)this.loopStart.getValue() < (Long)this.loopEnd.getValue() ? this.loopEnd.getValue() : this.loopStart.getValue()));
        p.add(this.loopStart);
        p.add(this.loopEndLabel);
        this.loopEnd.setPreferredSize(new JTextField(8).getPreferredSize());
        this.loopEnd.setModel(new SpinnerNumberModel((Number)0L, Long.valueOf(0L), Long.valueOf(Long.MAX_VALUE), (Number)1L));
        this.loopEnd.addChangeListener(e -> this.loopStart.setValue((Long)this.loopEnd.getValue() < (Long)this.loopStart.getValue() ? this.loopEnd.getValue() : this.loopStart.getValue()));
        p.add(this.loopEnd);
        this.main.add(p);
        p = new JPanel();
        JButton apply = new JButton(Bundle.getMessage("ButtonApply"));
        p.add(apply);
        apply.addActionListener(e -> this.applyPressed(e));
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        p.add(ok);
        ok.addActionListener(e -> {
            if (this.applyPressed(e)) {
                this.frame.dispose();
            }
        });
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        p.add(cancel);
        cancel.addActionListener(e -> this.frame.dispose());
        this.frame.getContentPane().add(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetFrame() {
        Object object = this.lock;
        synchronized (object) {
            this.sysName.setText(PREFIX + AudioBufferFrame.nextCounter());
        }
        this.userName.setText(null);
        this.url.setText(null);
        this.stream.setSelected(false);
        this.stream.setEnabled(false);
        this.loopStart.setValue(0L);
        this.loopEnd.setValue(0L);
        this.newBuffer = true;
    }

    @Override
    public void populateFrame(Audio a) {
        if (!(a instanceof AudioBuffer)) {
            throw new IllegalArgumentException(a.getSystemName() + " is not an AudioBuffer object");
        }
        super.populateFrame(a);
        AudioBuffer b = (AudioBuffer)a;
        this.url.setText(b.getURL());
        this.stream.setSelected(b.isStreamed());
        this.stream.setEnabled(false);
        this.loopStart.setValue(b.getStartLoopPoint());
        this.loopEnd.setValue(b.getEndLoopPoint());
        this.loopStart.setEnabled(true);
        this.loopStartLabel.setEnabled(true);
        this.loopEnd.setEnabled(true);
        this.loopEndLabel.setEnabled(true);
        this.newBuffer = false;
    }

    void browsePressed(ActionEvent e) {
        if (this.fileChooser == null) {
            this.fileChooser = new JmriJFileChooser("resources" + File.separator + "sounds" + File.separator);
            this.fileChooser.setFileFilter(new FileNameExtensionFilter("Audio Files (*.wav)", "wav"));
        }
        this.fileChooser.rescanCurrentDirectory();
        int retValue = this.fileChooser.showOpenDialog(this);
        if (retValue == 0) {
            File file = this.fileChooser.getSelectedFile();
            String fileName = FileUtil.getPortableFilename(file);
            if (!this.url.getText().equals(fileName)) {
                this.url.setText(fileName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean applyPressed(ActionEvent e) {
        String sName = this.sysName.getText();
        if (this.entryError(sName, PREFIX, "" + counter)) {
            return false;
        }
        String user = this.userName.getText();
        if (user.equals("")) {
            user = null;
        }
        try {
            AudioBuffer b;
            AudioManager am = InstanceManager.getDefault(AudioManager.class);
            if (this.newBuffer && am.getBySystemName(sName) != null) {
                throw new AudioException(Bundle.getMessage("DuplicateSystemName"));
            }
            try {
                b = (AudioBuffer)am.provideAudio(sName);
            }
            catch (IllegalArgumentException ex) {
                throw new AudioException(Bundle.getMessage("ProblemCreatingBuffer"));
            }
            if (user != null && this.newBuffer && am.getByUserName(user) != null) {
                am.deregister(b);
                Object object = this.lock;
                synchronized (object) {
                    AudioBufferFrame.prevCounter();
                }
                throw new AudioException(Bundle.getMessage("DuplicateUserName"));
            }
            b.setUserName(user);
            b.setStreamed(this.stream.isSelected());
            if (this.newBuffer || !b.getURL().equals(this.url.getText())) {
                b.setURL(this.url.getText());
                log.debug("After load, end loop point = {}", (Object)b.getEndLoopPoint());
            } else if (!b.getURL().equals(this.url.getText())) {
                log.debug("Sound changed from: {}", (Object)b.getURL());
                b.setURL(this.url.getText());
            }
            this.stream.setSelected(b.isStreamed());
            this.stream.setEnabled(false);
            this.model.fireTableDataChanged();
        }
        catch (AudioException ex) {
            JmriJOptionPane.showMessageDialog(this, ex.getMessage(), Bundle.getMessage("AudioCreateErrorTitle"), 0);
            return false;
        }
        this.newBuffer = false;
        return true;
    }

    private static int nextCounter() {
        return counter++;
    }

    private static void prevCounter() {
        --counter;
    }
}

