/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.audio.swing;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jmri.Audio;
import jmri.AudioException;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.implementation.AbstractAudio;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.swing.AbstractAudioFrame;
import jmri.jmrit.audio.swing.Bundle;
import jmri.jmrit.beantable.AudioTableAction;
import jmri.util.swing.JmriJOptionPane;

public class AudioListenerFrame
extends AbstractAudioFrame {
    AbstractAudioFrame.JPanelVector3f position = new AbstractAudioFrame.JPanelVector3f(Bundle.getMessage("LabelPosition"), Bundle.getMessage("UnitUnits"));
    AbstractAudioFrame.JPanelVector3f velocity = new AbstractAudioFrame.JPanelVector3f(Bundle.getMessage("LabelVelocity"), Bundle.getMessage("UnitU/S"));
    JLabel oriAtLabel = new JLabel(Bundle.getMessage("LabelOrientationAt"));
    AbstractAudioFrame.JPanelVector3f oriAt = new AbstractAudioFrame.JPanelVector3f("", Bundle.getMessage("UnitUnits"));
    JLabel oriUpLabel = new JLabel(Bundle.getMessage("LabelOrientationUp"));
    AbstractAudioFrame.JPanelVector3f oriUp = new AbstractAudioFrame.JPanelVector3f("", Bundle.getMessage("UnitUnits"));
    AbstractAudioFrame.JPanelSliderf gain = new AbstractAudioFrame.JPanelSliderf(Bundle.getMessage("LabelGain"), Float.valueOf(0.0f), Float.valueOf(1.0f), 5, 4);
    JSpinner metersPerUnit = new JSpinner();
    JLabel metersPerUnitLabel = new JLabel(Bundle.getMessage("UnitM/U"));
    private static final String PREFIX = "IAL";

    public AudioListenerFrame(String title, AudioTableAction.AudioTableDataModel model) {
        super(title, model);
        this.layoutFrame();
    }

    @Override
    public void layoutFrame() {
        super.layoutFrame();
        this.main.add(this.position);
        this.main.add(this.velocity);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LabelOrientation")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        p.add(this.oriAtLabel);
        p.add(this.oriAt);
        p.add(this.oriUpLabel);
        p.add(this.oriUp);
        this.main.add(p);
        this.main.add(this.gain);
        p = new JPanel();
        p.setLayout(new FlowLayout());
        p.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LabelMetersPerUnit")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.metersPerUnit.setPreferredSize(new JTextField(8).getPreferredSize());
        this.metersPerUnit.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(65536.0f), Float.valueOf(1.0E-4f)));
        this.metersPerUnit.setEditor(new JSpinner.NumberEditor(this.metersPerUnit, "0.0000"));
        p.add(this.metersPerUnit);
        p.add(this.metersPerUnitLabel);
        this.main.add(p);
        p = new JPanel();
        JButton apply = new JButton(Bundle.getMessage("ButtonApply"));
        p.add(apply);
        apply.addActionListener(e -> this.applyPressed(e));
        JButton ok = new JButton(Bundle.getMessage("ButtonOK"));
        p.add(ok);
        ok.addActionListener(e -> {
            this.applyPressed(e);
            this.frame.dispose();
        });
        JButton cancel = new JButton(Bundle.getMessage("ButtonCancel"));
        p.add(cancel);
        cancel.addActionListener(e -> this.frame.dispose());
        this.frame.getContentPane().add(p);
    }

    @Override
    public void resetFrame() {
    }

    @Override
    public void populateFrame(Audio a) {
        if (!(a instanceof AudioListener)) {
            throw new IllegalArgumentException(a.getSystemName() + " is not an AudioListener object");
        }
        super.populateFrame(a);
        AudioListener l = (AudioListener)a;
        this.position.setValue(l.getPosition());
        this.velocity.setValue(l.getVelocity());
        this.oriAt.setValue(l.getOrientation(1));
        this.oriUp.setValue(l.getOrientation(2));
        this.gain.setValue(l.getGain());
        this.metersPerUnit.setValue(Float.valueOf(l.getMetersPerUnit()));
    }

    private void applyPressed(ActionEvent e) {
        String sName = this.sysName.getText();
        if (this.entryError(sName, PREFIX, "$")) {
            return;
        }
        String user = this.userName.getText();
        if (user.equals("")) {
            user = null;
        }
        try {
            AudioListener l = (AudioListener)InstanceManager.getDefault(AudioManager.class).provideAudio(sName);
            l.setUserName(user);
            l.setPosition(this.position.getValue());
            l.setVelocity(this.velocity.getValue());
            l.setOrientation(this.oriAt.getValue(), this.oriUp.getValue());
            l.setGain(this.gain.getValue());
            l.setMetersPerUnit(AbstractAudio.roundDecimal(((Float)this.metersPerUnit.getValue()).floatValue(), 4.0));
            this.model.fireTableDataChanged();
        }
        catch (IllegalArgumentException | AudioException ex) {
            JmriJOptionPane.showMessageDialog(this, ex.getMessage(), Bundle.getMessage("AudioCreateErrorTitle"), 0);
        }
    }
}

