/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.automat;

import jmri.AddressedProgrammerManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Programmer;
import jmri.Sensor;
import jmri.jmrit.automat.AbstractAutomaton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleAutomaton2
extends AbstractAutomaton {
    Programmer programmer;
    Sensor sensor;
    String sensorName = "31";
    int locoNumber = 1234;
    boolean locoLong = true;
    int now;
    private static final Logger log = LoggerFactory.getLogger(SampleAutomaton2.class);

    @Override
    protected void init() {
        this.sensor = InstanceManager.sensorManagerInstance().provideSensor(this.sensorName);
        this.programmer = InstanceManager.getDefault(AddressedProgrammerManager.class).getAddressedProgrammer(this.locoLong, this.locoNumber);
        this.now = this.sensor.getKnownState();
        this.setMomentum(this.now);
    }

    @Override
    protected boolean handle() {
        log.debug("Waiting for state change");
        this.waitSensorChange(this.now, this.sensor);
        this.now = this.sensor.getKnownState();
        log.debug("Found new state: {}", (Object)this.now);
        this.setMomentum(this.now);
        return true;
    }

    void setMomentum(int now) {
        try {
            if (now == 2) {
                this.programmer.writeCV("3", 30, null);
            } else {
                this.programmer.writeCV("3", 0, null);
            }
        }
        catch (JmriException e) {
            log.error("exception setting turnout", (Throwable)e);
        }
    }
}

